/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.archive;

import java.util.Map;

import org.ametys.runtime.i18n.I18nizableText;

/**
 * A partial import, i.e. an element which is importable, proposed to the end user.
 */
public interface PartialImport
{
    /**
     * Gets the key. Must be unique across the whole application (you should prefix it, for instance "plugins/my-plugin").
     * @return the key
     */
    String getKey();
    
    /**
     * Gets the label
     * @return the label
     */
    I18nizableText getLabel();
    
    /**
     * Jsonify this partial import for client-side
     * @return the JSON representation of this partial import
     */
    default Map<String, Object> toJson()
    {
        return Map.of(
                "key", getKey(), 
                "label", getLabel());
    }
    
    /**
     * Builds a partial import.
     * @param key the key
     * @param label the label
     * @return a partial import
     */
    public static PartialImport of(String key, I18nizableText label)
    {
        return new PartialImport()
        {
            @Override
            public String getKey()
            {
                return key;
            }
            
            @Override
            public I18nizableText getLabel()
            {
                return label;
            }
        };
    }
}
