/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.csv;

import java.util.Map;

import org.apache.cocoon.servlet.multipart.Part;

import org.ametys.core.ui.Callable;

/**
 * Import contents from an uploaded CSV file.
 */
public class ImportReferenceTablesCSVFile extends ImportCSVFile
{
    /** Avalon Role */
    @SuppressWarnings("hiding")
    public static final String ROLE = ImportReferenceTablesCSVFile.class.getName();
    
    /**
     * Import CSV file
     * @implNote Override to change the rights to check for the {@link Callable}
     */
    @Callable (rights = "CMS_Rights_ReferenceTables_Import", context = "/cms")
    @Override
    public Map importCSVFile(String escapingChar, String separatingChar, String contentTypeId, Part part) throws Exception
    {
        return super.importCSVFile(escapingChar, separatingChar, contentTypeId, part);
    }
}
