/*
 *  Copyright 2018 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.export.sql;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;

import org.ametys.core.ui.AddTaskClientSideElement;
import org.ametys.core.ui.Callable;
import org.ametys.runtime.config.Config;

/**
 * This export content client site element
 */
public class ExportClientSiteElement extends AddTaskClientSideElement
{
    @Override
    protected String _configureClass(Configuration configuration) throws ConfigurationException
    {
        return "Ametys.plugins.contentio.export.ExportButtonController";
    }
    
    /**
     * True if a datasource is defined
     * @return true a datasource is defined
     */
    @Callable(rights = "Plugins_ContentIO_Export_Content", context = "/cms")
    public boolean hasDataSource()
    {
        String datasourceId = Config.getInstance().getValue("org.ametys.plugins.contentio.content.export.datasource");
        return StringUtils.isNotBlank(datasourceId);
    }
}
