/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.export.sql;

/**
 * Export counter info
 */
public class ExportCounter
{
    private Integer _count;
    
    /**
     * The constructor
     * @param count the count
     */
    public ExportCounter(Integer count)
    {
        _count = count;
    }
    
    /**
     * Get the count
     * @return the count
     */
    public int getCount()
    {
        return _count;
    }
    
    /**
     * Increment the count
     */
    public void incrementCount()
    {
        _count++;
    }
    
    /**
     * Increment the count
     * @param inc increments to add
     */
    public void incrementCount(int inc)
    {
        _count += inc;
    }
}
