/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.in;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;

import org.ametys.runtime.plugin.component.Prioritizable;

/**
 * Interface representing a component which imports contents from a file.
 */
public interface ContentImporter extends Prioritizable
{
    
    /**
     * Tests if the {@link ContentImporter} is able to import the corresponding stream.<br>
     * Implementing classes should first test the file extension, if possible, and if the name is provided.
     * @param is an input stream on the file, cannot be null. The stream is closed by the caller.
     * @param name the file name, can be null.
     * @return true if the {@link ContentImporter} can import the corresponding stream, false otherwise.
     * @throws IOException if an error occurs.
     */
    public boolean supports(InputStream is, String name) throws IOException;
    
    /**
     * Import the contents from the file.
     * @param is an input stream on the file, cannot be null. The stream is closed by the caller.
     * @param params input or output parameters.
     * @return a Set of the imported content IDs.
     * @throws IOException if an error occurs importing the contents.
     */
    public Set<String> importContents(InputStream is, Map<String, Object> params) throws IOException;
    
}
