/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.plugins.core.schedule.Scheduler;

/**
 * Abstract schedulable for SCC.
 */
public abstract class AbstractCollectionSchedulable extends AbstractStaticSchedulable
{
    /** The key for the collection to synchronize */
    public static final String JOBDATAMAP_COLLECTION_KEY = "collectionId";
    
    private SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO) manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
    }
    
    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception
    {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String collectionId = (String) jobDataMap.get(Scheduler.PARAM_VALUES_PREFIX + JOBDATAMAP_COLLECTION_KEY);
        
        SynchronizableContentsCollection collection = _synchronizableContentsCollectionDAO.getSynchronizableContentsCollection(collectionId);
        _process(collection, progressionTracker);
    }
    
    /**
     * Process on the given collection.
     * @param collection The SCC
     * @param progressionTracker A progression tracker
     * @throws Exception if an exception occurs
     */
    protected abstract void _process(SynchronizableContentsCollection collection, ContainerProgressionTracker progressionTracker) throws Exception;
}
