/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize;

import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Model;

/**
 * Interface representing a model for a {@link SynchronizableContentsCollection}
 */
public interface SynchronizableContentsCollectionModel extends Model
{   
    /**
     * Get the label of this model
     * @return the label of this model
     */
    public I18nizableText getLabel();
    
    /**
     * Get the description of this model
     * @return the description 
     */
    public I18nizableText getDescription();
    
    /**
     * Returns the plugin name of declaration (for debug purpose)
     * @return the plugin name
     */
    public String getPluginName();
    
    /**
     * Get the synchronizable collection class
     * @return the synchronizable collection class
     */
    public Class<SynchronizableContentsCollection> getSynchronizableCollectionClass();
    
    public default String getFamilyId()
    {
        return SynchronizeContentsCollectionModelExtensionPoint.ROLE;
    }
}
