/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize.systemprop;

import org.ametys.cms.repository.Content;
import org.ametys.cms.search.model.SystemProperty;
import org.ametys.cms.search.systemprop.AbstractDateTimeSystemProperty;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.runtime.model.type.ModelItemTypeConstants;

/**
 * {@link SystemProperty} which represents the last synchronization date of a content.
 */
public class LastSynchronizationSystemProperty extends AbstractDateTimeSystemProperty<Content>
{
    public Object getValue(Content content)
    {
        return content.getInternalDataHolder()
                      .getValueOfType(SynchronizableContentsCollection.LAST_SYNCHRONIZATION_DATA_NAME, ModelItemTypeConstants.DATETIME_TYPE_ID);
    }
}
