/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.nio.file.Path;
import java.util.Optional;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.ImportGlobalFailException;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.slf4j.Logger;
import org.w3c.dom.Document;

public interface UnitaryImporter<O> {
    public String objectNameForLogs();

    public Document getPropertiesXml(Path var1) throws Exception;

    public String retrieveId(Document var1) throws Exception;

    public O create(Path var1, String var2, Document var3) throws Archivers.AmetysObjectNotImportedException, ImportGlobalFailException, Exception;

    public ImportReport getReport();

    default public void unitaryImportFinalize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Optional<O> unitaryImport(Path zipArchivePath, Path zipEntryPath, Merger merger, Logger logger) throws ImportGlobalFailException {
        Optional optional;
        try {
            Document propertiesXml = this.getPropertiesXml(zipEntryPath);
            String id = this.retrieveId(propertiesXml);
            if (merger.needsMerge(id)) {
                Merger.AfterMerge afterMerge = merger.merge(id);
                switch (afterMerge) {
                    case STOP_PROCESS: {
                        Optional optional2 = Optional.empty();
                        return optional2;
                    }
                }
            }
            O created = this.create(zipEntryPath, id, propertiesXml);
            Optional<O> optional3 = Optional.of(created);
            return optional3;
        }
        catch (ImportGlobalFailException e) {
            this.getReport().addError(new ImportReport.ImportError(e));
            throw e;
        }
        catch (Archivers.AmetysObjectNotImportedException e) {
            logger.error("{} for '{}!{}' could not be imported.", new Object[]{this.objectNameForLogs(), zipArchivePath, zipEntryPath, e});
            this.getReport().addError(new ImportReport.ImportError(e));
            optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            logger.error("An unexpected exception occured when trying to import {} for '{}!{}'.", new Object[]{this.objectNameForLogs(), zipArchivePath, zipEntryPath, e});
            this.getReport().addError(new ImportReport.ImportError(e));
            optional = Optional.empty();
            return optional;
        }
        finally {
            this.unitaryImportFinalize();
        }
    }
}

