/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.export.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.contentio.export.sql.ExportConfiguration;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class DeleteSqlTableComponent
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = DeleteSqlTableComponent.class.getName();
    protected I18nUtils _i18nTranslator;

    public void service(ServiceManager manager) throws ServiceException {
        this._i18nTranslator = (I18nUtils)manager.lookup(I18nUtils.ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExistingSqlTables(ExportConfiguration exportConfiguration) throws SQLException {
        ResultSet rs;
        Connection connection;
        block6: {
            String tablePrefix = exportConfiguration.getTablePrefix();
            connection = null;
            rs = null;
            try {
                String datasourceId = (String)Config.getInstance().getValue("org.ametys.plugins.contentio.content.export.datasource");
                connection = ConnectionHelper.getConnection((String)datasourceId);
                String datatype = ConnectionHelper.getDatabaseType((Connection)connection);
                if (datatype.equals("oracle")) {
                    tablePrefix = tablePrefix.toUpperCase();
                }
                String[] tableType = new String[]{"TABLE"};
                rs = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), tablePrefix + "%", tableType);
                if (datatype.equals("mysql")) {
                    this._deleteMysqlTable(rs, connection);
                    break block6;
                }
                if (!datatype.equals("oracle")) break block6;
                this._deleteOracleTable(rs, connection);
            }
            catch (Exception e) {
                try {
                    this.getLogger().error(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_DELETE_ERROR_SQL")), (Throwable)e);
                }
                catch (Throwable throwable) {
                    ConnectionHelper.cleanup(rs);
                    ConnectionHelper.cleanup(connection);
                    throw throwable;
                }
                ConnectionHelper.cleanup(rs);
                ConnectionHelper.cleanup((Connection)connection);
            }
        }
        ConnectionHelper.cleanup((ResultSet)rs);
        ConnectionHelper.cleanup((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteMysqlTable(ResultSet rs, Connection connection) throws SQLException {
        StringBuilder dropRequest = new StringBuilder();
        int nbTable = 0;
        if (rs.next()) {
            dropRequest.append("DROP TABLE ");
            dropRequest.append(rs.getString("table_name"));
            ++nbTable;
            while (rs.next()) {
                dropRequest.append(", ");
                dropRequest.append(rs.getString("table_name"));
                ++nbTable;
            }
        }
        if (this.getLogger().isInfoEnabled()) {
            ArrayList<String> i18nParams = new ArrayList<String>();
            i18nParams.add(String.valueOf(nbTable));
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_DELETE_NB_TABLE", i18nParams)));
        }
        PreparedStatement stmt = null;
        try {
            if (StringUtils.isNotEmpty((CharSequence)dropRequest.toString())) {
                stmt = connection.prepareStatement("SET FOREIGN_KEY_CHECKS = 0");
                stmt.execute();
                ConnectionHelper.cleanup((Statement)stmt);
                stmt = connection.prepareStatement(dropRequest.toString());
                stmt.execute();
                ConnectionHelper.cleanup((Statement)stmt);
                stmt = connection.prepareStatement("SET FOREIGN_KEY_CHECKS = 1");
                stmt.execute();
            }
        }
        finally {
            ConnectionHelper.cleanup(stmt);
        }
        if (this.getLogger().isInfoEnabled()) {
            ArrayList<String> i18nParams = new ArrayList<String>();
            i18nParams.add(String.valueOf(nbTable));
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_DELETE_FINISH", i18nParams)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _deleteOracleTable(ResultSet rs, Connection connection) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement("ALTER SESSION SET RECYCLEBIN=OFF");
            stmt.execute();
        }
        finally {
            ConnectionHelper.cleanup((Statement)stmt);
        }
        StringBuilder dropRequest = new StringBuilder();
        ArrayList<String> listRequest = new ArrayList<String>();
        if (rs.next()) {
            dropRequest.append("DROP TABLE ");
            dropRequest.append(rs.getString("table_name"));
            dropRequest.append(" CASCADE CONSTRAINTS");
            listRequest.add(dropRequest.toString());
            while (rs.next()) {
                dropRequest = new StringBuilder();
                dropRequest.append("DROP TABLE ");
                dropRequest.append(rs.getString("table_name"));
                dropRequest.append(" CASCADE CONSTRAINTS");
                listRequest.add(dropRequest.toString());
            }
        }
        int nbTable = listRequest.size();
        boolean isInfoEnabled = this.getLogger().isInfoEnabled();
        boolean isWarnEnabled = this.getLogger().isWarnEnabled();
        if (isInfoEnabled) {
            ArrayList<String> i18nParams = new ArrayList<String>();
            i18nParams.add(String.valueOf(nbTable));
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_DELETE_NB_TABLE_ORACLE", i18nParams)));
        }
        int nbTableDeleted = 0;
        int pourcentLimit = 10;
        for (String request : listRequest) {
            int pourcent;
            ArrayList<String> i18nParams;
            this.getLogger().debug(request);
            try {
                stmt = connection.prepareStatement(request);
                stmt.execute();
                ++nbTableDeleted;
            }
            catch (Exception e) {
                if (isWarnEnabled) {
                    i18nParams = new ArrayList<String>();
                    i18nParams.add(String.valueOf(request));
                    this.getLogger().warn(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_DELETE_ERROR_TABLE_ORACLE", i18nParams)), (Throwable)e);
                }
            }
            finally {
                ConnectionHelper.cleanup((Statement)stmt);
            }
            if ((pourcent = nbTableDeleted * 100 / nbTable) < pourcentLimit) continue;
            if (isInfoEnabled) {
                i18nParams = new ArrayList();
                i18nParams.add(String.valueOf(pourcentLimit));
                this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_DELETE_ADVANCE_ORACLE", i18nParams)));
            }
            pourcentLimit += 10;
        }
        if (isInfoEnabled) {
            ArrayList<String> i18nParams = new ArrayList<String>();
            i18nParams.add(String.valueOf(nbTableDeleted));
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_DELETE_FINISH", i18nParams)));
        }
    }
}

