/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.in.xml;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.plugins.contentio.in.xml.AbstractXmlContentImporter;
import org.ametys.plugins.repository.data.extractor.xml.ModelAwareXMLValuesExtractor;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultXmlContentImporter
extends AbstractXmlContentImporter {
    protected static final String _DEFAULT_CONTENT_TYPES_KEY = DefaultXmlContentImporter.class.getName() + "$defaultContentTypes";
    protected static final String _DEFAULT_CONTENT_MIXINS_KEY = DefaultXmlContentImporter.class.getName() + "$defaultMixins";
    protected static final String _DEFAULT_CONTENT_LANG_KEY = DefaultXmlContentImporter.class.getName() + "$defaultLanguage";
    protected ContentTypesHelper _cTypeHelper;
    protected String _matchPath;
    protected String _matchValue;
    protected Pattern _matchRegex;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._cTypeHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.configureXmlMatch(configuration.getChild("xml").getChild("match"));
    }

    protected void configureXmlMatch(Configuration configuration) throws ConfigurationException {
        this._matchPath = configuration.getAttribute("path");
        this._matchValue = configuration.getAttribute("value", null);
        String regex = configuration.getAttribute("regex", null);
        if (StringUtils.isNotBlank((CharSequence)regex)) {
            this._matchRegex = Pattern.compile(regex);
        }
    }

    @Override
    public boolean supports(Document document) throws IOException {
        Node node = this._xPathProcessor.selectSingleNode((Node)document, this._matchPath, this.getPrefixResolver());
        if (this._matchValue == null && this._matchRegex == null) {
            return node != null;
        }
        if (this._matchRegex != null) {
            String text = this.getTextContent(node, null, true);
            return text != null ? this._matchRegex.matcher(text).matches() : false;
        }
        return this._matchValue.equals(this.getTextContent(node, null, true));
    }

    @Override
    protected Set<String> importContents(Document node, Map<String, Object> params) throws IOException {
        HashSet<String> contentIds = new HashSet<String>();
        Element root = node.getDocumentElement();
        if (root != null) {
            String[] defaultTypes = StringUtils.split((String)this.getAttributeValue(root, "default-types", ""), (String)", ");
            String[] defaultMixins = StringUtils.split((String)this.getAttributeValue(root, "default-mixins", ""), (String)", ");
            String defaultLang = this.getAttributeValue(root, "default-language", this.getLanguage(params));
            if (defaultTypes.length == 0) {
                defaultTypes = this.getContentTypes(params);
            }
            if (defaultMixins.length == 0) {
                defaultMixins = this.getMixins(params);
            }
            params.put(_DEFAULT_CONTENT_TYPES_KEY, defaultTypes);
            params.put(_DEFAULT_CONTENT_MIXINS_KEY, defaultMixins);
            params.put(_DEFAULT_CONTENT_LANG_KEY, defaultLang);
            NodeList contents = this._xPathProcessor.selectNodeList((Node)root, "content", this.getPrefixResolver());
            for (int i = 0; i < contents.getLength(); ++i) {
                Element contentNode = (Element)contents.item(i);
                try {
                    Content content = this.importContent(contentNode, defaultTypes, defaultMixins, defaultLang, params);
                    if (content == null) continue;
                    contentIds.add(content.getId());
                    continue;
                }
                catch (Exception e) {
                    this.getLogger().error("Error importing a content.", (Throwable)e);
                }
            }
            params.remove(_DEFAULT_CONTENT_TYPES_KEY);
            params.remove(_DEFAULT_CONTENT_MIXINS_KEY);
            params.remove(_DEFAULT_CONTENT_LANG_KEY);
        }
        return contentIds;
    }

    protected Content importContent(Element contentElement, String[] defaultTypes, String[] defaultMixins, String defaultLang, Map<String, Object> params) throws Exception {
        String localId = this.getAttributeValue(contentElement, "id", "");
        String cTypesStr = this.getAttributeValue(contentElement, "types", "");
        String mixinsStr = this.getAttributeValue(contentElement, "mixins", "");
        String[] contentTypes = StringUtils.isEmpty((CharSequence)cTypesStr) ? defaultTypes : StringUtils.split((String)cTypesStr, (String)", ");
        String[] contentMixins = StringUtils.isEmpty((CharSequence)mixinsStr) ? defaultMixins : StringUtils.split((String)mixinsStr, (String)", ");
        String language = this.getAttributeValue(contentElement, "language", defaultLang);
        String title = this._xPathProcessor.evaluateAsString((Node)contentElement, "@title", this.getPrefixResolver());
        WorkflowAwareContent content = (WorkflowAwareContent)this.createContent(title, contentTypes, contentMixins, language, params);
        ModelAwareXMLValuesExtractor extractor = new ModelAwareXMLValuesExtractor(DOMUtils.getChildElementByTagName((Element)contentElement, (String)"attributes"), (path, type) -> Optional.empty(), content.getModel());
        Map values = extractor.extractValues();
        this._contentWorkflowHelper.editContent(content, values, this.getEditActionId(params));
        if (StringUtils.isNotBlank((CharSequence)localId)) {
            Map<String, String> contentIdMap = this.getContentIdMap(params);
            contentIdMap.put(localId, content.getId());
        }
        return content;
    }
}

