/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize;

import com.opensymphony.workflow.WorkflowException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.cms.content.ContentHelper;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.schedule.progression.ProgressionTrackerFactory;
import org.ametys.core.schedule.progression.SimpleProgressionTracker;
import org.ametys.core.util.MapUtils;
import org.ametys.plugins.contentio.synchronize.AbstractSynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizingContentOperator;
import org.ametys.plugins.contentio.synchronize.SynchronizingContentOperatorExtensionPoint;
import org.ametys.plugins.contentio.synchronize.workflow.EditSynchronizedContentFunction;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.holder.ModifiableModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.repository.data.holder.values.SynchronizationContext;
import org.ametys.plugins.repository.data.holder.values.ValueContext;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractSimpleSynchronizableContentsCollection
extends AbstractSynchronizableContentsCollection {
    protected SynchronizingContentOperatorExtensionPoint _synchronizingContentOperatorEP;
    protected ContentHelper _contentHelper;
    private List<String> _handledContents;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._contentHelper = (ContentHelper)manager.lookup(ContentHelper.ROLE);
        this._synchronizingContentOperatorEP = (SynchronizingContentOperatorExtensionPoint)((Object)manager.lookup(SynchronizingContentOperatorExtensionPoint.ROLE));
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this._handledContents = new ArrayList<String>();
    }

    @Override
    public List<ModifiableContent> populate(Logger logger, ContainerProgressionTracker progressionTracker) {
        this._handledContents.clear();
        List<ModifiableContent> populatedContents = super.populate(logger, progressionTracker);
        this._handledContents.clear();
        return populatedContents;
    }

    @Override
    protected List<ModifiableContent> _internalPopulate(Logger logger, ContainerProgressionTracker progressionTracker) {
        return this._importOrSynchronizeContents(new HashMap<String, Object>(), false, logger, progressionTracker);
    }

    protected void _handleContent(String id) {
        this._handledContents.add(id);
    }

    protected boolean _isHandled(String id) {
        return this._handledContents.contains(id);
    }

    protected List<ModifiableContent> _importOrSynchronizeContent(String idValue, Map<String, List<Object>> remoteValues, boolean forceImport, Logger logger) {
        ArrayList<ModifiableContent> contents = new ArrayList<ModifiableContent>();
        for (String lang : this.getLanguages()) {
            this._importOrSynchronizeContent(idValue, lang, remoteValues, forceImport, logger).ifPresent(contents::add);
        }
        return contents;
    }

    protected Optional<ModifiableContent> _importOrSynchronizeContent(String idValue, String lang, Map<String, List<Object>> remoteValues, boolean forceImport, Logger logger) {
        try {
            ModifiableContent content = this.getContent(lang, idValue, false);
            if (content != null) {
                return Optional.of(this._synchronizeContent(content, remoteValues, logger));
            }
            if (forceImport || !this.synchronizeExistingContentsOnly()) {
                return Optional.ofNullable(this._importContent(idValue, null, lang, remoteValues, logger));
            }
        }
        catch (Exception e) {
            ++this._nbError;
            logger.error("An error occurred while importing or synchronizing content", (Throwable)e);
        }
        return Optional.empty();
    }

    @Override
    public void synchronizeContent(ModifiableContent content, Logger logger) throws Exception {
        String idValue = (String)content.getValue(this.getIdField());
        Map<String, Object> searchParameters = this.putIdParameter(idValue);
        Map<String, Map<String, List<Object>>> results = this.getTransformedRemoteValues(searchParameters, logger);
        if (!results.isEmpty()) {
            try {
                this._synchronizeContent(content, results.get(idValue), logger);
            }
            catch (Exception e) {
                ++this._nbError;
                logger.error("An error occurred while importing or synchronizing content", (Throwable)e);
                throw e;
            }
        } else {
            logger.warn("The content {} ({}) with synchronization code '{}' doesn't exist anymore in the datasource from SCC '{}'", new Object[]{content.getTitle(), content.getId(), idValue, this.getId()});
        }
    }

    protected ModifiableContent _synchronizeContent(ModifiableContent content, Map<String, List<Object>> remoteValues, Logger logger) throws Exception {
        boolean fromNewSCC;
        long startTime = System.currentTimeMillis();
        String contentTitle = content.getTitle();
        String lang = content.getLanguage();
        logger.info("Start synchronizing content '{}' for language {}", (Object)contentTitle, (Object)lang);
        boolean bl = fromNewSCC = !this._sccHelper.getSynchronizableCollectionIds((Content)content).contains(this.getId());
        if (fromNewSCC) {
            this._sccHelper.updateSCCProperty((Content)content, this.getId());
        }
        this._sccHelper.updateLastSynchronizationProperties((Content)content);
        content.saveChanges();
        this.ensureTitleIsPresent((Content)content, remoteValues, logger);
        boolean hasChanged = this._fillContent(remoteValues, content, Map.of(), fromNewSCC, logger);
        if (hasChanged) {
            ++this._nbSynchronizedContents;
            logger.info("Some changes were detected for content '{}' and language {}", (Object)contentTitle, (Object)lang);
        } else {
            ++this._nbNotChangedContents;
            logger.info("No changes detected for content '{}' and language {}", (Object)contentTitle, (Object)lang);
        }
        SynchronizingContentOperator synchronizingContentOperator = (SynchronizingContentOperator)this._synchronizingContentOperatorEP.getExtension(this.getSynchronizingContentOperator());
        if (synchronizingContentOperator != null) {
            synchronizingContentOperator.additionalOperation((Content)content, remoteValues, logger);
        } else {
            logger.warn("Cannot find synchronizing content operator with id '{}'. No additional operation has been done.", (Object)this.getSynchronizingContentOperator());
        }
        long endTime = System.currentTimeMillis();
        logger.info("End synchronization of content '{}' for language {} in {} ms", new Object[]{contentTitle, lang, endTime - startTime});
        return content;
    }

    @Override
    public List<ModifiableContent> importContent(String idValue, Map<String, Object> additionalParameters, Logger logger) throws Exception {
        ArrayList<ModifiableContent> createdContents = new ArrayList<ModifiableContent>();
        Map<String, Object> searchParameters = this.putIdParameter(idValue);
        Map<String, Map<String, List<Object>>> results = this.getTransformedRemoteValues(searchParameters, logger);
        if (!results.isEmpty()) {
            for (String lang : this.getLanguages()) {
                ModifiableContent existingContent = this.getContent(lang, idValue, false);
                if (existingContent == null) {
                    try {
                        createdContents.add(this._importContent(idValue, additionalParameters, lang, results.get(idValue), logger));
                    }
                    catch (Exception e) {
                        ++this._nbError;
                        logger.error("An error occurred while importing or synchronizing content", (Throwable)e);
                    }
                    continue;
                }
                if (this.getContent(lang, idValue, true) == null) {
                    this._synchronizeContent(existingContent, results.get(idValue), logger);
                    continue;
                }
                if (!logger.isWarnEnabled()) continue;
                logger.warn("The content of SCC '{}' identified by the synchronization code '{}' and language '{}' already exists, it has not been imported twice.", new Object[]{this.getId(), idValue, lang});
            }
        }
        return createdContents;
    }

    protected abstract Map<String, Object> putIdParameter(String var1);

    protected ModifiableContent _importContent(String idValue, Map<String, Object> additionalParameters, String lang, Map<String, List<Object>> remoteValues, Logger logger) throws Exception {
        long startTime = System.currentTimeMillis();
        String contentTitle = Optional.ofNullable(remoteValues.get("title")).map(Collection::stream).orElseGet(Stream::empty).filter(String.class::isInstance).map(String.class::cast).filter(StringUtils::isNotBlank).findFirst().orElse(idValue);
        logger.info("Start importing content '{}' for language {}", (Object)contentTitle, (Object)lang);
        ModifiableContent content = this.createContentAction(lang, contentTitle, logger);
        if (content != null) {
            this._sccHelper.updateSCCProperty((Content)content, this.getId());
            this._sccHelper.updateLastSynchronizationProperties((Content)content);
            ValueContext context = ValueContext.newInstance();
            if (this.getLocalAndExternalFields(Map.of("contentTypes", Arrays.asList(content.getTypes()))).contains(this.getIdField())) {
                context.withStatus(ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL);
            }
            DataHolderHelper.setValue((ModifiableModelAwareDataHolder)content, (String)this.getIdField(), (Object)idValue, (ValueContext)context, (boolean)true);
            content.saveChanges();
            this._fillContent(remoteValues, content, additionalParameters, true, logger);
            if (content instanceof WorkflowAwareContent) {
                this.validateContent((WorkflowAwareContent)content, logger);
            }
            ++this._nbCreatedContents;
            SynchronizingContentOperator synchronizingContentOperator = (SynchronizingContentOperator)this._synchronizingContentOperatorEP.getExtension(this.getSynchronizingContentOperator());
            synchronizingContentOperator.additionalOperation((Content)content, remoteValues, logger);
            long endTime = System.currentTimeMillis();
            logger.info("End import of content '{}' for language {} in {} ms", new Object[]{content.getId(), lang, endTime - startTime});
        }
        return content;
    }

    protected void ensureTitleIsPresent(Content content, Map<String, List<Object>> remoteValues, Logger logger) {
        if (remoteValues.containsKey("title")) {
            boolean atLeastOneTitle = remoteValues.get("title").stream().filter(String.class::isInstance).map(String.class::cast).anyMatch(StringUtils::isNotBlank);
            if (atLeastOneTitle) {
                return;
            }
        }
        logger.warn("The remote value of '{}' is empty for the content {}. The '{}' attribute is mandatory, the current title will remain.", new Object[]{"title", content, "title"});
        remoteValues.put("title", List.of(content.getTitle()));
    }

    @Override
    public ModifiableContent getContent(String lang, String idValue, boolean forceStrictCheck) {
        String query = this._getContentPathQuery(lang, idValue, this.getContentType(), forceStrictCheck);
        AmetysObjectIterable contents = this._resolver.query(query);
        return contents.stream().findFirst().orElse(null);
    }

    protected ModifiableContent createContentAction(String lang, String contentTitle, Logger logger) {
        return this.createContentAction(this.getContentType(), this.getWorkflowName(), this.getInitialActionId(), lang, contentTitle, logger);
    }

    protected boolean _fillContent(Map<String, List<Object>> remoteValues, ModifiableContent content, Map<String, Object> additionalParameters, boolean create, Logger logger) throws Exception {
        if (content instanceof WorkflowAwareContent) {
            Map<String, Object> contentValues = this._transformRemoteValuesCardinality(remoteValues, this.getContentType());
            contentValues.remove(this.getIdField());
            contentValues.putAll(this.getAdditionalAttributeValues((String)content.getValue(this.getIdField()), (Content)content, additionalParameters, create, logger));
            if (StringUtils.isEmpty((CharSequence)((String)contentValues.get("title")))) {
                contentValues.remove("title");
            }
            Set<String> notSynchronizedContentIds = this.getNotSynchronizedRelatedContentIds((Content)content, contentValues, additionalParameters, content.getLanguage(), logger);
            Map<String, Object> nestedValues = AbstractSimpleSynchronizableContentsCollection._getNestedValues(contentValues);
            return this._editContent((WorkflowAwareContent)content, Optional.empty(), nestedValues, additionalParameters, create, notSynchronizedContentIds, logger);
        }
        return false;
    }

    protected boolean _editContent(WorkflowAwareContent content, Optional<View> view, Map<String, Object> values, Map<String, Object> additionalParameters, boolean create, Set<String> notSynchronizedContentIds, Logger logger) throws WorkflowException {
        SynchronizationContext synchronizationContext = SynchronizationContext.newInstance().withStatus(ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL).withExternalizableDataContextEntry("sccId", (Object)this.getId()).withIncompatibleValuesIgnored(true);
        if (view.map(v -> content.hasDifferences((ViewItemAccessor)v, values, synchronizationContext)).orElseGet(() -> content.hasDifferences(values, synchronizationContext)).booleanValue()) {
            Map<String, Object> inputs = this._getEditInputs(content, view, values, additionalParameters, create, notSynchronizedContentIds, logger);
            Map actionResult = this._contentWorkflowHelper.doAction(content, this.getSynchronizeActionId(), inputs);
            return actionResult.getOrDefault("content.has.changed", false);
        }
        return false;
    }

    private static Map<String, Object> _getNestedValues(Map<String, Object> values) {
        Map<String, Object> nestedValues = new HashMap<String, Object>();
        for (String key : values.keySet()) {
            nestedValues = (Map)MapUtils.deepMerge(nestedValues, AbstractSimpleSynchronizableContentsCollection._getNestedValue(key, values.get(key)));
        }
        return nestedValues;
    }

    private static Map<String, Object> _getNestedValue(String currentPath, Object currentValue) {
        HashMap<String, Object> nestedValues = new HashMap<String, Object>();
        int separatorIndex = currentPath.indexOf(47);
        if (separatorIndex < 0) {
            if (currentValue instanceof Map) {
                nestedValues.put(currentPath, AbstractSimpleSynchronizableContentsCollection._getNestedValues((Map)currentValue));
            } else {
                nestedValues.put(currentPath, currentValue);
            }
        } else {
            nestedValues.put(currentPath.substring(0, separatorIndex), AbstractSimpleSynchronizableContentsCollection._getNestedValue(currentPath.substring(separatorIndex + 1), currentValue));
        }
        return nestedValues;
    }

    protected Map<String, Object> _getEditInputs(WorkflowAwareContent content, Optional<View> view, Map<String, Object> values, Map<String, Object> additionalParameters, boolean create, Set<String> notSynchronizedContentIds, Logger logger) {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        this._addEditInputsForSCC(inputs, content, logger);
        inputs.put(EditSynchronizedContentFunction.ADDITIONAL_PARAMS_KEY, additionalParameters);
        inputs.put(EditSynchronizedContentFunction.SYNCHRO_INVERT_EDIT_ACTION_ID_KEY, this.getSynchronizeActionId());
        inputs.put(EditSynchronizedContentFunction.NOT_SYNCHRONIZED_RELATED_CONTENT_IDS_KEY, notSynchronizedContentIds);
        inputs.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, this._getEditInputsContextParameters(view, values, create));
        return inputs;
    }

    protected void _addEditInputsForSCC(Map<String, Object> inputs, WorkflowAwareContent content, Logger logger) {
        inputs.put(EditSynchronizedContentFunction.SCC_KEY, this);
        inputs.put(EditSynchronizedContentFunction.SCC_LOGGER_KEY, logger);
    }

    protected Map<String, Object> _getEditInputsContextParameters(Optional<View> view, Map<String, Object> values, boolean create) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("typedValues", values);
        view.ifPresent(v -> parameters.put("view", v));
        parameters.put("quit", true);
        parameters.put("import", create);
        return parameters;
    }

    protected void validateContent(WorkflowAwareContent content, Logger logger) {
        if (this.validateAfterImport()) {
            this.validateContent(content, this.getValidateActionId(), logger);
        }
    }

    @Override
    public Map<String, Map<String, Object>> search(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger) {
        Map<String, Map<String, Object>> results = this.internalSearch(this._removeEmptyParameters(searchParameters), offset, limit, sort, logger);
        return results;
    }

    protected abstract Map<String, Map<String, Object>> internalSearch(Map<String, Object> var1, int var2, int var3, List<Object> var4, Logger var5);

    protected Map<String, Map<String, List<Object>>> getTransformedRemoteValues(Map<String, Object> searchParameters, Logger logger) {
        Map<String, Map<String, List<Object>>> remoteValues = this.getRemoteValues(searchParameters, logger);
        return this._transformRemoteValues(remoteValues, logger);
    }

    protected abstract Map<String, Map<String, List<Object>>> getRemoteValues(Map<String, Object> var1, Logger var2);

    protected Map<String, Map<String, List<Object>>> _transformRemoteValues(Map<String, Map<String, List<Object>>> remoteValues, Logger logger) {
        SynchronizingContentOperator synchronizingContentOperator = (SynchronizingContentOperator)this._synchronizingContentOperatorEP.getExtension(this.getSynchronizingContentOperator());
        if (synchronizingContentOperator != null) {
            LinkedHashMap<String, Map<String, List<Object>>> transformedRemoteValues = new LinkedHashMap<String, Map<String, List<Object>>>();
            ContentType contentType = (ContentType)this._contentTypeEP.getExtension(this.getContentType());
            for (String key : remoteValues.keySet()) {
                transformedRemoteValues.put(key, synchronizingContentOperator.transform(contentType, remoteValues.get(key), logger));
            }
            return transformedRemoteValues;
        }
        logger.warn("Cannot find synchronizing content operator with id '{}'. No transformation has applied on remote values", (Object)this.getSynchronizingContentOperator());
        return remoteValues;
    }

    protected Map<String, Object> getAdditionalAttributeValues(String idValue, Content content, Map<String, Object> additionalParameters, boolean create, Logger logger) {
        return new LinkedHashMap<String, Object>();
    }

    protected Set<String> getNotSynchronizedRelatedContentIds(Content content, Map<String, Object> contentValues, Map<String, Object> additionalParameters, String lang, Logger logger) {
        return new HashSet<String>();
    }

    @Override
    public void updateSyncInformations(ModifiableContent content, String syncCode, Logger logger) throws Exception {
        if (StringUtils.isBlank((CharSequence)syncCode)) {
            this._sccHelper.removeSCCProperty((Content)content, this.getId());
            content.removeValue(this.getIdField());
        } else {
            this._sccHelper.updateSCCProperty((Content)content, this.getId());
            content.setValue(this.getIdField(), (Object)syncCode);
        }
        if (content.needsSave()) {
            content.saveChanges();
            if (content instanceof VersionableAmetysObject) {
                ((VersionableAmetysObject)content).checkpoint();
            }
        }
    }

    @Override
    public int getTotalCount(Map<String, Object> searchParameters, Logger logger) {
        return this.search(searchParameters, 0, Integer.MAX_VALUE, null, logger).size();
    }

    protected final List<ModifiableContent> _importOrSynchronizeContents(Map<String, Object> searchParameters, boolean forceImport, Logger logger) {
        return this._importOrSynchronizeContents(searchParameters, forceImport, logger, ProgressionTrackerFactory.createContainerProgressionTracker((String)"Import or synchronize contents", (Logger)logger));
    }

    protected List<ModifiableContent> _importOrSynchronizeContents(Map<String, Object> searchParameters, boolean forceImport, Logger logger, ContainerProgressionTracker progressionTracker) {
        SimpleProgressionTracker progressionTrackerForTransformRemoteValues = progressionTracker.addSimpleStep("transformremotevalues", new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_SCHEDULER_SYNCHRONIZE_COLLECTION_TRANSFORM_STEP_LABEL"));
        SimpleProgressionTracker progressionTrackerForSynchro = progressionTracker.addSimpleStep("synchronizetransformedremotevalues", new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_SCHEDULER_SYNCHRONIZE_COLLECTION_SYNCHRONIZE_STEP_LABEL"));
        ArrayList<ModifiableContent> contents = new ArrayList<ModifiableContent>();
        Map<String, Map<String, List<Object>>> remoteValuesByContent = this.getTransformedRemoteValues(searchParameters, logger);
        progressionTrackerForTransformRemoteValues.increment();
        progressionTrackerForSynchro.setSize((long)remoteValuesByContent.size());
        for (String idValue : remoteValuesByContent.keySet()) {
            Map<String, List<Object>> remoteValues = remoteValuesByContent.get(idValue);
            this._handleContent(idValue);
            contents.addAll(this._importOrSynchronizeContent(idValue, remoteValues, forceImport, logger));
            progressionTrackerForSynchro.increment();
        }
        return contents;
    }

    @Override
    protected List<ModifiableContent> _getContentsToRemove(AmetysObjectIterable<ModifiableContent> contents) {
        return contents.stream().filter(content -> !this._isHandled((String)content.getValue(this.getIdField()))).collect(Collectors.toList());
    }
}

