/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.impl;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.core.util.ldap.AbstractLDAPConnector;
import org.ametys.core.util.ldap.IncompleteLDAPResultException;
import org.ametys.core.util.ldap.ScopeEnumerator;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.slf4j.Logger;

public class LDAPCollectionHelper
extends AbstractLDAPConnector
implements Component {
    public static final String ROLE = LDAPCollectionHelper.class.getName();
    private static final DateTimeFormatter __BASIC_DATE_TIME = new DateTimeFormatterBuilder().append(DateTimeFormatter.BASIC_ISO_DATE).appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.MILLI_OF_SECOND, 1, 3, true).appendOffsetId().toFormatter();
    protected ContentTypeExtensionPoint _contentTypeEP;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._contentTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        super.service(serviceManager);
    }

    public synchronized LDAPCollectionHelperSearchResult search(String collectionId, String relativeDN, String filter, String searchScope, int offset, int limit, Map<String, List<String>> mapping, String idKey, Logger logger, String dataSourceId) {
        LinkedHashMap<String, Map<String, Object>> searchResults = new LinkedHashMap<String, Map<String, Object>>();
        int nbErrors = 0;
        boolean hasGlobalError = false;
        try {
            List ldapSearchResults;
            this._delayedInitialize(dataSourceId);
            try {
                ldapSearchResults = this._search(relativeDN, filter, null, this._getSearchControls(mapping, searchScope), offset, limit, false);
            }
            catch (IncompleteLDAPResultException e) {
                ldapSearchResults = (List)e.getPartialResults();
                logger.warn("LDAP refused to return more than " + ldapSearchResults.size() + " results");
                ++nbErrors;
            }
            for (SearchResult searchResult : ldapSearchResults) {
                String idValue = (String)this._getIdValue(idKey, searchResult, logger);
                if (idValue == null) {
                    ++nbErrors;
                    logger.warn("The id value '{}' for '{}' was null ", (Object)idKey, (Object)searchResult.getName());
                    continue;
                }
                if (!searchResults.keySet().contains(idValue)) {
                    try {
                        HashMap<String, List<Object>> values = new HashMap<String, List<Object>>();
                        NamingEnumeration<? extends Attribute> attributes = searchResult.getAttributes().getAll();
                        while (attributes.hasMore()) {
                            Attribute attribute = attributes.next();
                            values.put(attribute.getID(), this._getLDAPValues(attribute));
                        }
                        searchResults.put(idValue, values);
                    }
                    catch (Exception e) {
                        ++nbErrors;
                        logger.warn("Failed to import the content '{}'", (Object)idValue, (Object)e);
                    }
                    continue;
                }
                logger.warn("Cannot import '{}' because its id value '{}={}' is already an id value for another content", new Object[]{searchResult.getName(), idKey, idValue});
            }
        }
        catch (Exception e) {
            hasGlobalError = true;
            ++nbErrors;
            logger.error("Failed to populate contents from synchronizable collection of id '{}'", (Object)collectionId, (Object)e);
        }
        return new LDAPCollectionHelperSearchResult(searchResults, hasGlobalError, nbErrors);
    }

    private List<Object> _getLDAPValues(Attribute attribute) throws NamingException {
        ArrayList<Object> ldapValues = new ArrayList<Object>();
        NamingEnumeration<?> values = attribute.getAll();
        while (values.hasMore()) {
            ldapValues.add(values.next());
        }
        return ldapValues;
    }

    protected SearchControls _getSearchControls(Map<String, List<String>> mapping, String searchScope) throws ProcessingException {
        SearchControls controls = new SearchControls();
        ArrayList<String> attributes = new ArrayList<String>();
        for (List<String> attribute : mapping.values()) {
            attributes.addAll(attribute);
        }
        String[] attrArray = attributes.toArray(new String[attributes.size()]);
        controls.setReturningAttributes(attrArray);
        controls.setSearchScope(this._getScope(searchScope));
        return controls;
    }

    protected int _getScope(String scopeStr) throws ProcessingException {
        try {
            return ScopeEnumerator.parseScope((String)scopeStr);
        }
        catch (IllegalArgumentException e) {
            throw new ProcessingException("Unable to parse scope", (Throwable)e);
        }
    }

    protected Object _getIdValue(String idKey, SearchResult entry, Logger logger) throws NamingException {
        Attribute ldapAttr = entry.getAttributes().get(idKey);
        if (ldapAttr == null) {
            logger.warn("LDAP attribute not found: '{}'", (Object)idKey);
        }
        return ldapAttr != null ? ldapAttr.get() : null;
    }

    public void transformTypedAttributes(Map<String, Map<String, List<Object>>> results, String contentTypeId, Set<String> allAttributes) {
        HashSet<String> dateAttributes = new HashSet<String>();
        HashSet<String> datetimeAttributes = new HashSet<String>();
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        for (String string : allAttributes) {
            String attributeType;
            if (!contentType.hasModelItem(string)) continue;
            switch (attributeType = contentType.getModelItem(string).getType().getId()) {
                case "date": {
                    dateAttributes.add(string);
                    break;
                }
                case "datetime": {
                    datetimeAttributes.add(string);
                    break;
                }
            }
        }
        if (!dateAttributes.isEmpty() || !datetimeAttributes.isEmpty()) {
            for (Map map : results.values()) {
                this._transformValuesAsTypedValues(map, dateAttributes, s -> LocalDate.parse(s, __BASIC_DATE_TIME));
                this._transformValuesAsTypedValues(map, datetimeAttributes, s -> ZonedDateTime.parse(s, __BASIC_DATE_TIME));
            }
        }
    }

    private <R> void _transformValuesAsTypedValues(Map<String, List<Object>> resultLine, Set<String> attributeNames, Function<String, R> typedFunction) {
        for (String attributeName : attributeNames) {
            this._transformValueAsTypedValue(resultLine, attributeName, typedFunction);
        }
    }

    private <R> void _transformValueAsTypedValue(Map<String, List<Object>> resultLine, String attributeName, Function<String, R> typedFunction) {
        List newValues = Optional.of(attributeName).map(resultLine::get).map(Collection::stream).orElseGet(Stream::empty).map(Object::toString).map(typedFunction).collect(Collectors.toList());
        if (!newValues.isEmpty()) {
            resultLine.put(attributeName, newValues);
        }
    }

    public record LDAPCollectionHelperSearchResult(Map<String, Map<String, Object>> searchResults, boolean hasGlobalError, int nbErrors) {
    }
}

