/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.ametys.core.cocoon.JSonReader;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.ServerCommHelper;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCCSearchAction
extends ServiceableAction {
    protected static final String FIELD_IMPORTED = "imported";
    protected SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    protected ServerCommHelper _serverCommHelper;
    protected JSONUtils _jsonUtils;
    private Logger _logger = LoggerFactory.getLogger(SCCSearchAction.class);

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO)((Object)smanager.lookup(SynchronizableContentsCollectionDAO.ROLE));
        this._serverCommHelper = (ServerCommHelper)smanager.lookup(ServerCommHelper.ROLE);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map jsParameters = this._serverCommHelper.getJsParameters();
        Map searchParams = (Map)jsParameters.get("values");
        boolean maskImported = searchParams.containsKey("maskImported") && Boolean.valueOf(searchParams.get("maskImported").toString()) != false;
        searchParams.remove("maskImported");
        String collectionId = (String)jsParameters.get("collectionId");
        SynchronizableContentsCollection collection = this._synchronizableContentsCollectionDAO.getSynchronizableContentsCollection(collectionId);
        Integer offset = this._getIntValue(jsParameters, "start", 0);
        Integer limit = this._getIntValue(jsParameters, "limit", Integer.MAX_VALUE);
        HashMap<String, Object> objectToRead = new HashMap<String, Object>();
        if (maskImported) {
            results = collection.search(searchParams, 0, Integer.MAX_VALUE, this._getSortList(jsParameters.get("sort")), this._logger);
            Iterator<String> resultKeys = results.keySet().iterator();
            int currentOffset = 0;
            while (currentOffset < offset && resultKeys.hasNext()) {
                if (collection.getContent(null, resultKeys.next(), true) != null) continue;
                ++currentOffset;
            }
            LinkedList<HashMap<String, Object>> finalResults = new LinkedList<HashMap<String, Object>>();
            int currentLimit = 0;
            while (currentLimit < limit && resultKeys.hasNext()) {
                String idValue = resultKeys.next();
                HashMap<String, Object> contentResults = new HashMap<String, Object>(results.get(idValue));
                if (collection.getContent(null, idValue, true) != null) continue;
                contentResults.put(FIELD_IMPORTED, false);
                finalResults.add(contentResults);
                ++currentLimit;
            }
            objectToRead.put("items", finalResults);
            objectToRead.put("total", collection.getTotalCount(searchParams, this._logger));
        } else {
            results = new LinkedHashMap<String, Map<String, Object>>(collection.search(searchParams, offset, limit, this._getSortList(jsParameters.get("sort")), this._logger));
            for (String idValue : results.keySet()) {
                HashMap<String, Object> contentResults = new HashMap<String, Object>(results.get(idValue));
                contentResults.put(FIELD_IMPORTED, collection.getContent(null, idValue, true) != null);
                results.put(idValue, contentResults);
            }
            objectToRead.put("items", results.values());
            objectToRead.put("total", collection.getTotalCount(searchParams, this._logger));
        }
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        request.setAttribute(JSonReader.OBJECT_TO_READ, objectToRead);
        return EMPTY_MAP;
    }

    private int _getIntValue(Map<String, Object> values, String key, int defaultValue) {
        if (values.containsKey(key)) {
            return Integer.valueOf(values.get(key).toString());
        }
        return defaultValue;
    }

    private List<Object> _getSortList(Object sortValues) {
        if (sortValues != null) {
            return this._jsonUtils.convertJsonToList(sortValues.toString());
        }
        return null;
    }
}

