/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * This class provides a widget for the mapping of a collection of a synchronizable contents based on a datasource.
 */
Ext.define('Ametys.plugins.contentio.widget.SynchronizableDataSourceMapping', {
    extend: 'Ametys.plugins.contentio.widget.AbstractMapping',
    
    /**
     * @cfg {String} [mappingColumnText] The header text to be used for column mapping
     */
    
    /**
     * @cfg {String} [mappingColumnTooltip] The tooltip to be used for column mapping
     */
    
    initComponent: function()
    {
        this._createModel();
        this._createGrid();
        
        this.items = [this._grid];
        this.callParent(arguments);
    },
    
    /**
     * @private
     * Creates the model for the store of the grid
     */
    _createModel: function()
    {
        var modelName = this._getModel();
        if (!Ext.data.schema.Schema.get('default').hasEntity(modelName))
        {
            Ext.define(modelName, {
                extend: 'Ext.data.Model',
                idProperty: 'metadata-ref',
                
                fields: [
                    {
                        name: 'metadata-ref', 
                        type: 'string', 
                        sortType: Ext.bind(function(metadataRef) {
                            var metadataLabel = this._getMetadataLabel(metadataRef);
                            return Ext.data.SortTypes.asNonAccentedUCString(metadataLabel);
                        }, this)
                    }, 
                    {name: 'attribute', type: 'string'}, 
                    {name: 'synchro', type: 'boolean'}
                ]
            });
        }
    },
    
    _getModel: function()
    {
        return 'Ametys.plugins.contentio.SynchronizableDataSourceMapping.Mapping$' + this.getId();
    },
    
    _getColumnsCfg: function()
    {
        return [{
            text: "{{i18n PLUGINS_CONTENTIO_WIDGET_MAPPING_FIELDS}}",
            tooltip: "{{i18n PLUGINS_CONTENTIO_WIDGET_MAPPING_FIELDS_DESC}}",
            dataIndex: 'metadata-ref',
            renderer: Ext.bind(this._renderMetadata, this),
            flex: 0.5
        }, {
        	text: this.mappingColumnText || "{{i18n PLUGINS_CONTENTIO_WIDGET_MAPPING_MAPPING}}", 
            tooltip: this.mappingColumnTooltip || "{{i18n PLUGINS_CONTENTIO_WIDGET_MAPPING_MAPPING_DESC}}", 
            dataIndex: 'attribute', 
            flex: 0.5,
            xtype: 'widgetcolumn', 
            widget: {
                xtype: 'textfield',
                listeners: {
                    'change': Ext.bind(this._onWidgetChange, this, ['attribute'], 0)
                }
            }
        }, {
        	text: "{{i18n PLUGINS_CONTENTIO_WIDGET_MAPPING_SYNCHRO}}", 
        	tooltip: "{{i18n PLUGINS_CONTENTIO_WIDGET_MAPPING_SYNCHRO_DESC}}", 
            dataIndex: 'synchro', 
            align: 'center', 
            width: 110,
            xtype: 'widgetcolumn', 
            widget: {
                xtype: 'checkbox',
                listeners: {
                    'change': Ext.bind(this._onWidgetChange, this, ['synchro'], 0)
                }
            }
        }];
    },
    
    updateRecord: function(record, value)
    {
    	record.set('attribute', value.attribute);
    	record.set('synchro', value.synchro);
    	record.commit();
    },
    
    getValueFromRecord: function (record)
    {
    	if (record.get("attribute"))
    	{
    		return Ext.clone(record.getData());
    	}
    	// Filter empty value
    	return null;
    },
    
    getErrors: function(value)
    {
        value = value || [];
        if (Ext.isString(value))
        {
            value = Ext.decode(value);
        }
        
        var errors = this.callParent(arguments);
        return errors;
    }
});
