/*
 *  Copyright 2015 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.export.sql;

import java.util.ArrayList;
import java.util.List;

/**
 * ExportTableInfo object
 */
public class ExportTableInfo
{
    private String _name;
    private int _nbColumns;
    private List<String> _createQueries;
    private List<String> _commentQueries;
    private List<String> _insertQueries;
    
    /**
     * The constructor
     * @param name the table name
     */
    public ExportTableInfo(String name)
    {
        _name = name;
        _nbColumns = 0;
        _createQueries = new ArrayList<>();
        _commentQueries = new ArrayList<>();
        _insertQueries = new ArrayList<>();
    }
    
    /**
     * Get the table name
     * @return the table name
     */
    public String getTableName()
    {
        return _name;
    }
    
    /**
     * Get the number of columns of the table
     * @return the number of columns of the table
     */
    public int getNbColumns()
    {
        return _nbColumns;
    }
    
    /**
     * Increment the number of columns
     */
    public void incrementNbColumns()
    {
        _nbColumns++;
    }
    
    /**
     * Increment the number of columns by nb
     * @param nb the nb to add
     */
    public void incrementNbColumns(int nb)
    {
        _nbColumns += nb;
    }
    
    /** 
     * Get the list of queries
     * @return the list of queries
     */
    public List<String> getCreateQueries()
    {
        return _createQueries;
    }
    
    /**
     * Add a query
     * @param query the query to add
     */
    public void addCreateQuery(String query)
    {
        _createQueries.add(query);
    }
    
    /** 
     * Get the list of queries
     * @return the list of queries
     */
    public List<String> getCommentQueries()
    {
        return _commentQueries;
    }
    
    /**
     * Add a query
     * @param query the query to add
     */
    public void addCommentQuery(String query)
    {
        _commentQueries.add(query);
    }
    
    /** 
     * Get the list of queries
     * @return the list of queries
     */
    public List<String> getInsertQueries()
    {
        return _insertQueries;
    }
    
    /**
     * Add a query
     * @param query the query to add
     */
    public void addInsertQuery(String query)
    {
        _insertQueries.add(query);
    }
}
