/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.in.xml;

import java.io.IOException;
import java.io.InputStream;

import org.w3c.dom.Document;

import org.ametys.plugins.contentio.in.ContentImporter;

/**
 * {@link ContentImporter} which imports contents from XML files.<br>
 * The {@link #supports(Document)} method is used instead of the {@link #supports(InputStream, String)},
 * so that the XML file is parsed only once.
 */
public interface XmlContentImporter extends ContentImporter
{
    /**
     * Tests if the {@link XmlContentImporter} is able to import the corresponding Document.
     * @param document the XML {@link Document} to test.
     * @return true if the {@link XmlContentImporter} can import the corresponding stream, false otherwise.
     * @throws IOException if an error occurs.
     */
    public boolean supports(Document document) throws IOException;
    
}
