/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize.clientsideelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;

/**
 * This implementation test if at least one SCC is associated to the model defined by the sccModelId.
 * If yes, the first collection is used to create the button, it there are no collections, the button is not displayed.
 * Also, it set some elements to be used by the import tool (SCCSearchTool for most cases).
 */
public class SCCClientSideElement extends StaticClientSideElement
{
    /** SCC helper */
    protected SynchronizableContentsCollectionHelper _sccHelper;
    
    @Override
    public void service(ServiceManager smanager) throws ServiceException
    {
        super.service(smanager);
        _sccHelper = (SynchronizableContentsCollectionHelper) smanager.lookup(SynchronizableContentsCollectionHelper.ROLE);
    }
    
    @Override
    public List<Script> getScripts(boolean ignoreRights, Map<String, Object> contextParameters)
    {
        List<Script> clonedScripts = new ArrayList<>();
        
        List<Script> scripts = super.getScripts(ignoreRights, contextParameters);
        
        for (Script script : scripts)
        {
            if (script.getParameters().containsKey("sccModelId"))
            {
                String sccModelId = (String) script.getParameters().get("sccModelId");
                SynchronizableContentsCollection collection = _sccHelper.getSCCFromModelId(sccModelId);
                if (collection != null)
                {
                    clonedScripts.add(_getScriptFromCollection(script, collection));
                }
            }
        }
        
        return clonedScripts;
    }

    /**
     * Get a cloned script by updating configuration with collection values.
     * @param script The script to clone
     * @param collection The collection
     * @return A cloned script
     */
    @SuppressWarnings("unchecked")
    protected Script _getScriptFromCollection(Script script, SynchronizableContentsCollection collection)
    {
        Script clonedScript = new Script(script);
        
        Map<String, Object> openToolParams = new HashMap<>();
        
        Object existingParams = clonedScript.getParameters().get("opentool-params");
        if (existingParams instanceof Map)
        {
            openToolParams.putAll((Map) existingParams);
        }
        openToolParams.put("id", collection.getId());
        openToolParams.put("collectionId", collection.getId());
        openToolParams.put("collectionLabel", collection.getLabel());
        clonedScript.getParameters().put("opentool-params", openToolParams);
        
        return clonedScript;
    }
}
