/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.contentio.archive.ArchiveHandler;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.config.Config;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Request;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractArchiveSchedulable
extends AbstractStaticSchedulable {
    protected I18nUtils _i18nUtils;
    protected ArchiveHandler _archiveHandler;

    AbstractArchiveSchedulable() {
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._i18nUtils = (I18nUtils)manager.lookup(I18nUtils.ROLE);
        this._archiveHandler = (ArchiveHandler)((Object)manager.lookup(ArchiveHandler.ROLE));
    }

    protected final User _getUser() {
        Request request = ContextHelper.getRequest((Context)this._context);
        UserIdentity userIdentity = AuthenticateAction.getUserIdentityFromSession((Request)request);
        User user = userIdentity != null ? this._userManager.getUser(userIdentity) : null;
        return user;
    }

    protected final void _sendMail(String subject, String body, String userEmail) {
        String email;
        String adminEmail = (String)Config.getInstance().getValue("smtp.mail.sysadminto");
        String string = StringUtils.isNotEmpty((CharSequence)userEmail) ? userEmail : (email = StringUtils.isNotEmpty((CharSequence)adminEmail) ? adminEmail : null);
        if (email != null) {
            try {
                SendMailHelper.newMail().withSubject(subject).withHTMLBody(body).withRecipient(email).sendMail();
            }
            catch (Exception e) {
                this.getLogger().warn("Unable to send archiving/import result by email to " + email, (Throwable)e);
            }
        } else {
            this.getLogger().warn("An email should have been sent after archiving/import process but the current user has no email and the admin email is not set in the configuration.");
        }
    }
}

