/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.csv;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.contentio.csv.ImportCSVFileHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

public class ImportReferenceTablesCSVFileHelper
extends ImportCSVFileHelper {
    private CurrentUserProvider _currentUser;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._currentUser = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
    }

    @Override
    @Callable(rights={"CMS_Rights_ReferenceTables_Import"}, context="/cms")
    public Map<String, Object> importContents(Map<String, Object> config, Map<String, Object> formValues, List<Map<String, Object>> mappingValues) throws IOException {
        String contentTypeId = (String)config.get("contentType");
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        if (contentType.isReferenceTable()) {
            return super.importContents(config, formValues, mappingValues);
        }
        UserIdentity user = this._currentUser.getUser();
        throw new AccessDeniedException("User" + UserIdentity.userIdentityToString((UserIdentity)user) + " tried to import reference table entries but this is not allowed for content type '" + contentTypeId + "'");
    }
}

