/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize;

import java.util.List;
import java.util.Map;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionDAO;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobExecutionContext;

public class SynchronizeAllCollectionsSchedulable
extends AbstractStaticSchedulable {
    private SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO)((Object)manager.lookup(SynchronizableContentsCollectionDAO.ROLE));
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        List<SynchronizableContentsCollection> collections = this._synchronizableContentsCollectionDAO.getSynchronizableContentsCollections();
        for (SynchronizableContentsCollection collection : collections) {
            progressionTracker.addContainerStep(collection.getId(), new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_SCHEDULER_SYNCHRONIZE_COLLECTION_STEP_LABEL", Map.of("collectionLabel", collection.getLabel())));
        }
        for (SynchronizableContentsCollection collection : collections) {
            collection.populate(this.getLogger(), (ContainerProgressionTracker)progressionTracker.getStep(collection.getId()));
        }
    }
}

