/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.search;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.ametys.runtime.i18n.I18nizableText;

public class SCCSearchModelConfiguration {
    public static final String CRITERIA_MASK_IMPORTED = "maskImported";
    private static final Map<String, Object> __MASK_IMPORTED_CRITERION = ImmutableMap.of((Object)"id", (Object)"maskImported", (Object)"label", (Object)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_UITOOL_SEARCH_MASK_IMPORTED"), (Object)"type", (Object)"BOOLEAN");
    private boolean _displayMaskImported = true;
    private Map<String, Map<String, Object>> _criteria = new LinkedHashMap<String, Map<String, Object>>();
    private List<Map<String, Object>> _columns = new LinkedList<Map<String, Object>>();

    public void displayMaskImported(boolean displayMaskImported) {
        this._displayMaskImported = displayMaskImported;
    }

    public void addCriterion(String id) {
        this.addCriterion(id, new I18nizableText(id));
    }

    public void addCriterion(String id, I18nizableText label) {
        this.addCriterion(id, label, "STRING");
    }

    public void addCriterion(String id, I18nizableText label, String type) {
        this.addCriterion(id, label, type, null);
    }

    public void addCriterion(String id, I18nizableText label, String type, String widget) {
        HashMap<String, String> criterion = new HashMap<String, String>();
        criterion.put("id", id);
        criterion.put("label", (String)label);
        criterion.put("type", type);
        criterion.put("widget", widget);
        this._criteria.put(id, criterion);
    }

    public void addColumn(String id) {
        this.addColumn(id, new I18nizableText(id));
    }

    public void addColumn(String id, I18nizableText label) {
        this.addColumn(id, label, 150);
    }

    public void addColumn(String id, I18nizableText label, int width) {
        this.addColumn(id, label, width, true);
    }

    public void addColumn(String id, I18nizableText label, boolean sortable) {
        this.addColumn(id, label, 150, sortable);
    }

    public void addColumn(String id, I18nizableText label, int width, boolean sortable) {
        this.addColumn(id, label, width, sortable, "string");
    }

    public void addColumn(String id, I18nizableText label, int width, boolean sortable, String type) {
        String renderer = null;
        if (this._displayMaskImported && this._columns.isEmpty()) {
            renderer = "Ametys.plugins.contentio.search.SCCSearchTool.renderImported";
        }
        this.addColumn(id, label, width, sortable, type, renderer);
    }

    public void addColumn(String id, I18nizableText label, int width, boolean sortable, String type, String renderer) {
        HashMap<String, Object> column = new HashMap<String, Object>();
        column.put("path", id);
        column.put("label", label);
        column.put("sortable", sortable);
        column.put("type", type);
        column.put("width", width);
        column.put("renderer", renderer);
        this._columns.add(column);
    }

    public Map<String, Object> toJSON() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        LinkedHashMap<String, Map<String, Object>> displayedCriteria = new LinkedHashMap<String, Map<String, Object>>(this._criteria);
        if (this._displayMaskImported) {
            displayedCriteria.put(CRITERIA_MASK_IMPORTED, __MASK_IMPORTED_CRITERION);
        }
        json.put("criteria", ImmutableMap.of((Object)UUID.randomUUID().toString(), (Object)ImmutableMap.of((Object)"elements", displayedCriteria, (Object)"role", (Object)"fieldset")));
        json.put("columns", this._columns);
        json.put("searchUrlPlugin", "contentio");
        json.put("searchUrl", "scc-search/list.json");
        json.put("pageSize", 50);
        return json;
    }
}

