/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.systemprop;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.ametys.cms.repository.Content;
import org.ametys.cms.search.query.Query;
import org.ametys.cms.search.systemprop.AbstractIndexableSystemProperty;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.contentio.synchronize.search.query.CollectionsQuery;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.type.DataContext;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CollectionsSystemProperty
extends AbstractIndexableSystemProperty<String, String, Content> {
    public static final String SOLR_FIELD_NAME = "scc";

    public Query getQuery(Object value, Query.Operator operator, String language, Map<String, Object> contextualParameters) {
        String[] synchronizableContentsCollectionIds = this.parseStringArray(value);
        Query.Operator allowedOperator = this._allowedOperator(operator);
        return new CollectionsQuery(allowedOperator, synchronizableContentsCollectionIds);
    }

    private Query.Operator _allowedOperator(Query.Operator requestedOperator) {
        return requestedOperator == Query.Operator.NE ? requestedOperator : Query.Operator.EQ;
    }

    public String getSolrFieldName() {
        return SOLR_FIELD_NAME;
    }

    public String getSolrSortFieldName() {
        return SOLR_FIELD_NAME;
    }

    public String getSolrFacetFieldName() {
        return "scc_dv";
    }

    public Object getValue(Content content) {
        return content.getInternalDataHolder().getValue(SOLR_FIELD_NAME, (Object)new String[0]);
    }

    public Object valueToJSON(Content content, DataContext context) {
        return Stream.of((String[])this.getValue(content)).map(sccId -> Map.of("value", sccId, "label", this._getLabel((String)sccId))).toList();
    }

    public void valueToSAX(ContentHandler contentHandler, Content content, DataContext context) throws SAXException {
        String[] sccIds;
        for (String sccId : sccIds = (String[])this.getValue(content)) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("value", sccId);
            XMLUtils.startElement((ContentHandler)contentHandler, (String)SOLR_FIELD_NAME, (Attributes)attrs);
            this._getLabel(sccId).toSAX(contentHandler);
            XMLUtils.endElement((ContentHandler)contentHandler, (String)SOLR_FIELD_NAME);
        }
    }

    private I18nizableText _getLabel(String sccId) {
        return Optional.of(sccId).map(LambdaUtils.wrap(arg_0 -> ((Enumerator)this.getEnumerator()).getEntry(arg_0))).orElseGet(() -> new I18nizableText(sccId));
    }

    protected String getTypeId() {
        return "string";
    }
}

