/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import com.google.common.base.Predicates;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.core.schedule.Runnable;
import org.ametys.core.ui.Callable;
import org.ametys.core.ui.StaticClientSideElement;
import org.ametys.core.user.UserIdentity;
import org.ametys.plugins.contentio.archive.ArchiveHandler;
import org.ametys.plugins.contentio.archive.ImportArchiveRunnable;
import org.ametys.plugins.contentio.archive.MergePolicy;
import org.ametys.plugins.contentio.archive.PartialImport;
import org.ametys.plugins.core.schedule.Scheduler;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.SchedulerException;

public class ImportArchiveClientSideElement
extends StaticClientSideElement {
    private ArchiveHandler _archiveHandler;
    private Scheduler _scheduler;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._archiveHandler = (ArchiveHandler)((Object)smanager.lookup(ArchiveHandler.ROLE));
        this._scheduler = (Scheduler)smanager.lookup(Scheduler.ROLE);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getMergePolicies() {
        return MergePolicy._ids.values().stream().map(MergePolicy::toJson).collect(Collectors.toList());
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, String>> getArchiveFiles() {
        return this._archiveHandler.getArchiveFiles().map(label -> Map.of("archiveName", label)).collect(Collectors.toList());
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getAvailablePartialImports(String archiveName) throws IOException {
        return this._archiveHandler.getPartialImports(archiveName).map(PartialImport::toJson).collect(Collectors.toList());
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> scheduleImport(Map<String, Object> values) {
        UserIdentity user = this._currentUserProvider.getUser();
        String archiveName = Objects.requireNonNull((String)values.get("archive"));
        Optional<Collection> clientSideElements = Optional.of("elements").map(values::get).filter(Collection.class::isInstance).map(Collection.class::cast);
        Optional<Collection<String>> elements = clientSideElements.filter((Predicate<Collection>)Predicates.not(Collection::isEmpty));
        MergePolicy mergePolicy = MergePolicy.forId((String)values.get("mergePolicy"));
        try {
            this._scheduler.scheduleJob((Runnable)new ImportArchiveRunnable(archiveName, elements, mergePolicy, user));
        }
        catch (SchedulerException e) {
            this.getLogger().error("An exception occured when trying to schedule archive import", (Throwable)e);
            return Map.of("ok", false);
        }
        return Map.of("ok", true);
    }
}

