/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.DomNodeHelper;
import org.ametys.plugins.contentio.archive.ImportGlobalFailException;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.UnitaryImporter;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.explorer.resources.Resource;
import org.ametys.plugins.explorer.resources.ResourceCollection;
import org.ametys.plugins.explorer.resources.jcr.JCRResource;
import org.ametys.plugins.explorer.resources.jcr.JCRResourceFactory;
import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollection;
import org.ametys.plugins.explorer.resources.jcr.JCRResourcesCollectionFactory;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectFactoryExtensionPoint;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.plugins.repository.dublincore.DublinCoreAwareAmetysObject;
import org.ametys.plugins.repository.dublincore.ModifiableDublinCoreAwareAmetysObject;
import org.ametys.plugins.repository.jcr.DefaultTraversableAmetysObject;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ResourcesArchiverHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = ResourcesArchiverHelper.class.getName();
    private static final String __PROPERTIES_METADATA_XML_FILE_NAME_SUFFIX = "properties.xml";
    private static final String __DC_METADATA_XML_FILE_NAME_SUFFIX = "dc.xml";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_ROOT = "dublin-core-metadata";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_TITLE = "title";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_CREATOR = "creator";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_SUBJECT = "subject";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_DESCRIPTION = "description";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_PUBLISHER = "publisher";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_CONTRIBUTOR = "contributor";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_DATE = "date";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_TYPE = "type";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_FORMAT = "format";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_IDENTIFIER = "identifier";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_SOURCE = "source";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_LANGUAGE = "language";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_RELATION = "relation";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_COVERAGE = "coverage";
    private static final String __DC_METADATA_XML_EXPORT_TAG_NAME_RIGHTS = "rights";
    private JCRResourcesCollectionFactory _jcrResourcesCollectionFactory;
    private JCRResourceFactory _jcrResourceFactory;
    private Context _cocoonContext;

    public void service(ServiceManager manager) throws ServiceException {
        AmetysObjectFactoryExtensionPoint ametysObjectFactoryEP = (AmetysObjectFactoryExtensionPoint)manager.lookup(AmetysObjectFactoryExtensionPoint.ROLE);
        this._jcrResourcesCollectionFactory = (JCRResourcesCollectionFactory)ametysObjectFactoryEP.getExtension(JCRResourcesCollectionFactory.class.getName());
        this._jcrResourceFactory = (JCRResourceFactory)ametysObjectFactoryEP.getExtension(JCRResourceFactory.class.getName());
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._cocoonContext = (Context)context.get((Object)"environment-context");
    }

    public void exportCollection(ResourceCollection collection, ZipOutputStream zos, String prefix) throws IOException {
        if (collection == null) {
            return;
        }
        zos.putNextEntry(new ZipEntry(StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0])));
        try (AmetysObjectIterable objects = collection.getChildren();){
            for (AmetysObject object : objects) {
                this._exportChild(object, zos, prefix);
            }
        }
        try {
            this._exportCollectionMetadataEntry(collection, zos, prefix);
            Node collectionNode = ((JCRAmetysObject)collection).getNode();
            Archivers.exportAcl(collectionNode, zos, "_metadata/" + prefix + "acl.xml");
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to SAX some information for collection '" + collection.getPath() + "' for archiving", e);
        }
    }

    private void _exportCollectionMetadataEntry(ResourceCollection collection, ZipOutputStream zos, String prefix) throws IOException {
        String metadataFullPrefix = "_metadata/" + prefix;
        ZipEntry contentEntry = new ZipEntry(metadataFullPrefix + __PROPERTIES_METADATA_XML_FILE_NAME_SUFFIX);
        zos.putNextEntry(contentEntry);
        try {
            TransformerHandler contentHandler = Archivers.newTransformerHandler();
            contentHandler.setResult(new StreamResult(zos));
            contentHandler.startDocument();
            this._saxSystemMetadata(collection, (ContentHandler)contentHandler);
            contentHandler.endDocument();
        }
        catch (TransformerConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to SAX properties for collection '" + collection.getPath() + "' for archiving", e);
        }
    }

    private void _exportChild(AmetysObject child, ZipOutputStream zos, String prefix) throws IOException {
        if (child instanceof ResourceCollection) {
            String newPrefix = prefix + child.getName() + "/";
            this.exportCollection((ResourceCollection)child, zos, newPrefix);
        } else if (child instanceof Resource) {
            this.exportResource((Resource)child, zos, prefix);
        }
    }

    public void exportResource(Resource resource, ZipOutputStream zos, String prefix) throws IOException {
        ZipEntry resourceEntry = new ZipEntry(prefix + resource.getName());
        zos.putNextEntry(resourceEntry);
        try (InputStream is = resource.getInputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)zos);
        }
        this._exportResourceMetadataEntry(resource, zos, prefix, __DC_METADATA_XML_FILE_NAME_SUFFIX, this::_saxDublinCoreMetadata, "Dublin Core metadata");
        this._exportResourceMetadataEntry(resource, zos, prefix, __PROPERTIES_METADATA_XML_FILE_NAME_SUFFIX, this::_saxSystemMetadata, "properties");
    }

    private void _exportResourceMetadataEntry(Resource resource, ZipOutputStream zos, String prefix, String metadataFileNameSuffix, ResourceMetadataSaxer metadataSaxer, String debugName) throws IOException {
        String metadataFullPrefix = "_metadata/" + prefix + resource.getName() + "_";
        ZipEntry contentEntry = new ZipEntry(metadataFullPrefix + metadataFileNameSuffix);
        zos.putNextEntry(contentEntry);
        try {
            TransformerHandler contentHandler = Archivers.newTransformerHandler();
            contentHandler.setResult(new StreamResult(zos));
            contentHandler.startDocument();
            metadataSaxer.sax(resource, contentHandler);
            contentHandler.endDocument();
        }
        catch (TransformerConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to SAX " + debugName + " for resource '" + resource.getPath() + "' for archiving", e);
        }
    }

    private void _saxDublinCoreMetadata(DublinCoreAwareAmetysObject dcObject, ContentHandler contentHandler) throws SAXException {
        XMLUtils.startElement((ContentHandler)contentHandler, (String)__DC_METADATA_XML_EXPORT_TAG_NAME_ROOT);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_TITLE, dcObject.getDCTitle(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_CREATOR, dcObject.getDCCreator(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_SUBJECT, dcObject.getDCSubject(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_DESCRIPTION, dcObject.getDCDescription(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_PUBLISHER, dcObject.getDCPublisher(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_CONTRIBUTOR, dcObject.getDCContributor(), contentHandler);
        this._saxLocalDateIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_DATE, dcObject.getDCDate(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_TYPE, dcObject.getDCType(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_FORMAT, dcObject.getDCFormat(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_IDENTIFIER, dcObject.getDCIdentifier(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_SOURCE, dcObject.getDCSource(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_LANGUAGE, dcObject.getDCLanguage(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_RELATION, dcObject.getDCRelation(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_COVERAGE, dcObject.getDCCoverage(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_RIGHTS, dcObject.getDCRights(), contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)__DC_METADATA_XML_EXPORT_TAG_NAME_ROOT);
    }

    private void _saxSystemMetadata(Resource resource, ContentHandler contentHandler) throws SAXException {
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"resource");
        this._saxIfNotNull("id", resource.getId(), contentHandler);
        this._saxIfNotNull("name", resource.getName(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_CREATOR, resource.getCreator(), contentHandler);
        this._saxZonedDateTimeIfNotNull("creationDate", resource.getCreationDate(), contentHandler);
        this._saxIfNotNull(__DC_METADATA_XML_EXPORT_TAG_NAME_CONTRIBUTOR, resource.getLastContributor(), contentHandler);
        this._saxZonedDateTimeIfNotNull("lastModified", resource.getLastModified(), contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"resource");
    }

    private void _saxSystemMetadata(ResourceCollection collection, ContentHandler contentHandler) throws SAXException {
        XMLUtils.startElement((ContentHandler)contentHandler, (String)"resource-collection");
        this._saxIfNotNull("id", collection.getId(), contentHandler);
        this._saxIfNotNull("name", collection.getName(), contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)"resource-collection");
    }

    private void _saxIfNotNull(String name, String value, ContentHandler contentHandler) throws SAXException {
        if (value != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)name, (String)value);
        }
    }

    private void _saxIfNotNull(String name, UserIdentity value, ContentHandler contentHandler) throws SAXException {
        if (value != null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)name, (String)UserIdentity.userIdentityToString((UserIdentity)value));
        }
    }

    private void _saxIfNotNull(String name, String[] values, ContentHandler contentHandler) throws SAXException {
        if (values != null) {
            for (String value : values) {
                XMLUtils.createElement((ContentHandler)contentHandler, (String)name, (String)value);
            }
        }
    }

    private void _saxLocalDateIfNotNull(String name, Date value, ContentHandler contentHandler) throws SAXException {
        if (value != null) {
            LocalDate ld = DateUtils.asLocalDate((Date)value);
            XMLUtils.createElement((ContentHandler)contentHandler, (String)name, (String)ld.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
    }

    private void _saxZonedDateTimeIfNotNull(String name, Date value, ContentHandler contentHandler) throws SAXException {
        if (value != null) {
            ZonedDateTime zdt = DateUtils.asZonedDateTime((Date)value, (ZoneId)ZoneId.systemDefault());
            XMLUtils.createElement((ContentHandler)contentHandler, (String)name, (String)zdt.format(DateUtils.getISODateTimeFormatter()));
        }
    }

    public ImportReport importCollection(String commonPrefix, Node parentOfRootResources, Path zipPath, Merger merger) throws IOException {
        List<JCRResource> importedResources;
        Importer importer;
        try {
            importer = new Importer(commonPrefix, parentOfRootResources, zipPath, merger, this.getLogger());
            importer.importRoot();
            importedResources = importer.getImportedResource();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        this._saveImported(parentOfRootResources);
        this._checkoutImported(importedResources);
        return importer._report;
    }

    private void _saveImported(Node parentOfRoot) {
        try {
            Session session = parentOfRoot.getSession();
            if (session.hasPendingChanges()) {
                this.getLogger().warn("{} still has pending changes while we should have saved unitarily every object. Another save will be done, but it is not normal.", (Object)parentOfRoot);
                session.save();
            }
        }
        catch (RepositoryException e) {
            throw new AmetysRepositoryException("Unable to save changes", (Throwable)e);
        }
    }

    private void _checkoutImported(List<JCRResource> importedResources) {
        for (JCRResource resource : importedResources) {
            resource.checkpoint();
        }
    }

    @FunctionalInterface
    private static interface ResourceMetadataSaxer {
        public void sax(Resource var1, ContentHandler var2) throws SAXException;
    }

    private class Importer {
        final ImportReport _report = new ImportReport();
        private final String _commonPrefix;
        private final Node _parentOfRoot;
        private final Path _zipArchivePath;
        private final Merger _merger;
        private final Logger _logger;
        private final DocumentBuilder _builder;
        private final List<JCRResource> _importedResources = new ArrayList<JCRResource>();
        private JCRResourcesCollection _root;
        private final UnitaryCollectionImporter _unitaryCollectionImporter = new UnitaryCollectionImporter();
        private final UnitaryResourceImporter _unitaryResourceImporter = new UnitaryResourceImporter();

        Importer(String commonPrefix, Node parentOfRoot, Path zipArchivePath, Merger merger, Logger logger) throws ParserConfigurationException {
            this._commonPrefix = commonPrefix;
            this._parentOfRoot = parentOfRoot;
            this._zipArchivePath = zipArchivePath;
            this._merger = merger;
            this._logger = logger;
            this._builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }

        void importRoot() throws IOException {
            if (ZipEntryHelper.zipEntryFolderExists(this._zipArchivePath, this._commonPrefix)) {
                Path rootFolderToImport = ZipEntryHelper.zipFileRoot(this._zipArchivePath).resolve(this._commonPrefix);
                this._importResourceCollectionAndChildren(rootFolderToImport);
            }
        }

        List<JCRResource> getImportedResource() {
            return this._importedResources;
        }

        private void _createResourceCollectionAcl(Node collectionNode, String folderPath) throws IOException {
            String zipEntryPath = "_metadata/" + StringUtils.strip((String)folderPath, (String)"/") + "/acl.xml";
            try {
                this._logger.debug("Trying to import ACL node for ResourcesCollection '{}', from ACL XML file '{}', if it exists", (Object)collectionNode, (Object)zipEntryPath);
                Archivers.importAcl(collectionNode, this._zipArchivePath, this._merger, zipEntryPath, this._logger);
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }

        private void _importChildren(Path folder) throws IOException {
            DirectoryStream<Path> childFiles;
            String pathPrefix = this._relativePath(folder);
            try (DirectoryStream<Path> directoryStream = childFiles = this._getDirectFileChildren(pathPrefix);){
                for (Path childFile : childFiles) {
                    this._importResource(childFile).ifPresent(this._importedResources::add);
                }
            }
            DirectoryStream<Path> childFolders = this._getDirectFolderChildren(pathPrefix);
            try (DirectoryStream<Path> directoryStream = childFolders;){
                for (Path childFolder : childFolders) {
                    this._importResourceCollectionAndChildren(childFolder);
                }
            }
        }

        private DirectoryStream<Path> _getDirectFolderChildren(String pathPrefix) throws IOException {
            return ZipEntryHelper.children(this._zipArchivePath, Optional.of(this._commonPrefix + pathPrefix), p -> Files.isDirectory(p, new LinkOption[0]));
        }

        private DirectoryStream<Path> _getDirectFileChildren(String pathPrefix) throws IOException {
            return ZipEntryHelper.children(this._zipArchivePath, Optional.of(this._commonPrefix + pathPrefix), p -> !Files.isDirectory(p, new LinkOption[0]));
        }

        private void _importResourceCollectionAndChildren(Path folder) throws IOException {
            Optional<Node> optionalCollectionNode = this._importResourceCollection(folder);
            if (optionalCollectionNode.isPresent()) {
                Node collectionNode = optionalCollectionNode.get();
                this._createResourceCollectionAcl(collectionNode, folder.toString());
                this._importChildren(folder);
            }
        }

        private Optional<Node> _importResourceCollection(Path folder) throws ImportGlobalFailException {
            return this._unitaryCollectionImporter.unitaryImport(this._zipArchivePath, folder, this._merger, this._logger);
        }

        private Document _getFolderPropertiesXml(Path folder) throws IOException {
            Document document;
            block8: {
                String zipEntryPath = "_metadata/" + StringUtils.strip((String)folder.toString(), (String)"/") + "/" + ResourcesArchiverHelper.__PROPERTIES_METADATA_XML_FILE_NAME_SUFFIX;
                InputStream stream = ZipEntryHelper.zipEntryFileInputStream(this._zipArchivePath, zipEntryPath);
                try {
                    Document doc;
                    document = doc = this._builder.parse(stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SAXException e) {
                        throw new IOException(e);
                    }
                }
                stream.close();
            }
            return document;
        }

        private Node _createResourceCollection(Path folder, String id, Document propertiesXml) throws IOException, Archivers.AmetysObjectNotImportedException, TransformerException {
            boolean isRoot = this._isRoot(folder);
            Node parentNode = this._retrieveParentJcrNode(folder, isRoot);
            String uuid = StringUtils.substringAfter((String)id, (String)"://");
            String collectionName = Archivers.xpathEvalNonEmpty("resource-collection/name", propertiesXml);
            this._logger.info("Creating a ResourcesCollection object for '{}' folder (id={})", (Object)folder, (Object)id);
            try {
                Node resourceCollection = this._createChildResourceCollection(parentNode, uuid, collectionName);
                if (isRoot) {
                    this._root = ResourcesArchiverHelper.this._jcrResourcesCollectionFactory.getAmetysObject(resourceCollection, null);
                }
                return resourceCollection;
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }

        private boolean _isRoot(Path folder) {
            String folderPath = StringUtils.strip((String)folder.toString(), (String)"/");
            String commonPrefixToCompare = StringUtils.strip((String)this._commonPrefix, (String)"/");
            return commonPrefixToCompare.equals(folderPath);
        }

        private Node _createChildResourceCollection(Node parentNode, String uuid, String collectionName) throws RepositoryException {
            Node srcNode = parentNode.addNode(collectionName, "ametys:resources-collection");
            Node nodeWithDesiredUuid = Archivers.replaceNodeWithDesiredUuid(srcNode, uuid);
            return nodeWithDesiredUuid;
        }

        private String _relativePath(Path folderOrFile) {
            String commonPrefixToRemove = "/" + StringUtils.strip((String)this._commonPrefix, (String)"/");
            String relPath = folderOrFile.toString();
            relPath = relPath.startsWith(commonPrefixToRemove) ? StringUtils.substringAfter((String)relPath, (String)commonPrefixToRemove) : relPath;
            relPath = StringUtils.strip((String)relPath, (String)"/");
            return relPath;
        }

        private Node _retrieveParentJcrNode(Path fileOrFolder, boolean isRoot) {
            if (isRoot) {
                return this._parentOfRoot;
            }
            if (this._root == null) {
                throw new IllegalStateException("Unexpected error, the root must have been created before.");
            }
            Path parent = fileOrFolder.getParent();
            String parentRelPath = this._relativePath(parent);
            return parentRelPath.isEmpty() ? this._root.getNode() : ((JCRResourcesCollection)ResourcesArchiverHelper.this._jcrResourcesCollectionFactory.getChild((DefaultTraversableAmetysObject)this._root, parentRelPath)).getNode();
        }

        private Optional<JCRResource> _importResource(Path file) throws ImportGlobalFailException {
            return this._unitaryResourceImporter.unitaryImport(this._zipArchivePath, file, this._merger, this._logger);
        }

        private Document _getFilePropertiesXml(Path file) throws IOException {
            Document document;
            block8: {
                String zipEntryPath = "_metadata/" + StringUtils.strip((String)file.toString(), (String)"/") + "_" + ResourcesArchiverHelper.__PROPERTIES_METADATA_XML_FILE_NAME_SUFFIX;
                InputStream stream = ZipEntryHelper.zipEntryFileInputStream(this._zipArchivePath, zipEntryPath);
                try {
                    Document doc;
                    document = doc = this._builder.parse(stream);
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SAXException e) {
                        throw new IOException(e);
                    }
                }
                stream.close();
            }
            return document;
        }

        private JCRResource _createdResource(Path file, String id, Document propertiesXml) throws IOException, Archivers.AmetysObjectNotImportedException {
            Node parentNode = this._retrieveParentJcrNode(file, false);
            String uuid = StringUtils.substringAfter((String)id, (String)"://");
            String resourceName = file.getFileName().toString();
            this._logger.info("Creating a Resource object for '{}' file (id={})", (Object)file, (Object)id);
            try {
                Node resourceNode = this._createChildResource(parentNode, uuid, resourceName);
                this._setResourceData(resourceNode, file, propertiesXml);
                this._setResourceProperties(resourceNode, propertiesXml);
                this._setResourceMetadata(resourceNode, file);
                JCRResource createdResource = this._resolveResource(resourceNode);
                return createdResource;
            }
            catch (RepositoryException | TransformerException e) {
                throw new IOException(e);
            }
        }

        private Node _createChildResource(Node parentNode, String uuid, String resourceName) throws RepositoryException {
            Node srcNode = parentNode.addNode(resourceName, "ametys:resource");
            Node nodeWithDesiredUuid = Archivers.replaceNodeWithDesiredUuid(srcNode, uuid);
            return nodeWithDesiredUuid;
        }

        private JCRResource _resolveResource(Node resourceNode) {
            return ResourcesArchiverHelper.this._jcrResourceFactory.getAmetysObject(resourceNode, null);
        }

        private void _setResourceData(Node resourceNode, Path file, Document propertiesXml) throws RepositoryException, IOException, TransformerException {
            Node resourceContentNode = resourceNode.addNode("jcr:content", "nt:resource");
            String mimeType = this._getMimeType(file);
            resourceContentNode.setProperty("jcr:mimeType", mimeType);
            try (InputStream stream = ZipEntryHelper.zipEntryFileInputStream(this._zipArchivePath, file.toString());){
                Binary binary = resourceNode.getSession().getValueFactory().createBinary(stream);
                resourceContentNode.setProperty("jcr:data", binary);
            }
            Date lastModified = Objects.requireNonNull(DomNodeHelper.nullableDatetimeValue(propertiesXml, "resource/lastModified"));
            GregorianCalendar lastModifiedCal = new GregorianCalendar();
            lastModifiedCal.setTime(lastModified);
            resourceContentNode.setProperty("jcr:lastModified", (Calendar)lastModifiedCal);
        }

        private void _setResourceProperties(Node resourceNode, Document propertiesXml) throws TransformerException, Archivers.AmetysObjectNotImportedException, RepositoryException {
            UserIdentity contributor = UserIdentity.stringToUserIdentity((String)Archivers.xpathEvalNonEmpty("resource/contributor", propertiesXml));
            Node lastContributorNode = resourceNode.addNode("ametys:contributor", "ametys:user");
            lastContributorNode.setProperty("ametys:login", contributor.getLogin());
            lastContributorNode.setProperty("ametys:population", contributor.getPopulationId());
            UserIdentity creator = UserIdentity.stringToUserIdentity((String)Archivers.xpathEvalNonEmpty("resource/creator", propertiesXml));
            Node creatorNode = resourceNode.addNode("ametys:creator", "ametys:user");
            creatorNode.setProperty("ametys:login", creator.getLogin());
            creatorNode.setProperty("ametys:population", creator.getPopulationId());
            Date creationDate = Objects.requireNonNull(DomNodeHelper.nullableDatetimeValue(propertiesXml, "resource/creationDate"));
            GregorianCalendar creationDateCal = new GregorianCalendar();
            creationDateCal.setTime(creationDate);
            resourceNode.setProperty("ametys:creationDate", (Calendar)creationDateCal);
        }

        private void _setResourceMetadata(Node resourceNode, Path file) throws IOException {
            JCRResource dcObject = ResourcesArchiverHelper.this._jcrResourceFactory.getAmetysObject(resourceNode, null);
            this._setDublinCoreMetadata((ModifiableDublinCoreAwareAmetysObject)dcObject, file);
        }

        private void _setDublinCoreMetadata(ModifiableDublinCoreAwareAmetysObject dcObject, Path file) throws IOException {
            String zipEntryPath = "_metadata/" + StringUtils.strip((String)file.toString(), (String)"/") + "_" + ResourcesArchiverHelper.__DC_METADATA_XML_FILE_NAME_SUFFIX;
            try (InputStream stream = ZipEntryHelper.zipEntryFileInputStream(this._zipArchivePath, zipEntryPath);){
                Document doc = this._builder.parse(stream);
                this._setDublinCoreMetadata(dcObject, doc);
            }
            catch (TransformerException | SAXException e) {
                throw new IOException(e);
            }
        }

        private void _setDublinCoreMetadata(ModifiableDublinCoreAwareAmetysObject dcObject, Document doc) throws TransformerException {
            org.w3c.dom.Node dcNode = XPathAPI.selectSingleNode((org.w3c.dom.Node)doc, (String)ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_ROOT);
            dcObject.setDCTitle(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_TITLE));
            dcObject.setDCCreator(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_CREATOR));
            dcObject.setDCSubject(DomNodeHelper.stringValues(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_SUBJECT));
            dcObject.setDCDescription(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_DESCRIPTION));
            dcObject.setDCPublisher(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_PUBLISHER));
            dcObject.setDCContributor(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_CONTRIBUTOR));
            dcObject.setDCDate(DomNodeHelper.nullableDateValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_DATE));
            dcObject.setDCType(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_TYPE));
            dcObject.setDCFormat(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_FORMAT));
            dcObject.setDCIdentifier(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_IDENTIFIER));
            dcObject.setDCSource(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_SOURCE));
            dcObject.setDCLanguage(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_LANGUAGE));
            dcObject.setDCRelation(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_RELATION));
            dcObject.setDCCoverage(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_COVERAGE));
            dcObject.setDCRights(DomNodeHelper.nullableStringValue(dcNode, ResourcesArchiverHelper.__DC_METADATA_XML_EXPORT_TAG_NAME_RIGHTS));
        }

        private String _getMimeType(Path file) {
            return Optional.of(file).map(Path::getFileName).map(Path::toString).map(String::toLowerCase).map(arg_0 -> ((Context)ResourcesArchiverHelper.this._cocoonContext).getMimeType(arg_0)).orElse("application/unknown");
        }

        private final class UnitaryCollectionImporter
        implements UnitaryImporter<Node> {
            private UnitaryCollectionImporter() {
            }

            @Override
            public String objectNameForLogs() {
                return "Resource collection";
            }

            @Override
            public Document getPropertiesXml(Path zipEntryPath) throws Exception {
                return Importer.this._getFolderPropertiesXml(zipEntryPath);
            }

            @Override
            public String retrieveId(Document propertiesXml) throws Exception {
                return Archivers.xpathEvalNonEmpty("resource-collection/id", propertiesXml);
            }

            @Override
            public Node create(Path zipEntryPath, String id, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, Exception {
                Node node = Importer.this._createResourceCollection(zipEntryPath, id, propertiesXml);
                Archivers.unitarySave(node, Importer.this._logger);
                return node;
            }

            @Override
            public ImportReport getReport() {
                return Importer.this._report;
            }
        }

        private final class UnitaryResourceImporter
        implements UnitaryImporter<JCRResource> {
            private UnitaryResourceImporter() {
            }

            @Override
            public String objectNameForLogs() {
                return "Resource";
            }

            @Override
            public Document getPropertiesXml(Path zipEntryPath) throws Exception {
                return Importer.this._getFilePropertiesXml(zipEntryPath);
            }

            @Override
            public String retrieveId(Document propertiesXml) throws Exception {
                return Archivers.xpathEvalNonEmpty("resource/id", propertiesXml);
            }

            @Override
            public JCRResource create(Path zipEntryPath, String id, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, Exception {
                JCRResource createdResource = Importer.this._createdResource(zipEntryPath, id, propertiesXml);
                Archivers.unitarySave(createdResource.getNode(), Importer.this._logger);
                return createdResource;
            }

            @Override
            public ImportReport getReport() {
                return Importer.this._report;
            }
        }
    }
}

