/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.archive;

import java.util.stream.Stream;

/**
 * The manifest reader/writer, which is responsible to write into the Manifest file the exposed {@link PartialImport}s, 
 * and to read from a Manifest file those exposed {@link PartialImport}s.
 */
public interface ManifestReaderWriter
{
    /**
     * Gets the manifest content to write related to the exported data by the {@link Archiver}.
     * @return the manifest content to write
     */
    Object getData();
    
    /**
     * Reads the available partial imports from the given raw JSON data
     * @param data The raw JSON data
     * @return the available partial imports
     */
    Stream<PartialImport> toPartialImports(Object data);
}
