/*
 *  Copyright 2014 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.in;

/**
 * Exception indicating a content import error.
 */
public class ContentImportException extends Exception
{
    
    /**
     * Build a ContentImportException.
     * @param message the error detail message.
     */
    public ContentImportException(String message)
    {
        super(message);
    }
    
    /**
     * Build a ContentImportException.
     * @param message the error detail message.
     * @param cause the error cause. 
     */
    public ContentImportException(String message, Throwable cause)
    {
        super(message, cause);
    }
    
    /**
     * Build a ContentImportException.
     * @param cause the error cause.
     */
    public ContentImportException(Throwable cause)
    {
        super(cause);
    }
    
}
