/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize;

import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.quartz.JobExecutionContext;

import org.ametys.core.schedule.Schedulable;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.plugins.core.impl.schedule.AbstractStaticSchedulable;
import org.ametys.runtime.i18n.I18nizableText;

/**
 * A {@link Schedulable} job which synchronizes all collections of contents from a datasource.
 */
public class SynchronizeAllCollectionsSchedulable extends AbstractStaticSchedulable
{
    private SynchronizableContentsCollectionDAO _synchronizableContentsCollectionDAO;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _synchronizableContentsCollectionDAO = (SynchronizableContentsCollectionDAO) manager.lookup(SynchronizableContentsCollectionDAO.ROLE);
    }
    
    @Override
    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception
    {
        List<SynchronizableContentsCollection> collections = _synchronizableContentsCollectionDAO.getSynchronizableContentsCollections();
        
        for (SynchronizableContentsCollection collection : collections)
        {
            progressionTracker.addContainerStep(collection.getId(), new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_SCHEDULER_SYNCHRONIZE_COLLECTION_STEP_LABEL", Map.of("collectionLabel", collection.getLabel())));
        }
        
        for (SynchronizableContentsCollection collection : collections)
        {
            collection.populate(getLogger(), progressionTracker.getStep(collection.getId()));
        }
    }
}
