/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

public final class ContentImporterHelper {
    private ContentImporterHelper() {
    }

    public static String textToDocbook(String[] lines) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<article version=\"5.0\" xmlns=\"http://docbook.org/ns/docbook\">");
        for (String line : lines) {
            sb.append("<para>");
            sb.append(line.replaceAll("<", "&lt;").replaceAll("&", "&amp;").replaceAll("\r?\n", "<phrase role=\"linebreak\"/>"));
            sb.append("</para>");
        }
        sb.append("</article>");
        return sb.toString();
    }

    public static String serializeNode(Node node) throws TransformerException {
        return ContentImporterHelper.serializeNode(node, false, false);
    }

    public static String serializeNode(Node node, boolean indent) throws TransformerException {
        return ContentImporterHelper.serializeNode(node, indent, false);
    }

    public static String serializeNode(Node node, boolean indent, boolean omitXmlDeclaration) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("omit-xml-declaration", omitXmlDeclaration ? "yes" : "no");
        format.put("indent", indent ? "yes" : "no");
        format.put("encoding", "UTF-8");
        transformer.setOutputProperties(format);
        StringWriter writer = new StringWriter();
        DOMSource domSource = new DOMSource(node);
        StreamResult result = new StreamResult(writer);
        transformer.transform(domSource, result);
        return writer.toString();
    }
}

