/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.ametys.plugins.contentio.archive.Archiver;
import org.ametys.plugins.contentio.archive.ArchiverExtensionPoint;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.ManifestReaderWriter;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.PartialImport;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ArchiveHandler
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = ArchiveHandler.class.getName();
    public static final String METADATA_PREFIX = "_metadata/";
    static final String MANIFEST_FILENAME = "manifest.json";
    private static final Gson __GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected Context _context;
    private ArchiverExtensionPoint _archiverEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._archiverEP = (ArchiverExtensionPoint)((Object)manager.lookup(ArchiverExtensionPoint.ROLE));
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public Path getArchiveFolder() {
        Path allArchives = AmetysHomeHelper.getAmetysHomeData().toPath().resolve("archives");
        allArchives.toFile().mkdirs();
        return allArchives;
    }

    public Stream<String> getArchiveFiles() {
        Path archiveFolder = this.getArchiveFolder();
        return FileUtils.listFiles((File)archiveFolder.toFile(), (String[])new String[]{"zip"}, (boolean)false).stream().map(File::getName);
    }

    public File getArchiveFile(String name) {
        if (!FilenameUtils.isExtension((String)name, (String)"zip")) {
            throw new IllegalArgumentException(String.format("Wrong archive name '%s', it should be a ZIP file", name));
        }
        Path archiveFolder = this.getArchiveFolder();
        File archive = archiveFolder.resolve(name).toFile();
        if (archive.exists()) {
            return archive;
        }
        throw new IllegalArgumentException(String.format("Archive file '%s' does not exist", archive));
    }

    public Stream<PartialImport> getPartialImports(String archiveName) throws IOException {
        Objects.requireNonNull(archiveName, "The archive name cannot be null");
        Path archiveFolder = this.getArchiveFolder();
        Path archive = archiveFolder.resolve(archiveName);
        return this._partialImports(archive);
    }

    private Stream<PartialImport> _partialImports(Path archive) throws IOException {
        Stream<PartialImport> stream;
        block8: {
            InputStream manifestIs = ZipEntryHelper.zipEntryFileInputStream(archive, MANIFEST_FILENAME);
            try {
                String manifestContent = IOUtils.toString((InputStream)manifestIs, (Charset)StandardCharsets.UTF_8);
                Type mapType = new TypeToken<Map<String, Object>>(this){}.getType();
                Map manifestJson = (Map)__GSON.fromJson(manifestContent, mapType);
                stream = this._partialImportsFromJson(manifestJson);
                if (manifestIs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (manifestIs != null) {
                        try {
                            manifestIs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | JsonSyntaxException e) {
                    throw new IOException(String.format("An error occured with the manifest file '%s' of archive '%s'.\nThe cause is: %s", MANIFEST_FILENAME, archive, e.getMessage()));
                }
            }
            manifestIs.close();
        }
        return stream;
    }

    private Stream<PartialImport> _partialImportsFromJson(Map<String, Object> manifestJson) {
        return this._archiverEP.getExtensionsIds().stream().filter(manifestJson::containsKey).map(archiverId -> this._partialImportsFromJsonAndArchiver(manifestJson, (String)archiverId)).flatMap(Function.identity());
    }

    private Stream<PartialImport> _partialImportsFromJsonAndArchiver(Map<String, Object> manifestJson, String archiverId) {
        Archiver archiver = (Archiver)this._archiverEP.getExtension(archiverId);
        ManifestReaderWriter manifestReaderWriter = archiver.getManifestReaderWriter();
        Object jsonData = manifestJson.get(archiverId);
        return manifestReaderWriter.toPartialImports(jsonData);
    }

    public void export(File output) throws IOException {
        try (FileOutputStream fileOs = new FileOutputStream(output);
             BufferedOutputStream bufferedOs = new BufferedOutputStream(fileOs);
             ZipOutputStream zos = new ZipOutputStream((OutputStream)bufferedOs, StandardCharsets.UTF_8);){
            this._exportManifest(zos);
            this._exportActualData(zos);
        }
    }

    private void _exportManifest(ZipOutputStream zos) throws IOException {
        LinkedHashMap<String, Object> manifestData = new LinkedHashMap<String, Object>();
        for (String id : this._archiverEP.getExtensionsIds()) {
            Archiver archiver = (Archiver)this._archiverEP.getExtension(id);
            ManifestReaderWriter manifestReaderWriter = archiver.getManifestReaderWriter();
            Object archiverManifestData = manifestReaderWriter.getData();
            manifestData.put(id, archiverManifestData);
        }
        String json = __GSON.toJson(manifestData);
        ZipEntry manifestEntry = new ZipEntry(MANIFEST_FILENAME);
        zos.putNextEntry(manifestEntry);
        IOUtils.write((String)json, (OutputStream)zos, (Charset)StandardCharsets.UTF_8);
    }

    private void _exportActualData(ZipOutputStream zos) throws IOException {
        for (String id : this._archiverEP.getExtensionsIds()) {
            Archiver archiver = (Archiver)this._archiverEP.getExtension(id);
            this.getLogger().info("Processing archiver {} ({}) for export", (Object)id, (Object)archiver.getClass().getName());
            archiver.export(zos);
        }
    }

    private ImportReport _partialImport(String archiverId, Path zipPath, Collection<String> partialImports, Merger merger) throws IOException {
        Archiver archiver = (Archiver)this._archiverEP.getExtension(archiverId);
        Collection<String> managedPartialImports = archiver.managedPartialImports(partialImports);
        if (managedPartialImports.isEmpty()) {
            this.getLogger().info("Archiver '{}' ({}) not processed, given partial imports ({}) do not match", new Object[]{archiverId, archiver.getClass().getName(), partialImports});
            return new ImportReport();
        }
        this.getLogger().info("Processing archiver '{}' ({}) for import, with matching partial imports {}", new Object[]{archiverId, archiver.getClass().getName(), managedPartialImports});
        return archiver.partialImport(zipPath, managedPartialImports, merger, merger.deleteBeforePartialImport());
    }

    public ImportReport importAll(File input, Merger merger) throws IOException {
        Path zipPath = input.toPath();
        Collection allPartialImports = this._partialImports(zipPath).map(PartialImport::getKey).collect(Collectors.toList());
        return this.partialImport(input, allPartialImports, merger);
    }

    public ImportReport partialImport(File input, Collection<String> partialImports, Merger merger) throws IOException {
        ArrayList<ImportReport> reports = new ArrayList<ImportReport>();
        Path zipPath = input.toPath();
        for (String id : this._archiverEP.getExtensionsIds()) {
            ImportReport partialImportResult = this._partialImport(id, zipPath, partialImports, merger);
            reports.add(partialImportResult);
        }
        return ImportReport.union(reports);
    }
}

