/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.core.schedule.progression.ContainerProgressionTracker;
import org.ametys.core.user.User;
import org.ametys.plugins.contentio.archive.AbstractArchiveSchedulable;
import org.ametys.plugins.contentio.archive.Archiver;
import org.ametys.plugins.contentio.archive.ArchiverExtensionPoint;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.MergePolicy;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ImportArchiveSchedulable
extends AbstractArchiveSchedulable {
    public static final String ID = ImportArchiveSchedulable.class.getName();
    static final String ARCHIVE_KEY = "archive";
    static final String ELEMENTS_KEY = "elements";
    static final String MERGE_POLICY_KEY = "mergePolicy";
    private static final String __JOBDATAMAP_ARCHIVE_KEY = "parameterValues#archive";
    private static final String __JOBDATAMAP_ELEMENTS_KEY = "parameterValues#elements";
    private static final String __JOBDATAMAP_MERGE_POLICY_KEY = "parameterValues#mergePolicy";
    private static final String __ERROR_TEMPLATE = "<li><pre>%s \n %s</pre></li>";
    private ArchiverExtensionPoint _archiverEP;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._archiverEP = (ArchiverExtensionPoint)((Object)manager.lookup(ArchiverExtensionPoint.ROLE));
    }

    public void execute(JobExecutionContext context, ContainerProgressionTracker progressionTracker) throws Exception {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String archiveName = jobDataMap.getString(__JOBDATAMAP_ARCHIVE_KEY);
        Optional<Collection<String>> elements = Optional.of(__JOBDATAMAP_ELEMENTS_KEY).map(arg_0 -> ((JobDataMap)jobDataMap).get(arg_0)).filter(Collection.class::isInstance).map(Collection.class::cast);
        MergePolicy mergePolicy = (MergePolicy)((Object)jobDataMap.get((Object)__JOBDATAMAP_MERGE_POLICY_KEY));
        Merger merger = mergePolicy.getMerger();
        User user = this._getUser();
        String userEmail = null;
        String language = this._userLanguagesManager.getDefaultLanguage();
        if (user != null) {
            userEmail = user.getEmail();
            String userLanguage = user.getLanguage();
            language = (String)StringUtils.defaultIfBlank((CharSequence)userLanguage, (CharSequence)language);
        }
        File input = this._getFileInput(archiveName);
        this.getLogger().info("Importing archive {} ...", (Object)input.getAbsolutePath());
        long t0 = System.currentTimeMillis();
        boolean success = true;
        try {
            ImportReport importReport = this._import(input, elements, merger);
            this.getLogger().info("Archive {} imported without error in {} ms", (Object)input.getAbsolutePath(), (Object)(System.currentTimeMillis() - t0));
            String subject = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_MAIL_SUBJECT"), language);
            String body = this.getSuccessMailBody(input, elements, importReport, language);
            this._sendMail(subject, body, userEmail);
            success = importReport.getErrors().isEmpty();
        }
        catch (Exception e) {
            String subject = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_MAILERROR_SUBJECT"), language);
            String body = this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_MAILERROR_BODY"), language);
            this._sendMail(subject, body, userEmail);
            throw e;
        }
        if (!success) {
            throw new JobExecutionException("Errors occured during the import. See previous logs for more info.");
        }
    }

    private ImportReport _import(File input, Optional<Collection<String>> elements, Merger merger) throws IOException {
        if (elements.isPresent()) {
            return this._archiveHandler.partialImport(input, elements.get(), merger);
        }
        return this._archiveHandler.importAll(input, merger);
    }

    private File _getFileInput(String archiveName) {
        return this._archiveHandler.getArchiveFile(archiveName);
    }

    protected String getSuccessMailBody(File input, Optional<Collection<String>> elements, ImportReport importReport, String language) throws IOException {
        String catalogue = "plugin.contentio";
        HashMap<String, I18nizableText> i18nParameters = new HashMap<String, I18nizableText>();
        String inputPath = input.getCanonicalPath();
        i18nParameters.put("archivePath", new I18nizableText(inputPath));
        i18nParameters.put("archiveName", new I18nizableText(input.getName()));
        Collection<ImportReport.ImportError> errors = importReport.getErrors();
        StringBuilder body = new StringBuilder();
        if (errors.isEmpty()) {
            body.append(this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_MAIL_SUCCESS_BODY_INTRO", i18nParameters), language));
        } else if (errors.size() == 1) {
            body.append(this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_MAIL_SUCCESS_BODY_INTRO_WITH_ERROR", i18nParameters), language));
        } else {
            i18nParameters.put("nbErrors", new I18nizableText(String.valueOf(errors.size())));
            body.append(this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_MAIL_SUCCESS_BODY_INTRO_WITH_ERRORS", i18nParameters), language));
        }
        body.append("\n<br/><br/>").append(this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_MAIL_SUCCESS_BODY_END"), language));
        Predicate<Archiver> filterArchiver = elements.isPresent() ? archiver -> !archiver.managedPartialImports((Collection)elements.get()).isEmpty() : archiver -> true;
        String additionalBody = this._archiverEP.getExtensionsIds().stream().map(arg_0 -> ((ArchiverExtensionPoint)this._archiverEP).getExtension(arg_0)).filter(filterArchiver).map(Archiver::additionalSuccessImportMail).flatMap(Collection::stream).distinct().map(adB -> this._i18nUtils.translate((I18nizable)adB, language)).collect(Collectors.joining("<br/>"));
        if (!additionalBody.isBlank()) {
            body.append("<br/>").append(additionalBody);
        }
        if (!errors.isEmpty()) {
            String errorItems = errors.stream().map(importError -> String.format(__ERROR_TEMPLATE, importError.getMessage(), importError.getStackTrace())).collect(Collectors.joining("\n"));
            body.append("\n<br/><br/>").append("\n" + this._i18nUtils.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_SCHEDULABLE_MAIL_BODY_LIST_OF_ERRORS"), language)).append("\n<br/>").append("\n<ul>\n").append(errorItems).append("\n</ul>");
        }
        return body.toString();
    }
}

