/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.core.util.LambdaUtils;
import org.ametys.plugins.contentio.archive.Archiver;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.ManifestReaderWriter;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.PartialImport;
import org.ametys.plugins.contentio.archive.PluginArchiver;
import org.ametys.plugins.contentio.archive.PluginArchiverExtensionPoint;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.Plugin;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class PluginsArchiver
extends AbstractLogEnabled
implements Archiver,
Serviceable {
    public static final String ID = "plugins";
    private static final String __PARTIAL_IMPORT_PREFIX = "plugins/";
    private Repository _repository;
    private PluginArchiverExtensionPoint _pluginArchiverExtPoint;
    private ManifestReaderWriter _manifestReaderWriter = new PluginsArchiverManifestReaderWriter(this.getLogger());

    public void service(ServiceManager manager) throws ServiceException {
        this._repository = (Repository)manager.lookup("javax.jcr.Repository");
        this._pluginArchiverExtPoint = (PluginArchiverExtensionPoint)((Object)manager.lookup(PluginArchiverExtensionPoint.ROLE));
    }

    @Override
    public ManifestReaderWriter getManifestReaderWriter() {
        return this._manifestReaderWriter;
    }

    private Map<String, String> _getManifestData() {
        Session session = null;
        Map pluginDefinitions = PluginsManager.getInstance().getAllPlugins();
        HashMap<String, String> pluginVersions = new HashMap<String, String>();
        try {
            session = this._repository.login();
            Iterator<Node> it = PluginsArchiver._getPluginNodes(session);
            while (it.hasNext()) {
                Node pluginNode = it.next();
                String pluginName = pluginNode.getName();
                Plugin pluginDef = (Plugin)pluginDefinitions.get(pluginName);
                if (pluginDef != null) {
                    String version = pluginDef.getVersion();
                    pluginVersions.put(pluginName, version != null ? version : "");
                    continue;
                }
                pluginVersions.put(pluginName, "");
            }
            HashMap<String, String> hashMap = pluginVersions;
            return hashMap;
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Unable to get plugin list", e);
        }
        finally {
            PluginsArchiver._closeSession(session);
        }
    }

    private static Node _getAllPluginsNode(Session session) throws RepositoryException {
        return session.getRootNode().getNode("ametys:root/ametys:plugins");
    }

    private static Iterator<Node> _getPluginNodes(Session session) throws RepositoryException {
        return PluginsArchiver._getAllPluginsNode(session).getNodes();
    }

    private static void _closeSession(Session session) {
        if (session != null) {
            session.logout();
        }
    }

    @Override
    public void export(ZipOutputStream zos) throws IOException {
        Session session = null;
        try {
            session = this._repository.login();
            PluginsArchiver._getPluginNodes(session).forEachRemaining(LambdaUtils.wrapConsumer(pluginNode -> this._exportPlugin((Node)pluginNode, zos)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to archive plugins", e);
        }
        finally {
            PluginsArchiver._closeSession(session);
        }
    }

    private PluginArchiver _retrievePluginArchiver(String pluginName) {
        PluginArchiver pluginArchiver = (PluginArchiver)this._pluginArchiverExtPoint.getExtension(pluginName);
        if (pluginArchiver == null && (pluginArchiver = (PluginArchiver)this._pluginArchiverExtPoint.getExtension("__default")) == null) {
            throw new IllegalStateException("There should be a '__default' extension to PluginArchiverExtensionPoint. Please check your excluded features.");
        }
        return pluginArchiver;
    }

    private void _exportPlugin(Node pluginNode, ZipOutputStream zos) throws Exception {
        String pluginName = pluginNode.getName();
        PluginArchiver pluginArchiver = this._retrievePluginArchiver(pluginName);
        this.getLogger().info("Processing plugin '{}' for archiving at {} with archiver '{}'", new Object[]{pluginName, pluginNode, pluginArchiver.getClass().getName()});
        pluginArchiver.export(pluginName, pluginNode, zos, __PARTIAL_IMPORT_PREFIX + pluginName);
    }

    @Override
    public Collection<String> managedPartialImports(Collection<String> partialImports) {
        return partialImports.stream().filter(partialImport -> partialImport.startsWith(__PARTIAL_IMPORT_PREFIX)).collect(Collectors.toList());
    }

    @Override
    public ImportReport partialImport(Path zipPath, Collection<String> partialImports, Merger merger, boolean deleteBefore) throws IOException {
        ArrayList<ImportReport> reports = new ArrayList<ImportReport>();
        Session session = null;
        try {
            session = this._repository.login();
            Node pluginsNode = PluginsArchiver._getAllPluginsNode(session);
            for (String partialImport : partialImports) {
                ImportReport pluginImportResult = this._importPlugin(partialImport, zipPath, merger, pluginsNode, deleteBefore);
                reports.add(pluginImportResult);
            }
            ImportReport importReport = ImportReport.union(reports);
            return importReport;
        }
        catch (RepositoryException e) {
            throw new IllegalArgumentException("Unable to import plugins", e);
        }
        finally {
            PluginsArchiver._closeSession(session);
        }
    }

    private ImportReport _importPlugin(String partialImport, Path zipPath, Merger merger, Node allPluginsNode, boolean deleteBefore) throws IOException, RepositoryException {
        String pluginName = StringUtils.substringAfter((String)partialImport, (String)__PARTIAL_IMPORT_PREFIX);
        PluginArchiver pluginArchiver = this._retrievePluginArchiver(pluginName);
        this.getLogger().info("Importing plugin '{}' from archive with archiver '{}'", (Object)pluginName, (Object)pluginArchiver.getClass().getName());
        if (deleteBefore) {
            pluginArchiver.deleteBeforePartialImport(pluginName, allPluginsNode);
        }
        String zipPluginEntryPath = __PARTIAL_IMPORT_PREFIX + pluginName;
        return pluginArchiver.partialImport(pluginName, allPluginsNode, zipPath, zipPluginEntryPath, merger);
    }

    private final class PluginsArchiverManifestReaderWriter
    implements ManifestReaderWriter {
        private Logger _logger;

        public PluginsArchiverManifestReaderWriter(Logger logger) {
            this._logger = logger;
        }

        @Override
        public Object getData() {
            return PluginsArchiver.this._getManifestData();
        }

        @Override
        public Stream<PartialImport> toPartialImports(Object data) {
            return Optional.ofNullable(data).filter(Map.class::isInstance).map(this::_castToMap).map(Map::entrySet).orElseGet(() -> {
                this._logger.warn("Unexpected manifest data '{}', we would expect a JSON object with key-value mappings representing the plugin names and their version. The ZIP archive probably comes from a different version of Ametys.", data);
                return Collections.emptySet();
            }).stream().map(this::_toPartialImport).sorted(Comparator.comparing(PartialImport::getKey));
        }

        private Map<String, String> _castToMap(Object data) {
            return (Map)Map.class.cast(data);
        }

        private PartialImport _toPartialImport(Map.Entry<String, String> entry) {
            String pluginName = entry.getKey();
            String optionalVersion = entry.getValue();
            String key = PluginsArchiver.__PARTIAL_IMPORT_PREFIX + pluginName;
            return PartialImport.of(key, this._toPartialImportLabel(pluginName, optionalVersion));
        }

        private I18nizableText _toPartialImportLabel(String pluginName, String optionalVersion) {
            Object optionalVersionLabel = optionalVersion.isEmpty() ? "" : " (" + optionalVersion + ")";
            Map<String, I18nizableText> parameters = Map.of("pluginName", new I18nizableText(pluginName), "optionalVersion", new I18nizableText((String)optionalVersionLabel));
            return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_ARCHIVE_IMPORT_PLUGIN_ARCHIVER_OPTION_ONE_PLUGIN", parameters);
        }
    }
}

