/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.repository.data.extractor.xml.XMLValuesExtractorAdditionalDataGetter;
import org.ametys.runtime.model.type.ElementType;

public class ResourcesAdditionalDataGetter
implements XMLValuesExtractorAdditionalDataGetter {
    private final Path _archivePath;
    private final Path _path;

    public ResourcesAdditionalDataGetter(Path archivePath, Path path) {
        this._archivePath = archivePath;
        this._path = path;
    }

    public Optional<Object> getAdditionalData(String dataPath, ElementType type) {
        try {
            return this._getExtractorAdditionalData(dataPath, type);
        }
        catch (Exception e) {
            throw new RuntimeException("An unexpected error occured", e);
        }
    }

    private Optional<Object> _getExtractorAdditionalData(String dataPath, ElementType type) throws Exception {
        switch (type.getId()) {
            case "file": {
                return Optional.of(this._getFileAdditionalData("_fileAttributes", dataPath));
            }
            case "binary": {
                return Optional.of(this._getFileAdditionalData("_binaryAttributes", dataPath));
            }
            case "rich-text": {
                return Optional.of(this._getFileAdditionalData("_richTextAttachments", dataPath));
            }
        }
        return Optional.empty();
    }

    private Map<String, InputStream> _getFileAdditionalData(String folderName, String dataPath) throws IOException {
        Path zipEntryFileParentFolderPath = this._path.resolve(folderName).resolve(Archivers.getFolderPathFromDataPath(dataPath));
        String folderPath = zipEntryFileParentFolderPath.toString();
        if (ZipEntryHelper.zipEntryFolderExists(this._archivePath, folderPath)) {
            return this._getFileNameAndInputStream(folderPath);
        }
        return Map.of();
    }

    private Map<String, InputStream> _getFileNameAndInputStream(String folderPath) throws IOException {
        DirectoryStream<Path> fileChildren;
        try (DirectoryStream<Path> directoryStream = fileChildren = ZipEntryHelper.children(this._archivePath, Optional.of(folderPath), p -> !Files.isDirectory(p, new LinkOption[0]));){
            HashMap<String, InputStream> files = new HashMap<String, InputStream>();
            for (Path file : fileChildren) {
                String fileName = file.getFileName().toString();
                InputStream is = ZipEntryHelper.zipEntryFileInputStream(this._archivePath, file.toString());
                files.put(fileName, is);
            }
            HashMap<String, InputStream> hashMap = files;
            return hashMap;
        }
    }
}

