/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.csv;

import jakarta.mail.MessagingException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ametys.cms.contenttype.ContentAttributeDefinition;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.contenttype.ContentTypesHelper;
import org.ametys.cms.repository.Content;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.User;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.UserManager;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.UserLanguagesManager;
import org.ametys.core.util.mail.SendMailHelper;
import org.ametys.plugins.contentio.csv.CSVImporter;
import org.ametys.plugins.contentio.csv.SynchronizeModeEnumerator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Model;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemGroup;
import org.ametys.runtime.model.ModelViewItemGroup;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewElement;
import org.ametys.runtime.model.ViewElementAccessor;
import org.ametys.runtime.model.ViewItem;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.servlet.RuntimeConfig;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.detect.DefaultEncodingDetector;
import org.apache.tika.metadata.Metadata;
import org.supercsv.io.CsvListReader;
import org.supercsv.io.ICsvListReader;
import org.supercsv.prefs.CsvPreference;

public class ImportCSVFileHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = ImportCSVFileHelper.class.getName();
    public static final String CONFIG_PARENT_ID = "parentId";
    public static final String RESULT_IMPORTED_COUNT = "importedCount";
    public static final String RESULT_NB_ERRORS = "nbErrors";
    public static final String RESULT_NB_WARNINGS = "nbWarnings";
    public static final String RESULT_ERROR = "error";
    public static final String RESULT_FILENAME = "fileName";
    public static final String MAPPING_COLUMN_ATTRIBUTE_PATH = "attributePath";
    public static final String MAPPING_COLUMN_HEADER = "header";
    public static final String MAPPING_COLUMN_IS_ID = "isId";
    public static final String NESTED_MAPPING_ID = "id";
    public static final String NESTED_MAPPING_VALUES = "values";
    protected AmetysObjectResolver _resolver;
    protected CSVImporter _csvImporter;
    protected ContentTypeExtensionPoint _contentTypeEP;
    private CurrentUserProvider _currentUserProvider;
    private UserManager _userManager;
    private UserLanguagesManager _userLanguagesManager;
    private ContentTypesHelper _contentTypesHelper;
    private I18nUtils _i18nUtils;
    private String _sysadminMail;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._userManager = (UserManager)serviceManager.lookup(UserManager.ROLE);
        this._userLanguagesManager = (UserLanguagesManager)serviceManager.lookup(UserLanguagesManager.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)serviceManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._contentTypesHelper = (ContentTypesHelper)serviceManager.lookup(ContentTypesHelper.ROLE);
        this._resolver = (AmetysObjectResolver)serviceManager.lookup(AmetysObjectResolver.ROLE);
        this._i18nUtils = (I18nUtils)serviceManager.lookup(I18nUtils.ROLE);
        this._csvImporter = (CSVImporter)((Object)serviceManager.lookup(CSVImporter.ROLE));
    }

    public void initialize() throws Exception {
        this._sysadminMail = (String)Config.getInstance().getValue("smtp.mail.sysadminto");
    }

    @Callable(rights={"*"})
    public Map<String, Object> getImportCSVParametersValues(String contentTypeId) throws Exception {
        HashMap<String, Object> values = new HashMap<String, Object>();
        List<Object> contentTypeIds = StringUtils.isEmpty((CharSequence)contentTypeId) ? List.of() : List.of(contentTypeId);
        Map filteredContentTypes = this._contentTypesHelper.getContentTypesList(contentTypeIds, true, true, true, false, false);
        values.put("availableContentTypes", filteredContentTypes.get("contentTypes"));
        String currentUserEmail = null;
        UserIdentity currentUser = this._currentUserProvider.getUser();
        String login = currentUser.getLogin();
        if (StringUtils.isNotBlank((CharSequence)login)) {
            String userPopulationId = currentUser.getPopulationId();
            User user = this._userManager.getUser(userPopulationId, login);
            currentUserEmail = user.getEmail();
        }
        values.put("defaultRecipient", currentUserEmail);
        return values;
    }

    @Callable(rights={"*"})
    public Map<String, Object> validateConfiguration(String contentTypeId, Map formValues, List<Map<String, Object>> mappingValues) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Map<String, Object>> filteredMappingValues = this._filterMapping(mappingValues);
        List<String> contentAttributes = filteredMappingValues.stream().map(column -> column.get(MAPPING_COLUMN_ATTRIBUTE_PATH)).map(String.class::cast).collect(Collectors.toList());
        HashMap mapping = new HashMap();
        filteredMappingValues.forEach(column -> ImportCSVFileHelper.generateNestedMapping(mapping, column));
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        result.put("contentTypeName", contentType.getLabel());
        View view = null;
        for (String itemPath : contentAttributes) {
            if (ModelHelper.hasModelItem((String)itemPath, List.of(contentType))) continue;
            result.put(RESULT_ERROR, "bad-mapping");
            result.put("details", List.of(itemPath, contentTypeId));
            return result;
        }
        try {
            view = View.of((Model)contentType, (String[])contentAttributes.toArray(new String[contentAttributes.size()]));
        }
        catch (IllegalArgumentException | BadItemTypeException e) {
            this.getLogger().error("Error while creating view", e);
            result.put(RESULT_ERROR, "cant-create-view");
            result.put("details", contentTypeId);
            return result;
        }
        if (!mapping.containsKey(NESTED_MAPPING_ID)) {
            result.put(RESULT_ERROR, "missing-id");
            return result;
        }
        for (ViewItem viewItem : view.getViewItems()) {
            if (this._checkViewItemContainer(viewItem, (Map)mapping.get(NESTED_MAPPING_VALUES), result)) continue;
            return result;
        }
        result.put("success", true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"Plugins_ContentIO_ImportFile"}, context="/cms")
    public Map<String, Object> importContents(Map<String, Object> config, Map<String, Object> formValues, List<Map<String, Object>> mappingValues) throws IOException {
        Content parent;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(RESULT_FILENAME, config.get(RESULT_FILENAME));
        String importId = (String)config.get("importId");
        File importFile = this._getTempFile(importId);
        String contentTypeId = (String)config.get("contentType");
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        CsvPreference csvPreference = new CsvPreference.Builder(config.getOrDefault("escaping-char", Character.valueOf('\"')).toString().charAt(0), (int)config.getOrDefault("separating-char", Character.valueOf(';')).toString().charAt(0), "\r\n").build();
        String encoding = (String)config.get("charset");
        Charset charset = Charset.forName(encoding);
        String language = (String)formValues.get("language");
        int createAction = Integer.valueOf((String)formValues.getOrDefault("createAction", "1"));
        int editAction = Integer.valueOf((String)formValues.getOrDefault("editAction", "2"));
        String workflowName = (String)formValues.get("workflow");
        SynchronizeModeEnumerator.ImportMode importMode = Optional.ofNullable((String)formValues.get("importMode")).filter(StringUtils::isNotEmpty).map(SynchronizeModeEnumerator.ImportMode::valueOf).orElse(SynchronizeModeEnumerator.ImportMode.CREATE_AND_UPDATE);
        Optional<String> recipient = Optional.ofNullable(config.get("recipient")).filter(String.class::isInstance).map(String.class::cast).filter(StringUtils::isNotBlank);
        Optional<Object> parentContent = Optional.empty();
        String parentId = (String)config.get(CONFIG_PARENT_ID);
        if (parentId != null && (parent = (Content)this._resolver.resolveById(parentId)) != null) {
            parentContent = Optional.of(parent);
        }
        Map additionalTransientVars = config.getOrDefault("additionalTransientVars", new HashMap());
        List<Map<String, Object>> filteredMappingValues = this._filterMapping(mappingValues);
        try (FileInputStream fileInputStream = new FileInputStream(importFile);
             BufferedInputStream inputStream = IOUtils.buffer((InputStream)fileInputStream);){
            result.putAll(this._importContents(inputStream, csvPreference, charset, contentType, workflowName, language, createAction, editAction, filteredMappingValues, importMode, parentContent, additionalTransientVars));
            if (RESULT_ERROR.equals(result.get(RESULT_ERROR)) && recipient.isEmpty()) {
                recipient = Optional.ofNullable(this._sysadminMail).filter(StringUtils::isNotBlank);
            }
            if (recipient.isPresent()) {
                this._sendMail(result, recipient.get());
            }
        }
        finally {
            FileUtils.deleteQuietly((File)importFile);
        }
        return result;
    }

    public Map<String, Object> importContents(InputStream inputStream, ContentType contentType, String language, SynchronizeModeEnumerator.ImportMode importMode) throws IOException {
        CsvPreference csvPreference = CsvPreference.EXCEL_NORTH_EUROPE_PREFERENCE;
        Charset charset = this.detectCharset(inputStream);
        inputStream.mark(8192);
        try (ByteArrayInputStream headerStream = new ByteArrayInputStream(inputStream.readNBytes(8192));){
            inputStream.reset();
            String[] headers = this.extractHeaders(headerStream, csvPreference, charset);
            List<Map<String, Object>> mappingValues = this.getMapping(contentType, headers);
            String workflowName = (String)contentType.getDefaultWorkflowName().orElseThrow(() -> new IllegalArgumentException("The workflow can't be defined."));
            Map<String, Object> map = this._importContents(inputStream, csvPreference, charset, contentType, workflowName, language, 1, 2, mappingValues, importMode);
            return map;
        }
    }

    private Map<String, Object> _importContents(InputStream inputStream, CsvPreference csvPreference, Charset charset, ContentType contentType, String workflowName, String language, int createAction, int editAction, List<Map<String, Object>> mappingValues, SynchronizeModeEnumerator.ImportMode importMode) {
        return this._importContents(inputStream, csvPreference, charset, contentType, workflowName, language, createAction, editAction, mappingValues, importMode, Optional.empty(), Map.of());
    }

    private Map<String, Object> _importContents(InputStream inputStream, CsvPreference csvPreference, Charset charset, ContentType contentType, String workflowName, String language, int createAction, int editAction, List<Map<String, Object>> mappingValues, SynchronizeModeEnumerator.ImportMode importMode, Optional<? extends Content> parentContent, Map<String, Object> additionalTransientVars) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> contentAttributes = mappingValues.stream().map(column -> column.get(MAPPING_COLUMN_ATTRIBUTE_PATH)).map(String.class::cast).collect(Collectors.toList());
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        mappingValues.forEach(column -> ImportCSVFileHelper.generateNestedMapping(mapping, column));
        View view = View.of((Model)contentType, (String[])contentAttributes.toArray(new String[contentAttributes.size()]));
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
             BufferedReader reader = new BufferedReader(inputStreamReader);
             CsvListReader csvMapReadernew = new CsvListReader((Reader)reader, csvPreference);){
            Map<String, Object> importResult = this._csvImporter.importContentsFromCSV(mapping, view, contentType, (ICsvListReader)csvMapReadernew, createAction, editAction, workflowName, language, importMode, parentContent, additionalTransientVars);
            List contentIds = (List)importResult.get("contentIds");
            if (contentIds.size() == 0 && (Integer)importResult.get(RESULT_NB_ERRORS) > 0) {
                result.put(RESULT_ERROR, "no-import");
            } else {
                result.put(RESULT_IMPORTED_COUNT, contentIds.size());
                result.put(RESULT_NB_ERRORS, importResult.get(RESULT_NB_ERRORS));
                result.put(RESULT_NB_WARNINGS, importResult.get(RESULT_NB_WARNINGS));
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error while importing contents", (Throwable)e);
            result.put(RESULT_ERROR, RESULT_ERROR);
        }
        return result;
    }

    private boolean _checkViewItemContainer(ViewItem viewItem, Map<String, Object> mapping, Map<String, Object> result) {
        if (viewItem instanceof ViewElement) {
            ViewElement viewElement = (ViewElement)viewItem;
            ElementDefinition elementDefinition = viewElement.getDefinition();
            if (elementDefinition instanceof ContentAttributeDefinition) {
                ViewElementAccessor viewElementAccessor = (ViewElementAccessor)viewElement;
                ContentAttributeDefinition contentAttributeDefinition = (ContentAttributeDefinition)elementDefinition;
                return this._checkViewItemContentContainer(viewElementAccessor, mapping, result, contentAttributeDefinition);
            }
            return true;
        }
        if (viewItem instanceof ModelViewItemGroup) {
            return this._checkViewItemGroupContainer(viewItem, mapping, result);
        }
        result.put(RESULT_ERROR, "unknown-type");
        result.put("details", viewItem.getName());
        return false;
    }

    private boolean _checkViewItemContentContainer(ViewElementAccessor viewElementAccessor, Map<String, Object> mapping, Map<String, Object> result, ContentAttributeDefinition contentAttributeDefinition) {
        Optional<RepeaterDefinition> repeater;
        boolean success = true;
        String contentTypeId = contentAttributeDefinition.getContentTypeId();
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        if (mapping.get(viewElementAccessor.getName()) instanceof String) {
            result.put(RESULT_ERROR, "string-as-container");
            result.put("details", mapping.get(viewElementAccessor.getName()));
            return false;
        }
        Map nestedMap = (Map)mapping.get(viewElementAccessor.getName());
        if (!nestedMap.containsKey(NESTED_MAPPING_ID) || ((List)nestedMap.get(NESTED_MAPPING_ID)).isEmpty()) {
            result.put(RESULT_ERROR, "missing-id-content");
            result.put("details", List.of(contentType.getLabel(), contentAttributeDefinition.getName()));
            return false;
        }
        if (viewElementAccessor.getDefinition().isMultiple() && (repeater = this._getRepeaterAncestorIfExists((ModelItem)viewElementAccessor.getDefinition())).isPresent()) {
            result.put(RESULT_ERROR, "multiple-content-inside-repeater");
            result.put("details", List.of(contentType.getLabel(), repeater.get().getLabel()));
            return false;
        }
        Map nestedMapValues = (Map)nestedMap.get(NESTED_MAPPING_VALUES);
        for (ViewItem nestedViewItem : viewElementAccessor.getViewItems()) {
            success = success && this._checkViewItemContainer(nestedViewItem, nestedMapValues, result);
        }
        return success;
    }

    private Optional<RepeaterDefinition> _getRepeaterAncestorIfExists(ModelItem modelItem) {
        ModelItemGroup parent = modelItem.getParent();
        if (parent == null) {
            return Optional.empty();
        }
        if (parent instanceof RepeaterDefinition) {
            RepeaterDefinition repeaterParent = (RepeaterDefinition)parent;
            return Optional.of(repeaterParent);
        }
        return this._getRepeaterAncestorIfExists((ModelItem)parent);
    }

    private boolean _checkViewItemGroupContainer(ViewItem viewItem, Map<String, Object> mapping, Map<String, Object> result) {
        boolean success = true;
        ModelViewItemGroup modelViewItemGroup = (ModelViewItemGroup)viewItem;
        List elementDefinition = modelViewItemGroup.getViewItems();
        Map nestedMap = (Map)mapping.get(viewItem.getName());
        Map nestedMapValues = (Map)nestedMap.get(NESTED_MAPPING_VALUES);
        for (ViewItem nestedViewItem : elementDefinition) {
            success = success && this._checkViewItemContainer(nestedViewItem, nestedMapValues, result);
        }
        return success;
    }

    private static Map<String, Object> generateNestedMapping(Map<String, Object> mapping, Map<String, Object> column) {
        return ImportCSVFileHelper.generateNestedMapping(mapping, (String)column.get(MAPPING_COLUMN_ATTRIBUTE_PATH), (String)column.get(MAPPING_COLUMN_HEADER), (Boolean)column.get(MAPPING_COLUMN_IS_ID));
    }

    private static Map<String, Object> generateNestedMapping(Map<String, Object> mapping, String attributePath, String column, boolean isId) {
        Map values = (Map)mapping.computeIfAbsent(NESTED_MAPPING_VALUES, __ -> new HashMap());
        int separatorIndex = attributePath.indexOf(47);
        if (separatorIndex == -1) {
            if (isId) {
                List ids = (List)mapping.computeIfAbsent(NESTED_MAPPING_ID, __ -> new ArrayList());
                ids.add(attributePath);
            }
            values.put(attributePath, column);
        } else {
            Map subValuesMapping = (Map)values.computeIfAbsent(attributePath.substring(0, separatorIndex), __ -> new HashMap());
            ImportCSVFileHelper.generateNestedMapping(subValuesMapping, attributePath.substring(separatorIndex + 1), column, isId);
        }
        mapping.put(NESTED_MAPPING_VALUES, values);
        return mapping;
    }

    private void _sendMail(Map<String, Object> importResult, String recipient) {
        I18nizableText subject = this._getMailSubject(importResult);
        I18nizableText body = this._getMailBody(importResult);
        try {
            String language = this._userLanguagesManager.getDefaultLanguage();
            SendMailHelper.MailBuilder mailBuilder = SendMailHelper.newMail().withSubject(this._i18nUtils.translate((I18nizable)subject, language)).withRecipient(recipient).withTextBody(this._i18nUtils.translate((I18nizable)body, language));
            mailBuilder.sendMail();
        }
        catch (MessagingException | IOException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Unable to send the e-mail '" + String.valueOf(subject) + "' to '" + recipient + "'", e);
            }
        }
        catch (Exception e) {
            this.getLogger().error("An unknown error has occured while sending the mail.", (Throwable)e);
        }
    }

    private I18nizableText _getMailSubject(Map<String, Object> importResult) {
        Map<String, I18nizableText> i18nParams = Map.of(RESULT_FILENAME, new I18nizableText((String)importResult.get(RESULT_FILENAME)));
        if (importResult.containsKey(RESULT_ERROR)) {
            return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_IMPORT_MAIL_ERROR_SUBJECT", i18nParams);
        }
        return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_IMPORT_MAIL_SUCCESS_SUBJECT", i18nParams);
    }

    private I18nizableText _getMailBody(Map<String, Object> importResult) {
        HashMap<String, I18nizableText> i18nParams = new HashMap<String, I18nizableText>();
        i18nParams.put(RESULT_FILENAME, new I18nizableText((String)importResult.get(RESULT_FILENAME)));
        if (importResult.containsKey(RESULT_ERROR)) {
            if ("no-import".equals(importResult.get(RESULT_ERROR))) {
                return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_IMPORT_MAIL_ERROR_BODY_NO_IMPORT", i18nParams);
            }
            return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_IMPORT_MAIL_ERROR_BODY_TEXT", i18nParams);
        }
        int nbErrors = (Integer)importResult.get(RESULT_NB_ERRORS);
        int nbWarnings = (Integer)importResult.get(RESULT_NB_WARNINGS);
        i18nParams.put(RESULT_IMPORTED_COUNT, new I18nizableText(String.valueOf(importResult.get(RESULT_IMPORTED_COUNT))));
        i18nParams.put(RESULT_NB_ERRORS, new I18nizableText(String.valueOf(nbErrors)));
        i18nParams.put(RESULT_NB_WARNINGS, new I18nizableText(String.valueOf(nbWarnings)));
        if (nbErrors == 0 && nbWarnings == 0) {
            return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_IMPORT_MAIL_SUCCESS_BODY", i18nParams);
        }
        if (nbWarnings == 0) {
            return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_IMPORT_MAIL_PARTIAL_SUCCESS_BODY_ERRORS", i18nParams);
        }
        if (nbErrors == 0) {
            return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_IMPORT_MAIL_PARTIAL_SUCCESS_BODY_WARNINGS", i18nParams);
        }
        return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_IMPORT_MAIL_PARTIAL_SUCCESS_BODY_ERRORS_AND_WARNINGS", i18nParams);
    }

    @Callable(rights={"Plugins_ContentIO_ImportFile"}, context="/cms")
    public void cancelImport(String importId) {
        File importFile = this._getTempFile(importId);
        FileUtils.deleteQuietly((File)importFile);
    }

    private File _getTempFile(String importId) {
        File importFile = FileUtils.getFile((File)RuntimeConfig.getInstance().getAmetysHome(), (String[])new String[]{"contentio/temp", importId + ".csv"});
        return importFile;
    }

    public Charset detectCharset(InputStream inputStream) throws IOException {
        assert (inputStream.markSupported());
        DefaultEncodingDetector defaultEncodingDetector = new DefaultEncodingDetector();
        return defaultEncodingDetector.detect(inputStream, new Metadata());
    }

    /*
     * Exception decompiling
     */
    public String[] extractHeaders(InputStream inputStream, CsvPreference csvPreference, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Map<String, Object>> getMapping(ContentType contentType, String[] headers) {
        return Arrays.asList(headers).stream().filter(StringUtils::isNotEmpty).map(header -> this._transformHeaderToMap(contentType, (String)header)).collect(Collectors.toList());
    }

    private Map<String, Object> _transformHeaderToMap(ContentType contentType, String header) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        headerMap.put(MAPPING_COLUMN_HEADER, header);
        headerMap.put(MAPPING_COLUMN_ATTRIBUTE_PATH, Optional.of(header).map(s -> s.replace("*", "")).map(s -> s.replace(".", "/")).map(String::trim).filter(arg_0 -> ((ContentType)contentType).hasModelItem(arg_0)).orElse(""));
        headerMap.put(MAPPING_COLUMN_IS_ID, header.endsWith("*"));
        return headerMap;
    }

    private List<Map<String, Object>> _filterMapping(List<Map<String, Object>> mappingValues) {
        return mappingValues.stream().map(column -> {
            Optional<String> attributePath = Optional.of(MAPPING_COLUMN_ATTRIBUTE_PATH).map(column::get).map(String.class::cast).filter(StringUtils::isNotEmpty).map(s -> s.replace(".", "/"));
            if (attributePath.isEmpty()) {
                return null;
            }
            HashMap<String, String> columnCopy = new HashMap<String, String>((Map<String, String>)column);
            columnCopy.put(MAPPING_COLUMN_ATTRIBUTE_PATH, attributePath.get());
            return columnCopy;
        }).filter(Predicate.not(Objects::isNull)).collect(Collectors.toList());
    }
}

