/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.plugins.contentio.synchronize.impl.AbstractDataSourceSynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.impl.SQLCollectionDAO;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;

public class SQLSynchronizableContentsCollection
extends AbstractDataSourceSynchronizableContentsCollection
implements Component {
    private static final String __PARAM_SQL_TABLE = "tableName";
    protected SQLCollectionDAO _sqlCollectionDAO;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._sqlCollectionDAO = (SQLCollectionDAO)((Object)smanager.lookup(SQLCollectionDAO.ROLE));
    }

    public String getTableName() {
        return (String)this.getParameterValues().get(__PARAM_SQL_TABLE);
    }

    @Override
    protected Map<String, Map<String, Object>> internalSearch(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger) {
        String idField;
        Map<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        Map<String, List<String>> mapping = this.getMapping();
        List<String> remoteKeys = mapping.get(idField = this.getIdField());
        if (CollectionUtils.isNotEmpty(remoteKeys)) {
            String remoteKey = remoteKeys.get(0);
            List<String> columns = mapping.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            Map<String, Object> params = this._getSearchParameters(searchParameters, offset, limit, sort, columns);
            List<Map<String, Object>> searchResults = this._sqlCollectionDAO.search(params, this.getDataSourceId());
            result = this._normalizeSearchResult(remoteKey, columns, searchResults, logger);
        } else {
            ++this._nbError;
            logger.error("Missing SQL attribute in mapping for field '{}' holding the unique identifier", (Object)idField);
        }
        return result;
    }

    protected Map<String, Object> _getSearchParameters(Map<String, Object> parameters, int offset, int limit, List<Object> sort, List<String> columns) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", this.getTableName());
        params.put("columns", columns);
        params.put("params", parameters);
        if (offset > 0) {
            params.put("offset", offset);
        }
        if (limit < Integer.MAX_VALUE) {
            params.put("limit", limit);
        }
        if (CollectionUtils.isNotEmpty(sort)) {
            params.put("sorts", sort);
        }
        return params;
    }

    protected Map<String, Map<String, Object>> _normalizeSearchResult(String remoteKey, List<String> columns, List<Map<String, Object>> searchResults, Logger logger) {
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        for (Map<String, Object> searchResult : searchResults) {
            Map<String, Object> newSearchResult = this._getNormalizedSearchResult(columns, searchResult);
            Object idObjectValue = newSearchResult.get(remoteKey);
            if (!this._checkIdObjectValue(remoteKey, idObjectValue, logger)) continue;
            newSearchResult.put("scc$uniqueid", idObjectValue.toString());
            newSearchResult.put(remoteKey, idObjectValue.toString());
            result.put(idObjectValue.toString(), newSearchResult);
        }
        return result;
    }

    protected boolean _checkIdObjectValue(String remoteKey, Object idObjectValue, Logger logger) {
        if (idObjectValue == null) {
            logger.warn("The content identifier is mandatory but there is no value for the key : " + remoteKey);
            return false;
        }
        return true;
    }

    protected Map<String, Object> _getNormalizedSearchResult(List<String> columns, Map<String, Object> searchResult) {
        HashMap<String, Object> normalizedSearchResult = new HashMap<String, Object>();
        for (String key : searchResult.keySet()) {
            List filteredValue = columns.stream().filter(c -> c.equalsIgnoreCase(key)).collect(Collectors.toList());
            if (filteredValue.isEmpty()) continue;
            normalizedSearchResult.put((String)filteredValue.get(0), searchResult.get(key));
        }
        return normalizedSearchResult;
    }

    @Override
    public int getTotalCount(Map<String, Object> parameters, Logger logger) {
        Map<String, Object> params = this._getTotalCounParameters(parameters);
        return this._sqlCollectionDAO.getTotalCount(params, this.getDataSourceId());
    }

    protected Map<String, Object> _getTotalCounParameters(Map<String, Object> parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("table", this.getTableName());
        params.put("params", this._removeEmptyParameters(parameters));
        return params;
    }
}

