/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.cms.data.Binary;
import org.ametys.cms.data.NamedResource;
import org.ametys.cms.data.RichText;
import org.ametys.plugins.contentio.archive.DomNodeHelper;
import org.ametys.plugins.contentio.archive.ImportGlobalFailException;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.core.NodeImpl;
import org.slf4j.Logger;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public final class Archivers {
    public static final String WARN_MESSAGE_ROOT_HAS_PENDING_CHANGES = "{} still has pending changes while we should have saved unitarily every object. Another save will be done, but it is not normal.";
    static final String __BINARY_ATTRIBUTES_FOLDER_NAME = "_binaryAttributes";
    static final String __FILE_ATTRIBUTES_FOLDER_NAME = "_fileAttributes";
    static final String __RICH_TEXT_ATTACHMENTS_FOLDER_NAME = "_richTextAttachments";
    private static final Properties __OUTPUT_FORMAT_PROPERTIES = new Properties();
    private static SAXTransformerFactory __transformerFactory;

    private Archivers() {
    }

    public static SAXTransformerFactory getSaxTransformerFactory() {
        if (__transformerFactory == null) {
            __transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        return __transformerFactory;
    }

    public static TransformerHandler newTransformerHandler() throws TransformerConfigurationException {
        TransformerHandler transformerHandler = Archivers.getSaxTransformerFactory().newTransformerHandler();
        Archivers.setStandardOutputProperties(transformerHandler);
        return transformerHandler;
    }

    public static void setStandardOutputProperties(TransformerHandler transformerHandler) {
        transformerHandler.getTransformer().setOutputProperties(__OUTPUT_FORMAT_PROPERTIES);
    }

    public static void exportAcl(javax.jcr.Node node, ZipOutputStream zos, String path) throws RepositoryException, IOException {
        try {
            if (node.hasNode("ametys-internal:acl")) {
                ZipEntry aclEntry = new ZipEntry(path);
                zos.putNextEntry(aclEntry);
                TransformerHandler aclHandler = Archivers.newTransformerHandler();
                aclHandler.setResult(new StreamResult(zos));
                node.getSession().exportSystemView(node.getNode("ametys-internal:acl").getPath(), (ContentHandler)aclHandler, true, false);
            }
        }
        catch (TransformerConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to SAX ACL for node '" + node.getPath() + "' for archiving", e);
        }
    }

    public static void importAcl(javax.jcr.Node node, Path zipPath, Merger merger, String zipEntryPath, Logger logger) throws RepositoryException, IOException {
        if (ZipEntryHelper.zipEntryFileExists(zipPath, zipEntryPath)) {
            if (node.hasNode("ametys-internal:acl")) {
                javax.jcr.Node existingAclNode = node.getNode("ametys-internal:acl");
                logger.info("Existing ACL node '{}' will be removed", (Object)existingAclNode);
                existingAclNode.remove();
            }
            Session session = node.getSession();
            String parentAbsPath = node.getPath();
            int uuidBehavior = merger.getImportUuidBehavior();
            try (InputStream in = ZipEntryHelper.zipEntryFileInputStream(zipPath, zipEntryPath);){
                session.importXML(parentAbsPath, in, uuidBehavior);
                logger.info("XML from '{}!{}' imported to '{}' with uuidBehavior '{}'", new Object[]{zipPath, zipEntryPath, parentAbsPath, uuidBehavior});
            }
        }
    }

    public static String xpathEvalNonEmpty(String xPath, Node domNode) throws AmetysObjectNotImportedException, TransformerException {
        String val = DomNodeHelper.nullableStringValue(domNode, xPath);
        if (StringUtils.isEmpty((CharSequence)val)) {
            throw new AmetysObjectNotImportedException(String.format("'%s' xPath value is empty while it is required. The Ametys Object could not be imported.", xPath));
        }
        return val;
    }

    public static javax.jcr.Node replaceNodeWithDesiredUuid(javax.jcr.Node srcNode, String uuid) throws RepositoryException {
        NodeImpl parentNode = (NodeImpl)srcNode.getParent();
        String name = srcNode.getName();
        String type = srcNode.getPrimaryNodeType().getName();
        NodeType[] mixinNodeTypes = srcNode.getMixinNodeTypes();
        srcNode.remove();
        javax.jcr.Node nodeWithDesiredUuid = parentNode.addNodeWithUuid(name, type, uuid);
        for (NodeType mixinNodeType : mixinNodeTypes) {
            nodeWithDesiredUuid.addMixin(mixinNodeType.getName());
        }
        return nodeWithDesiredUuid;
    }

    public static void unitarySave(javax.jcr.Node ametysObjectNode, Logger logger) throws AmetysObjectNotImportedException, ImportGlobalFailException {
        Session session;
        try {
            session = ametysObjectNode.getSession();
        }
        catch (RepositoryException e) {
            throw new ImportGlobalFailException(e);
        }
        try {
            logger.info("Saving '{}'...", (Object)ametysObjectNode);
            session.save();
        }
        catch (RepositoryException saveFailedException) {
            logger.error("Save did not succeed, changes on current object '{}' will be discarded...", (Object)ametysObjectNode, (Object)saveFailedException);
            try {
                session.refresh(false);
            }
            catch (RepositoryException refreshFailedException) {
                throw new ImportGlobalFailException(refreshFailedException);
            }
            throw new AmetysObjectNotImportedException(saveFailedException);
        }
    }

    public static void exportRichTexts(ModelAwareDataHolder dataHolder, ZipOutputStream zos, String path) throws IOException {
        String prefix = path + "_richTextAttachments/";
        Map richTexts = DataHolderHelper.findItemsByType((ModelAwareDataHolder)dataHolder, (String)"rich-text");
        for (Map.Entry entry : richTexts.entrySet()) {
            String richTextDataPath = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof RichText) {
                Archivers._exportRichText(richTextDataPath, (RichText)value, zos, prefix);
                continue;
            }
            if (!(value instanceof RichText[])) continue;
            for (RichText richText : (RichText[])value) {
                Archivers._exportRichText(richTextDataPath, richText, zos, prefix);
            }
        }
    }

    private static void _exportRichText(String richTextDataPath, RichText richText, ZipOutputStream zos, String prefix) throws IOException {
        for (NamedResource resource : richText.getAttachments()) {
            Archivers._exportResource(richTextDataPath, resource, zos, prefix);
        }
    }

    public static void exportBinaries(ModelAwareDataHolder dataHolder, ZipOutputStream zos, String path) throws IOException {
        String prefix = path + "_binaryAttributes/";
        Map binaries = DataHolderHelper.findItemsByType((ModelAwareDataHolder)dataHolder, (String)"binary");
        for (Map.Entry entry : binaries.entrySet()) {
            String binaryDataPath = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Binary) {
                Archivers._exportResource(binaryDataPath, (NamedResource)((Binary)value), zos, prefix);
                continue;
            }
            if (!(value instanceof Binary[])) continue;
            for (Binary binary : (Binary[])value) {
                Archivers._exportResource(binaryDataPath, (NamedResource)binary, zos, prefix);
            }
        }
    }

    public static void exportFiles(ModelAwareDataHolder dataHolder, ZipOutputStream zos, String path) throws IOException {
        String prefix = path + "_fileAttributes/";
        Map files = DataHolderHelper.findItemsByType((ModelAwareDataHolder)dataHolder, (String)"file");
        for (Map.Entry entry : files.entrySet()) {
            String fileDataPath = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Binary) {
                Archivers._exportResource(fileDataPath, (NamedResource)((Binary)value), zos, prefix);
                continue;
            }
            if (!(value instanceof Binary[])) continue;
            for (Binary binary : (Binary[])value) {
                Archivers._exportResource(fileDataPath, (NamedResource)binary, zos, prefix);
            }
        }
    }

    private static void _exportResource(String dataPath, NamedResource resource, ZipOutputStream zos, String prefix) throws IOException {
        String resourcePath = Archivers.getFolderPathFromDataPath(dataPath);
        ZipEntry newEntry = new ZipEntry(prefix + resourcePath + "/" + resource.getFilename());
        zos.putNextEntry(newEntry);
        try (InputStream is = resource.getInputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)zos);
        }
    }

    public static String getFolderPathFromDataPath(String dataPath) {
        return RegExUtils.replaceAll((String)dataPath, (String)"\\[([0-9]+)\\]", (String)"/$1");
    }

    static {
        __OUTPUT_FORMAT_PROPERTIES.put("encoding", "UTF-8");
        __OUTPUT_FORMAT_PROPERTIES.put("method", "xml");
        __OUTPUT_FORMAT_PROPERTIES.put("indent", "yes");
        __OUTPUT_FORMAT_PROPERTIES.put("{http://xml.apache.org/xalan}indent-amount", "4");
    }

    public static final class AmetysObjectNotImportedException
    extends Exception {
        public AmetysObjectNotImportedException(String message) {
            super(message);
        }

        public AmetysObjectNotImportedException(Throwable cause) {
            super(cause);
        }
    }
}

