/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.ametys.plugins.contentio.archive.IgnoreMergerHelper;
import org.ametys.plugins.contentio.archive.MergeException;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.repository.AmetysObject;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.RemovableAmetysObject;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;

public class Mergers
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable,
Disposable {
    public static final String ROLE = Mergers.class.getName();
    static final Merger DELETE_BEFORE = new DeleteBefore();
    static final Merger IGNORE = new Ignore();
    static final Merger REPLACE = new Replace();
    static final Merger FAIL = new Fail();
    private static final Merger[] __IMPLEMENTATIONS = new Merger[]{DELETE_BEFORE, IGNORE, REPLACE, FAIL};
    AmetysObjectResolver _ametysObjectResolver;
    SourceResolver _sourceResolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._ametysObjectResolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    private static void _bindMergersComponent(Mergers mergersComponent) {
        for (Merger merger : __IMPLEMENTATIONS) {
            if (!(merger instanceof AbstractMerger)) continue;
            ((AbstractMerger)merger).lateBindDependencies(mergersComponent);
        }
    }

    public void initialize() throws Exception {
        Mergers._bindMergersComponent(this);
    }

    public void dispose() {
        Mergers._bindMergersComponent(null);
    }

    protected Logger getLogger() {
        return super.getLogger();
    }

    private static abstract class AbstractMerger
    implements Merger {
        protected Mergers _mergers;

        private AbstractMerger() {
        }

        void lateBindDependencies(Mergers mergersComponent) {
            this._mergers = mergersComponent;
        }
    }

    private static final class DeleteBefore
    implements Merger {
        private DeleteBefore() {
        }

        @Override
        public boolean deleteBeforePartialImport() {
            return true;
        }

        @Override
        public boolean needsMerge(String id) {
            return false;
        }

        @Override
        public Merger.AfterMerge merge(String id) {
            throw new NotImplementedException("Should never be called");
        }

        @Override
        public int getImportUuidBehavior() {
            return 3;
        }
    }

    private static final class Ignore
    extends AbstractMerger {
        private Ignore() {
        }

        @Override
        public boolean needsMerge(String id) {
            return this._mergers._ametysObjectResolver.hasAmetysObjectForId(id);
        }

        @Override
        public Merger.AfterMerge merge(String id) {
            this._mergers.getLogger().debug("Object for id '{}' will be ignored as it already exists ('Ignore' MergePolicy)...", (Object)id);
            return Merger.AfterMerge.STOP_PROCESS;
        }

        @Override
        public int getImportUuidBehavior() {
            return 3;
        }

        @Override
        public void jcrImportXml(Session session, String parentAbsPath, InputStream in) throws RepositoryException, IOException {
            IgnoreMergerHelper.jcrImportXml(session, parentAbsPath, in, this.getImportUuidBehavior(), this._mergers);
        }
    }

    private static final class Replace
    extends AbstractMerger {
        private Replace() {
        }

        @Override
        public boolean needsMerge(String id) {
            return this._mergers._ametysObjectResolver.hasAmetysObjectForId(id);
        }

        @Override
        public Merger.AfterMerge merge(String id) {
            AmetysObject ametysObject = this._mergers._ametysObjectResolver.resolveById(id);
            if (ametysObject instanceof RemovableAmetysObject) {
                this._mergers.getLogger().debug("Removing existing object '{}' as it will be re-created ('Replace' MergePolicy)...", (Object)ametysObject);
                ((RemovableAmetysObject)ametysObject).remove();
                return Merger.AfterMerge.CONTINUE_PROCESS;
            }
            throw new IllegalArgumentException(String.format("The given object (%s) for id '%s' cannot be merged with a 'Replace' MergePolicy, as the existing object is not a RemovableAmetysObject", ametysObject, id));
        }

        @Override
        public int getImportUuidBehavior() {
            return 2;
        }
    }

    private static final class Fail
    extends AbstractMerger {
        private Fail() {
        }

        @Override
        public boolean needsMerge(String id) {
            return this._mergers._ametysObjectResolver.hasAmetysObjectForId(id);
        }

        @Override
        public Merger.AfterMerge merge(String id) throws MergeException {
            AmetysObject ametysObject = this._mergers._ametysObjectResolver.resolveById(id);
            throw new MergeException(String.format("The import failed because the object with id '%s' already exists and the 'Fail' MergePolicy was selected.", ametysObject, id));
        }

        @Override
        public int getImportUuidBehavior() {
            return 3;
        }
    }
}

