/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.export.sql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.contentio.export.sql.CreateSqlTableComponent;
import org.ametys.plugins.contentio.export.sql.DeleteSqlTableComponent;
import org.ametys.plugins.contentio.export.sql.ExportConfiguration;
import org.ametys.plugins.contentio.export.sql.ExportTableInfo;
import org.ametys.plugins.contentio.export.sql.FillSqlTableComponent;
import org.ametys.plugins.contentio.export.sql.ReservedWordsUtils;
import org.ametys.plugins.repository.AmetysRepositoryException;
import org.ametys.runtime.i18n.I18nizable;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ExportManager
extends AbstractLogEnabled
implements Configurable,
Component,
Serviceable {
    public static final String ROLE = ExportManager.class.getName();
    public static final String DEFAULT_TABLE_PREFIX = "AmetysExport";
    public static final String CONTENT_EXPORT_POOL_NAME = "content.export.jdbc.pool";
    public static final String RICH_TEXT_DATA_TABLE_NAME = "Ametys_RichTextImages";
    public static final String MAPPING_TABLE_NAME = "Ametys_tableMapping";
    public static final String MAPPING_COLUMN_NAME = "Ametys_columnMapping";
    public static final String CONTENT_TABLE_NAME = "Ametys_AllContents";
    public static final String DEFAULT_SEPARATOR = ", ";
    protected ContentTypeExtensionPoint _contentTypeExtensionPoint;
    protected I18nUtils _i18nTranslator;
    protected DeleteSqlTableComponent _deleteSqlTableComponent;
    protected CreateSqlTableComponent _createSqlTableComponent;
    protected FillSqlTableComponent _fillSqlTableComponent;
    private ExportConfiguration _exportConfiguration;

    public void service(ServiceManager sManager) throws ServiceException {
        this._contentTypeExtensionPoint = (ContentTypeExtensionPoint)sManager.lookup(ContentTypeExtensionPoint.ROLE);
        this._i18nTranslator = (I18nUtils)sManager.lookup(I18nUtils.ROLE);
        this._deleteSqlTableComponent = (DeleteSqlTableComponent)((Object)sManager.lookup(DeleteSqlTableComponent.ROLE));
        this._createSqlTableComponent = (CreateSqlTableComponent)((Object)sManager.lookup(CreateSqlTableComponent.ROLE));
        this._fillSqlTableComponent = (FillSqlTableComponent)((Object)sManager.lookup(FillSqlTableComponent.ROLE));
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._exportConfiguration = new ExportConfiguration();
        Object tablePrefix = configuration.getAttribute("prefix", DEFAULT_TABLE_PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)tablePrefix) && !StringUtils.endsWith((CharSequence)tablePrefix, (CharSequence)"_")) {
            tablePrefix = (String)tablePrefix + "_";
        }
        this._exportConfiguration.setTablePrefix((String)tablePrefix);
        String exportOnlyValidatedContentAsString = configuration.getAttribute("exportOnlyValidatedContent", "false");
        this._exportConfiguration.setExportOnlyValidatedContent("true".equals(exportOnlyValidatedContentAsString));
        String exportNoMultiValuedTableAsString = configuration.getAttribute("exportNoMultiValuedTable", "false");
        this._exportConfiguration.setExportNoMultiValuedTable("true".equals(exportNoMultiValuedTableAsString));
        String separator = configuration.getAttribute("separator", DEFAULT_SEPARATOR);
        this._exportConfiguration.setSeparator(separator);
        this._configureContentTypeToExport(configuration, (String)tablePrefix);
        this._configureSQLMapping(configuration);
        this._configureReservedWords(configuration);
        String mappingPolicy = configuration.getChild("mapping-policy").getAttribute("value", "FULL");
        this._exportConfiguration.setMappingPolicy(mappingPolicy);
    }

    protected void _configureContentTypeToExport(Configuration configuration, String tablePrefix) throws ConfigurationException {
        HashMap<String, String> contentTypesToExport = new HashMap<String, String>();
        for (Configuration contentConf : configuration.getChild("contents").getChildren("content")) {
            String cTypeId = contentConf.getAttribute("id");
            String name = contentConf.getAttribute("name", null);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                contentTypesToExport.put(cTypeId, tablePrefix + name);
                continue;
            }
            String defaultTableName = cTypeId.substring(cTypeId.lastIndexOf(".") + 1);
            contentTypesToExport.put(cTypeId, tablePrefix + defaultTableName);
        }
        if (contentTypesToExport.isEmpty()) {
            for (String cTypeId : this._contentTypeExtensionPoint.getExtensionsIds()) {
                String defaultTableName = cTypeId.substring(cTypeId.lastIndexOf(".") + 1);
                contentTypesToExport.put(cTypeId, tablePrefix + defaultTableName);
            }
        }
        this._exportConfiguration.setContentTypesToExport(contentTypesToExport);
    }

    protected void _configureReservedWords(Configuration configuration) throws ConfigurationException {
        boolean override = "true".equals(configuration.getChild("reserved-words").getAttribute("override", "false"));
        HashMap<String, Map<String, String>> reservedWords = new HashMap<String, Map<String, String>>();
        Configuration mysqlReservedWords = configuration.getChild("reserved-words").getChild("mysql");
        Map<Object, Object> mysqlReservedWordsMap = new HashMap();
        if (!override) {
            mysqlReservedWordsMap = ReservedWordsUtils.RESERVED_WORDS_MYSQL;
        }
        for (Configuration wordConf : mysqlReservedWords.getChildren("word")) {
            mysqlReservedWordsMap.put(wordConf.getAttribute("name"), wordConf.getAttribute("alias"));
        }
        if (mysqlReservedWordsMap.isEmpty()) {
            mysqlReservedWordsMap = ReservedWordsUtils.RESERVED_WORDS_MYSQL;
        }
        reservedWords.put("mysql", mysqlReservedWordsMap);
        Configuration oracleReservedWords = configuration.getChild("reserved-words").getChild("oracle");
        Map<Object, Object> oracleReservedWordsMap = new HashMap();
        if (!override) {
            oracleReservedWordsMap = ReservedWordsUtils.RESERVED_WORDS_ORACLE;
        }
        for (Configuration wordConf : oracleReservedWords.getChildren("word")) {
            oracleReservedWordsMap.put(wordConf.getAttribute("name"), wordConf.getAttribute("alias"));
        }
        if (oracleReservedWordsMap.isEmpty()) {
            oracleReservedWordsMap = ReservedWordsUtils.RESERVED_WORDS_ORACLE;
        }
        reservedWords.put("oracle", oracleReservedWordsMap);
        this._exportConfiguration.setReservedWords(reservedWords);
    }

    protected void _configureSQLMapping(Configuration configuration) {
        HashMap<String, Map<String, String>> mappingSql = new HashMap<String, Map<String, String>>();
        HashMap<String, String> mappingSqlMetadata = new HashMap<String, String>();
        mappingSqlMetadata.put("short-string", configuration.getChild("sql").getChild("mysql").getChild("short-string").getValue("VARCHAR(255)"));
        mappingSqlMetadata.put("string", configuration.getChild("sql").getChild("mysql").getChild("string").getValue("TEXT"));
        mappingSqlMetadata.put("long", configuration.getChild("sql").getChild("mysql").getChild("long").getValue("BIGINT"));
        mappingSqlMetadata.put("boolean", configuration.getChild("sql").getChild("mysql").getChild("boolean").getValue("TINYINT"));
        mappingSqlMetadata.put("date", configuration.getChild("sql").getChild("mysql").getChild("date").getValue("DATE"));
        mappingSqlMetadata.put("datetime", configuration.getChild("sql").getChild("mysql").getChild("datetime").getValue("DATETIME"));
        mappingSqlMetadata.put("double", configuration.getChild("sql").getChild("mysql").getChild("double").getValue("DOUBLE"));
        mappingSqlMetadata.put("rich-text", configuration.getChild("sql").getChild("mysql").getChild("rich-text").getValue("MEDIUMTEXT"));
        mappingSqlMetadata.put("content", configuration.getChild("sql").getChild("mysql").getChild("content").getValue("VARCHAR(512)"));
        mappingSqlMetadata.put("file", configuration.getChild("sql").getChild("mysql").getChild("file").getValue("LONGBLOB"));
        mappingSqlMetadata.put("binary", configuration.getChild("sql").getChild("mysql").getChild("binary").getValue("LONGBLOB"));
        mappingSql.put("mysql", mappingSqlMetadata);
        HashMap<String, String> mappingOracleMetadata = new HashMap<String, String>();
        mappingOracleMetadata.put("short-string", configuration.getChild("sql").getChild("mysql").getChild("short-string").getValue("VARCHAR(255)"));
        mappingOracleMetadata.put("string", configuration.getChild("sql").getChild("oracle").getChild("string").getValue("VARCHAR(4000)"));
        mappingOracleMetadata.put("long", configuration.getChild("sql").getChild("oracle").getChild("long").getValue("NUMBER"));
        mappingOracleMetadata.put("boolean", configuration.getChild("sql").getChild("oracle").getChild("boolean").getValue("CHAR(1)"));
        mappingOracleMetadata.put("date", configuration.getChild("sql").getChild("oracle").getChild("date").getValue("DATE"));
        mappingOracleMetadata.put("datetime", configuration.getChild("sql").getChild("oracle").getChild("datetime").getValue("DATE"));
        mappingOracleMetadata.put("double", configuration.getChild("sql").getChild("oracle").getChild("double").getValue("NUMBER"));
        mappingOracleMetadata.put("rich-text", configuration.getChild("sql").getChild("oracle").getChild("rich-text").getValue("VARCHAR(4000)"));
        mappingOracleMetadata.put("content", configuration.getChild("sql").getChild("oracle").getChild("content").getValue("VARCHAR(512)"));
        mappingOracleMetadata.put("file", configuration.getChild("sql").getChild("oracle").getChild("file").getValue("BLOB"));
        mappingOracleMetadata.put("binary", configuration.getChild("sql").getChild("oracle").getChild("binary").getValue("BLOB"));
        mappingSql.put("oracle", mappingOracleMetadata);
        this._exportConfiguration.setMappingSql(mappingSql);
    }

    public void export() throws SQLException, AmetysRepositoryException, ContextException, IOException {
        boolean isInfoEnabled = this.getLogger().isInfoEnabled();
        if (isInfoEnabled) {
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_BEGIN")));
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_INIT_BEGIN")));
        }
        this.initialize();
        if (isInfoEnabled) {
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_INIT_END")));
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_DELETE_BEGIN")));
        }
        this._deleteSqlTableComponent.deleteExistingSqlTables(this._exportConfiguration);
        if (isInfoEnabled) {
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_CREATE_BEGIN")));
        }
        Map<String, ExportTableInfo> tableInfo = this._createSqlTableComponent.createTables(this._exportConfiguration);
        if (isInfoEnabled) {
            this.getLogger().info(this._i18nTranslator.translate((I18nizable)new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CONTENT_EXPORT_LOG_FILL_BEGIN")));
        }
        this._fillSqlTableComponent.fillTable(this._exportConfiguration, tableInfo);
    }

    protected void initialize() {
        Map<String, String> contents = this._exportConfiguration.getContentTypesToExport();
        if (contents.isEmpty()) {
            String prefix = this._exportConfiguration.getTablePrefix();
            for (String contentTypeId : this._contentTypeExtensionPoint.getExtensionsIds()) {
                String defaultTableName = prefix + contentTypeId.substring(contentTypeId.lastIndexOf(".") + 1);
                contents.put(contentTypeId, defaultTableName);
            }
            this._exportConfiguration.setContentTypesToExport(contents);
        }
    }

    public ExportConfiguration getExportConfiguration() {
        return this._exportConfiguration;
    }

    public void setExportConfiguration(ExportConfiguration exportConfiguration) {
        this._exportConfiguration = exportConfiguration;
    }
}

