/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.in;

import com.opensymphony.workflow.WorkflowException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ContentQueryHelper;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.workflow.AbstractContentWorkflowComponent;
import org.ametys.cms.workflow.ContentWorkflowHelper;
import org.ametys.plugins.contentio.in.ContentImporter;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectIterator;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.jcr.NameHelper;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workflow.AbstractWorkflowComponent;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractContentImporter
extends AbstractLogEnabled
implements ContentImporter,
Serviceable,
Configurable {
    protected static final int DEFAULT_PRIORITY = 5000;
    protected static final String _CONTENT_ID_MAP_KEY = AbstractContentImporter.class.getName() + "$contentIdMap";
    protected static final String _CONTENT_LINK_MAP_KEY = AbstractContentImporter.class.getName() + "$contentLinkMap";
    protected static final String _CONTENT_REPEATER_SIZE_MAP = AbstractContentImporter.class.getName() + "$contentRepeaterSizeMap";
    protected AmetysObjectResolver _resolver;
    protected ContentWorkflowHelper _contentWorkflowHelper;
    protected int _priority = 5000;
    protected Set<String> _extensions;
    protected String[] _contentTypes;
    protected String[] _mixins;
    protected String _language;
    protected String _workflowName;
    protected int _initialActionId;
    protected int _editActionId;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._contentWorkflowHelper = (ContentWorkflowHelper)manager.lookup(ContentWorkflowHelper.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._priority = configuration.getChild("priority").getValueAsInteger(5000);
        this.configureExtensions(configuration.getChild("extensions"));
        this.configureContentCreation(configuration.getChild("content-creation"));
    }

    protected void configureExtensions(Configuration configuration) throws ConfigurationException {
        this._extensions = new HashSet<String>();
        String extensionsStr = configuration.getValue("");
        if (StringUtils.isBlank((CharSequence)extensionsStr)) {
            this._extensions.addAll(this.getDefaultExtensions());
        } else {
            for (String ext : StringUtils.split((String)extensionsStr, (String)", ")) {
                String extension = ext.trim();
                if (extension.startsWith(".")) {
                    extension = extension.substring(1);
                }
                this._extensions.add(extension);
            }
        }
    }

    protected void configureContentCreation(Configuration configuration) throws ConfigurationException {
        String typesStr = configuration.getChild("content-types").getValue();
        this._contentTypes = StringUtils.split((String)typesStr, (String)", ");
        String mixins = configuration.getChild("mixins").getValue("");
        this._mixins = StringUtils.split((String)mixins, (String)", ");
        this._language = configuration.getChild("language").getValue();
        this.configureWorkflow(configuration);
    }

    protected void configureWorkflow(Configuration configuration) throws ConfigurationException {
        Configuration wfConf = configuration.getChild("workflow");
        this._workflowName = wfConf.getAttribute("name");
        this._initialActionId = wfConf.getAttributeAsInteger("createActionId");
        this._editActionId = wfConf.getAttributeAsInteger("editActionId");
    }

    public int getPriority() {
        return this._priority;
    }

    protected Collection<String> getDefaultExtensions() {
        return Collections.emptySet();
    }

    protected boolean isExtensionValid(String name) throws IOException {
        return this._extensions.isEmpty() || this._extensions.contains(FilenameUtils.getExtension((String)name));
    }

    protected String[] getContentTypes(Map<String, Object> params) {
        return this._contentTypes;
    }

    protected String[] getMixins(Map<String, Object> params) {
        return this._mixins;
    }

    protected String getLanguage(Map<String, Object> params) {
        return this._language;
    }

    protected String getWorkflowName(Map<String, Object> params) {
        return this._workflowName;
    }

    protected int getInitialActionId(Map<String, Object> params) {
        return this._initialActionId;
    }

    protected int getEditActionId(Map<String, Object> params) {
        return this._editActionId;
    }

    protected Map<String, String> getContentIdMap(Map<String, Object> params) {
        HashMap contentIdMap = (HashMap)params.get(_CONTENT_ID_MAP_KEY);
        if (contentIdMap == null) {
            contentIdMap = new HashMap();
            params.put(_CONTENT_ID_MAP_KEY, contentIdMap);
        }
        return contentIdMap;
    }

    protected Map<Content, Map<String, Object>> getContentRefMap(Map<String, Object> params) {
        HashMap contentRefMap = (HashMap)params.get(_CONTENT_LINK_MAP_KEY);
        if (contentRefMap == null) {
            contentRefMap = new HashMap();
            params.put(_CONTENT_LINK_MAP_KEY, contentRefMap);
        }
        return contentRefMap;
    }

    protected void addContentReference(Content content, String metadataPath, ContentReference reference, Map<String, Object> params) {
        this.addContentReference(this.getContentRefMap(params), content, metadataPath, reference);
    }

    protected void addContentReference(Map<Content, Map<String, Object>> contentRefMap, Content content, String metadataPath, ContentReference reference) {
        Map<Object, Object> contentReferences;
        if (contentRefMap.containsKey(content)) {
            contentReferences = contentRefMap.get(content);
        } else {
            contentReferences = new HashMap();
            contentRefMap.put(content, contentReferences);
        }
        contentReferences.put(metadataPath, reference);
    }

    protected void addContentReferences(Map<Content, Map<String, Object>> contentRefMap, Content content, String metadataPath, List<ContentReference> references) {
        Map<Object, Object> contentReferences;
        if (contentRefMap.containsKey(content)) {
            contentReferences = contentRefMap.get(content);
        } else {
            contentReferences = new HashMap();
            contentRefMap.put(content, contentReferences);
        }
        contentReferences.put(metadataPath, references);
    }

    protected Map<Content, Map<String, Integer>> getContentRepeaterSizeMap(Map<String, Object> params) {
        HashMap contentRepeaterSizeMap = (HashMap)params.get(_CONTENT_REPEATER_SIZE_MAP);
        if (contentRepeaterSizeMap == null) {
            contentRepeaterSizeMap = new HashMap();
            params.put(_CONTENT_REPEATER_SIZE_MAP, contentRepeaterSizeMap);
        }
        return contentRepeaterSizeMap;
    }

    protected void setRepeaterSize(Content content, String metadataPath, int repeaterSize, Map<String, Object> params) {
        Map<Object, Object> repeaters;
        Map<Content, Map<String, Integer>> contentRepeaterSizeMap = this.getContentRepeaterSizeMap(params);
        if (contentRepeaterSizeMap.containsKey(content)) {
            repeaters = contentRepeaterSizeMap.get(content);
        } else {
            repeaters = new HashMap();
            contentRepeaterSizeMap.put(content, repeaters);
        }
        repeaters.put(metadataPath, repeaterSize);
    }

    protected Content createContent(String title, Map<String, Object> params) throws WorkflowException {
        String[] contentTypes = this.getContentTypes(params);
        String[] mixins = this.getMixins(params);
        String language = this.getLanguage(params);
        String workflowName = this.getWorkflowName(params);
        int initialActionId = this.getInitialActionId(params);
        return this.createContent(title, contentTypes, mixins, language, workflowName, initialActionId, params);
    }

    protected Content createContent(String title, String[] contentTypes, String[] mixins, String language, Map<String, Object> params) throws WorkflowException {
        String workflowName = this.getWorkflowName(params);
        int initialActionId = this.getInitialActionId(params);
        return this.createContent(title, contentTypes, mixins, language, workflowName, initialActionId, params);
    }

    protected Content createContent(String title, String[] contentTypes, String[] mixins, String language, String workflowName, int initialActionId, Map<String, Object> params) throws WorkflowException {
        Object name;
        try {
            name = NameHelper.filterName((String)title);
        }
        catch (Exception e) {
            name = "content-" + title;
        }
        Map result = this._contentWorkflowHelper.createContent(workflowName, initialActionId, (String)name, title, contentTypes, mixins, language);
        return (Content)result.get(AbstractContentWorkflowComponent.CONTENT_KEY);
    }

    protected void restoreContentReferences(Map<String, Object> params) {
        Map<Content, Map<String, Object>> contentRefMap = this.getContentRefMap(params);
        Map<Content, Map<String, Integer>> contentRepeaterSizeMap = this.getContentRepeaterSizeMap(params);
        int editActionId = this.getEditActionId(params);
        for (Content content : contentRefMap.keySet()) {
            if (!(content instanceof WorkflowAwareContent)) continue;
            Map<String, Object> contentReferences = contentRefMap.get(content);
            Map<String, Integer> repeaters = contentRepeaterSizeMap.get(content);
            HashMap<String, Object> values = new HashMap<String, Object>();
            this.setReferenceMetadatas(contentReferences, values, repeaters, params);
            try {
                if (values.isEmpty()) continue;
                HashMap<String, Serializable> contextParameters = new HashMap<String, Serializable>();
                contextParameters.put("quit", Boolean.valueOf(true));
                contextParameters.put("values", values);
                HashMap<String, HashMap<String, Serializable>> inputs = new HashMap<String, HashMap<String, Serializable>>();
                inputs.put(AbstractWorkflowComponent.CONTEXT_PARAMETERS_KEY, contextParameters);
                inputs.put(AbstractContentWorkflowComponent.CONTENT_KEY, (HashMap<String, Serializable>)content);
                this._contentWorkflowHelper.doAction((WorkflowAwareContent)content, editActionId, inputs);
            }
            catch (WorkflowException e) {
                this.getLogger().warn("An error occurred restoring content references in content {}", (Object)content, (Object)e);
            }
        }
    }

    protected void setReferenceMetadatas(Map<String, Object> contentReferences, Map<String, Object> values, Map<String, Integer> repeaters, Map<String, Object> params) {
        for (String metadataPath : contentReferences.keySet()) {
            String refContentId;
            Object value = contentReferences.get(metadataPath);
            String metaKey = "content.input." + metadataPath;
            if (value instanceof List) {
                List references = (List)value;
                ArrayList<String> contentIds = new ArrayList<String>(references.size());
                for (ContentReference reference : references) {
                    String refContentId2 = this.getReferencedContentId(reference, params);
                    if (refContentId2 == null) continue;
                    contentIds.add(refContentId2);
                }
                if (contentIds.isEmpty()) continue;
                values.put(metaKey, contentIds);
                continue;
            }
            if (!(value instanceof ContentReference) || (refContentId = this.getReferencedContentId((ContentReference)value, params)) == null) continue;
            values.put(metaKey, refContentId);
        }
        if (repeaters != null) {
            for (String repeaterPath : repeaters.keySet()) {
                Integer size = repeaters.get(repeaterPath);
                if (size <= 0) continue;
                String sizeKey = "_content.input." + repeaterPath + "/size";
                values.put(sizeKey, repeaters.get(repeaterPath).toString());
            }
        }
    }

    protected String getReferencedContentId(ContentReference contentRef, Map<String, Object> params) {
        Map values;
        Content content;
        int refType = contentRef.getType();
        if (refType == 1) {
            String localId = (String)contentRef.getValue();
            String contentId = this.getContentIdMap(params).get(localId);
            if (StringUtils.isNotEmpty((CharSequence)contentId) && this._resolver.hasAmetysObjectForId(contentId)) {
                return contentId;
            }
        } else if (refType == 2) {
            String contentId = (String)contentRef.getValue();
            if (StringUtils.isNotEmpty((CharSequence)contentId) && this._resolver.hasAmetysObjectForId(contentId)) {
                return contentId;
            }
        } else if (refType == 3 && (content = this.getContentFromProperties(values = (Map)contentRef.getValue())) != null) {
            return content.getId();
        }
        return null;
    }

    protected Content getContentFromProperties(Map<String, String> propertyValues) {
        Content content = null;
        AndExpression expression = new AndExpression(new Expression[0]);
        for (String property : propertyValues.keySet()) {
            String value = propertyValues.get(property);
            expression.add((Object)new StringExpression(property, Expression.Operator.EQ, value));
        }
        String query = ContentQueryHelper.getContentXPathQuery((Expression)expression);
        AmetysObjectIterable contents = this._resolver.query(query);
        AmetysObjectIterator it = contents.iterator();
        if (it.hasNext()) {
            content = (Content)it.next();
            if (it.hasNext()) {
                content = null;
            }
        }
        return content;
    }

    public class ContentReference {
        public static final int TYPE_LOCAL_ID = 1;
        public static final int TYPE_CONTENT_ID = 2;
        public static final int TYPE_CONTENT_VALUES = 3;
        private int _type;
        private Object _value;

        public ContentReference(AbstractContentImporter this$0, int type, Object value) {
            this._type = type;
            this._value = value;
        }

        public int getType() {
            return this._type;
        }

        public void setType(int type) {
            this._type = type;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object value) {
            this._value = value;
        }
    }
}

