/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.workflow;

import com.opensymphony.workflow.WorkflowException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ametys.cms.data.ContentSynchronizationContext;
import org.ametys.cms.data.ContentSynchronizationResult;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.workflow.EditContentFunction;
import org.ametys.core.observation.Event;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.AvalonLoggerAdapter;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.repository.data.external.ExternalizableDataProvider;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.data.holder.impl.DataHolderHelper;
import org.ametys.plugins.repository.data.holder.values.SynchronizationResult;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.View;
import org.ametys.runtime.model.ViewItemAccessor;
import org.ametys.runtime.parameter.ValidationResult;
import org.ametys.runtime.parameter.ValidationResults;
import org.slf4j.Logger;

public class EditSynchronizedContentFunction
extends EditContentFunction {
    public static final String SYNCHRO_INVERT_EDIT_ACTION_ID_KEY = EditSynchronizedContentFunction.class.getName() + "$synchroInvertEditActionId";
    public static final String INVERT_EDIT_ACTION_ID_KEY = EditSynchronizedContentFunction.class.getName() + "$invertEditActionId";
    public static final String NOT_SYNCHRONIZED_RELATED_CONTENT_IDS_KEY = EditSynchronizedContentFunction.class.getName() + "$notSynchronizedContents";
    public static final String SCC_KEY = SynchronizableContentsCollection.class.getName();
    public static final String SCC_LOGGER_KEY = SynchronizableContentsCollection.class.getName() + "$logger";
    public static final String ADDITIONAL_PARAMS_KEY = SynchronizableContentsCollection.class.getName() + "$additionalParams";
    public static final int DEFAULT_SYNCHRO_INVERT_EDIT_ACTION_ID = 800;
    public static final int DEFAULT_INVERT_EDIT_ACTION_ID = 22;
    public static final String IMPORT = "import";

    protected ContentSynchronizationContext getSynchronizationContext(Map transientVars) {
        ContentSynchronizationContext synchronizationContext = super.getSynchronizationContext(transientVars).withStatus(ExternalizableDataProvider.ExternalizableDataStatus.EXTERNAL);
        this.getSynchronizableContentsCollection(transientVars).map(SynchronizableContentsCollection::getId).ifPresent(sccId -> synchronizationContext.withExternalizableDataContextEntry("sccId", sccId));
        return synchronizationContext;
    }

    protected Map<String, Object> convertValues(ModifiableContent content, View view, Map<String, Object> values, Map transientVars) {
        HashMap externalizableContext = new HashMap();
        this.getSynchronizableContentsCollection(transientVars).map(SynchronizableContentsCollection::getId).ifPresent(sccId -> externalizableContext.put("sccId", sccId));
        DataHolderHelper.SynchronizableValuesStatusInfos statusInfos = new DataHolderHelper.SynchronizableValuesStatusInfos((ModelAwareDataHolder)content, externalizableContext);
        return DataHolderHelper.convertValuesWithSynchronizableValues((ViewItemAccessor)view, values, DataHolderHelper::convertValueIgnoringIncompatibleOnes, Optional.of(statusInfos));
    }

    protected ValidationResults validateValues(View view, ModifiableContent content, Map<String, Object> values, Map transientVars) throws WorkflowException {
        return new ValidationResults();
    }

    protected ValidationResult globalValidate(View view, Content content, Map<String, Object> values) {
        return ValidationResult.empty();
    }

    protected ContentSynchronizationResult additionalOperations(ModifiableContent content, Map transientVars) throws WorkflowException {
        ContentSynchronizationResult result = super.additionalOperations(content, transientVars);
        Optional<SynchronizableContentsCollection> scc = this.getSynchronizableContentsCollection(transientVars);
        if (scc.isPresent()) {
            Map<String, Object> additionalParams = this.getAdditionalParameters(transientVars);
            ContentSynchronizationResult additionalResult = this.isImportMode(transientVars) ? scc.get().additionalImportOperations(content, additionalParams, this.getLogger(transientVars)) : scc.get().additionalSynchronizeOperations(content, additionalParams, this.getLogger(transientVars));
            result.aggregateResult((SynchronizationResult)additionalResult);
        }
        return result;
    }

    protected boolean isImportMode(Map transientVars) throws WorkflowException {
        Map parameters = this.getContextParameters(transientVars);
        Boolean importContent = (Boolean)parameters.get(IMPORT);
        return Boolean.TRUE.equals(importContent);
    }

    protected Optional<SynchronizableContentsCollection> getSynchronizableContentsCollection(Map transientVars) {
        return Optional.of(transientVars).map(vars -> vars.get(SCC_KEY)).filter(SynchronizableContentsCollection.class::isInstance).map(SynchronizableContentsCollection.class::cast);
    }

    protected Logger getLogger(Map transientVars) {
        return Optional.of(transientVars).map(vars -> vars.get(SCC_LOGGER_KEY)).filter(Logger.class::isInstance).map(Logger.class::cast).orElseGet(() -> new AvalonLoggerAdapter(this._logger));
    }

    protected Map<String, Object> getAdditionalParameters(Map transientVars) {
        return Optional.of(transientVars).map(vars -> vars.get(ADDITIONAL_PARAMS_KEY)).filter(Map.class::isInstance).map(Map.class::cast).orElseGet(HashMap::new);
    }

    protected int getInvertEditActionId(Map transientVars, Content referencedContent) {
        int synchroInvertActionId = transientVars.getOrDefault(SYNCHRO_INVERT_EDIT_ACTION_ID_KEY, 800);
        int invertActionId = transientVars.getOrDefault(INVERT_EDIT_ACTION_ID_KEY, 22);
        Set notSynchronizedContents = transientVars.getOrDefault(NOT_SYNCHRONIZED_RELATED_CONTENT_IDS_KEY, Set.of());
        return notSynchronizedContents.contains(referencedContent.getId()) ? invertActionId : synchroInvertActionId;
    }

    protected void notifyContentModifying(Content content, Map<String, Object> values, Map transientVars) throws WorkflowException {
    }

    protected void updateCommonMetadata(ModifiableContent content, UserIdentity user, SynchronizationResult synchronizationResult) throws WorkflowException {
        if (synchronizationResult.hasChanged()) {
            super.updateCommonMetadata(content, user, synchronizationResult);
        }
    }

    protected void extractOutgoingReferences(ModifiableContent content, SynchronizationResult synchronizationResult) {
        if (synchronizationResult.hasChanged()) {
            super.extractOutgoingReferences(content, synchronizationResult);
        }
    }

    protected void prepareOrNotifyContentModified(Content content, Map transientVars, Map args, SynchronizationResult synchronizationResult) throws WorkflowException {
        if (synchronizationResult.hasChanged()) {
            boolean notify = Boolean.parseBoolean(args.getOrDefault("notify", "true"));
            if (notify) {
                HashMap<String, Object> eventParams = new HashMap<String, Object>();
                eventParams.put("content", content);
                eventParams.put("content.id", content.getId());
                this._observationManager.notify(new Event("contentio.content.synchronized", this.getUser(transientVars), eventParams));
            } else {
                transientVars.put("event-to-notify", "contentio.content.synchronized");
            }
        }
    }

    protected boolean canWriteModelItem(ModelItem modelItem, Content content, Map transientVars) {
        if (this.getSynchronizableContentsCollection(transientVars).map(SynchronizableContentsCollection::ignoreRestrictions).orElse(false).booleanValue()) {
            return true;
        }
        return super.canWriteModelItem(modelItem, content, transientVars);
    }

    public I18nizableText getLabel() {
        return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_EDIT_CONTENT_FUNCTION_LABEL");
    }
}

