/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Singleton to override reference tables and add import function
 * @private
 */
Ext.define('Ametys.plugins.contentio.ReferenceTableActions',{
    singleton: true,
    
    /**
     * This action imports simple contents from a CSV file
     * @param {Ametys.ribbon.element.ui.ButtonController} controller The controller calling this function
     */
    importCSV: function (controller)
    {
        var tool = Ametys.tool.ToolsManager.getFocusedTool();
        
        var toolParams = {
            "content-type": tool.contentTypeId,
            "content-language": tool.contentLanguage,
            "create-action": tool.workflowInitActionId,
            "edit-action": tool.workflowEditActionId,
            "workflow-name": tool.workflowName
        };
        
        var config = Ext.apply(controller.getInitialConfig(), toolParams);
        config.serverRole = "org.ametys.plugins.contentio.csv.ImportReferenceTablesCSVFile";
        config.helperServerRole = "org.ametys.plugins.contentio.csv.ImportReferenceTablesCSVFileHelper";
        
        Ametys.plugins.contentio.ImportCSVActions.open(config);
        
    }
});