/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ametys.core.util.JSONUtils;
import org.ametys.plugins.contentio.synchronize.AbstractSimpleSynchronizableContentsCollection;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public abstract class AbstractDataSourceSynchronizableContentsCollection
extends AbstractSimpleSynchronizableContentsCollection {
    protected static final String __PARAM_DATASOURCE_ID = "datasourceId";
    protected static final String __PARAM_FIELD_ID = "idField";
    protected static final String __PARAM_MAPPING = "mapping";
    protected static final String __PARAM_MAPPING_SYNCHRO = "synchro";
    protected static final String __PARAM_MAPPING_METADATA_REF = "metadata-ref";
    protected static final String __PARAM_MAPPING_ATTRIBUTE = "attribute";
    protected JSONUtils _jsonUtils;
    protected Map<String, List<String>> _mapping;
    protected Set<String> _columnsAndCriteria;
    protected Set<String> _syncFields;

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._jsonUtils = (JSONUtils)smanager.lookup(JSONUtils.ROLE);
    }

    @Override
    public String getIdField() {
        return (String)this.getParameterValues().get(__PARAM_FIELD_ID);
    }

    public String getDataSourceId() {
        return (String)this.getParameterValues().get(__PARAM_DATASOURCE_ID);
    }

    @Override
    protected void configureDataSource(Configuration configuration) throws ConfigurationException {
        this._mapping = new HashMap<String, List<String>>();
        this._columnsAndCriteria = new TreeSet<String>();
        this._syncFields = new HashSet<String>();
        String mappingAsString = (String)this.getParameterValues().get(__PARAM_MAPPING);
        if (StringUtils.isNotEmpty((CharSequence)mappingAsString)) {
            List mappingAsList = this._jsonUtils.convertJsonToList(mappingAsString);
            for (Object object : mappingAsList) {
                Map field = (Map)object;
                String metadataRef = (String)field.get(__PARAM_MAPPING_METADATA_REF);
                String[] mappingAttributes = ((String)field.get(__PARAM_MAPPING_ATTRIBUTE)).split(",");
                List attributes = Stream.of(mappingAttributes).map(String::trim).collect(Collectors.toList());
                this._mapping.put(metadataRef, attributes);
                for (String attribute : attributes) {
                    this._columnsAndCriteria.add(attribute);
                }
                boolean isSynchronized = field.containsKey(__PARAM_MAPPING_SYNCHRO) ? (Boolean)field.get(__PARAM_MAPPING_SYNCHRO) : false;
                if (!isSynchronized) continue;
                this._syncFields.add(metadataRef);
            }
        }
    }

    @Override
    protected void configureSearchModel() {
        for (String columnOrCriteria : this._columnsAndCriteria) {
            this._searchModelConfiguration.addCriterion(columnOrCriteria);
            this._searchModelConfiguration.addColumn(columnOrCriteria);
        }
    }

    @Override
    public Set<String> getLocalAndExternalFields(Map<String, Object> additionalParameters) {
        return this._syncFields;
    }

    public Map<String, List<String>> getMapping() {
        return this._mapping;
    }

    @Override
    protected Map<String, Object> putIdParameter(String idValue) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        List<String> remoteKeys = this.getMapping().get(this.getIdField());
        if (remoteKeys != null && remoteKeys.size() > 0) {
            parameters.put(remoteKeys.get(0), idValue);
        }
        return parameters;
    }

    @Override
    protected Map<String, Map<String, List<Object>>> getRemoteValues(Map<String, Object> searchParameters, Logger logger) {
        Map<String, Map<String, Object>> results = this.internalSearch(searchParameters, 0, Integer.MAX_VALUE, null, logger);
        return this._sccHelper.organizeRemoteValuesByAttribute(results, this.getMapping());
    }
}

