/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ametys.plugins.contentio.synchronize.impl.AbstractDataSourceSynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.impl.LDAPCollectionHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class LDAPSynchronizableContentsCollection
extends AbstractDataSourceSynchronizableContentsCollection
implements Component {
    private static final String __PARAM_LDAP_SCOPE = "scope";
    private static final String __PARAM_LDAP_RELATIVE_DN = "peopleDN";
    private static final String __PARAM_LDAP_FILTER = "baseFilter";
    protected LDAPCollectionHelper _ldapHelper;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._ldapHelper = (LDAPCollectionHelper)((Object)serviceManager.lookup(LDAPCollectionHelper.ROLE));
    }

    @Override
    protected Map<String, Map<String, Object>> internalSearch(Map<String, Object> searchParameters, int offset, int limit, List<Object> sort, Logger logger) {
        Map<String, List<String>> mapping = this.getMapping();
        Map<String, Map<String, Object>> searchResults = new HashMap<String, Map<String, Object>>();
        String idField = this.getIdField();
        List<String> remoteKeys = mapping.get(idField);
        if (remoteKeys != null && remoteKeys.size() > 0) {
            Object filtersReduced;
            String filter = this.getFilter();
            ArrayList<Object> filters = new ArrayList<Object>();
            if (StringUtils.isNotEmpty((CharSequence)filter)) {
                filters.add(filter);
            }
            if (searchParameters != null) {
                for (String parameterName : searchParameters.keySet()) {
                    filters.add(parameterName + "=" + String.valueOf(searchParameters.get(parameterName)));
                }
            }
            if (!((String)(filtersReduced = filters.stream().filter(StringUtils::isNotEmpty).map(s -> "(" + s + ")").reduce("", (s1, s2) -> s1 + s2))).isEmpty()) {
                filtersReduced = "(&" + (String)filtersReduced + ")";
            }
            try {
                LDAPCollectionHelper.LDAPCollectionHelperSearchResult results = this._ldapHelper.search(this.getId(), this.getRelativeDN(), (String)filtersReduced, this.getSearchScope(), offset, limit, mapping, remoteKeys.get(0), logger, this.getDataSourceId());
                searchResults = results.searchResults();
                Iterator<Map<String, Object>> iterator = searchResults.values().iterator();
                while (iterator.hasNext()) {
                    Map<String, Object> result;
                    Object sccValues = (result = iterator.next()).get(remoteKeys.get(0));
                    result.put("scc$uniqueid", sccValues instanceof List ? ((List)sccValues).get(0) : sccValues);
                }
                this._nbError = results.nbErrors();
                this._hasGlobalError = results.hasGlobalError();
            }
            catch (Exception e) {
                throw new RuntimeException("An error occured when importing from LDAP UserDirectory", e);
            }
        } else {
            this._nbError = 1;
            logger.error("Missing LDAP attribute in mapping for field '{}' holding the unique identifier", (Object)idField);
        }
        return searchResults;
    }

    protected String getSearchScope() {
        return (String)this.getParameterValues().get(__PARAM_LDAP_SCOPE);
    }

    protected String getFilter() {
        return (String)this.getParameterValues().get(__PARAM_LDAP_FILTER);
    }

    protected String getRelativeDN() {
        return (String)this.getParameterValues().get(__PARAM_LDAP_RELATIVE_DN);
    }

    @Override
    protected void configureSearchModel() {
        for (String columnOrCriteria : this._columnsAndCriteria) {
            this._searchModelConfiguration.addCriterion(columnOrCriteria);
            this._searchModelConfiguration.addColumn(columnOrCriteria, new I18nizableText(columnOrCriteria), false);
        }
    }

    @Override
    protected Map<String, Map<String, List<Object>>> getRemoteValues(Map<String, Object> searchParameters, Logger logger) {
        Map<String, Map<String, List<Object>>> organizedResults = super.getRemoteValues(searchParameters, logger);
        this._ldapHelper.transformTypedAttributes(organizedResults, this.getContentType(), this.getMapping().keySet());
        return organizedResults;
    }
}

