/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize.workflow;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.workflow.CreateContentFunction;
import org.ametys.plugins.contentio.synchronize.rights.SynchronizedRootContentHelper;
import org.ametys.plugins.repository.ModifiableTraversableAmetysObject;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.workflow.WorkflowException;

/**
 * OSWorkflow function to import a content
 */
public class CreateSynchronizedContentFunction extends CreateContentFunction
{
    private SynchronizedRootContentHelper _synchronizedRootContentHelper;
    
    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        super.service(manager);
        _synchronizedRootContentHelper = (SynchronizedRootContentHelper) manager.lookup(SynchronizedRootContentHelper.ROLE);
    }
    
    @Override
    protected ModifiableTraversableAmetysObject _getContentRoot(Map transientVars) throws WorkflowException
    {
        return _synchronizedRootContentHelper.getRootContent(true);
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CREATE_SYNCHRONIZE_CONTENT_FUNCTION_LABEL");
    }
}
