/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.synchronize.workflow;

import java.util.Map;

import org.ametys.cms.workflow.CreateVersionFunction;
import org.ametys.runtime.i18n.I18nizableText;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.WorkflowException;

/**
 * Workflow function creating a new content version for synchronized contents.
 */
public class CreateSynchronizedVersionFunction extends CreateVersionFunction
{
    @Override
    public void execute(Map transientVars, Map args, PropertySet ps) throws WorkflowException
    {
        if ((boolean) getResultsMap(transientVars).getOrDefault(HAS_CHANGED_KEY, true))
        {
            super.execute(transientVars, args, ps);
        }
    }
    
    @Override
    public I18nizableText getLabel()
    {
        return new I18nizableText("plugin.contentio", "PLUGINS_CONTENTIO_CREATE_SYNCHRONIZED_VERSION_FUNCTION_LABEL");
    }
}
