/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeDescriptor;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.languages.Language;
import org.ametys.cms.languages.LanguagesManager;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.LDAPDataSourceManager;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.core.ui.Callable;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionModel;
import org.ametys.plugins.contentio.synchronize.SynchronizeContentsCollectionModelExtensionPoint;
import org.ametys.plugins.contentio.synchronize.SynchronizingContentOperator;
import org.ametys.plugins.contentio.synchronize.SynchronizingContentOperatorExtensionPoint;
import org.ametys.plugins.contentio.synchronize.impl.DefaultSynchronizingContentOperator;
import org.ametys.plugins.workflow.support.WorkflowHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.LogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SynchronizableContentsCollectionDAO
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable,
Contextualizable,
Disposable {
    public static final String ROLE = SynchronizableContentsCollectionDAO.class.getName();
    public static final String SCC_PARAMETERS_SEPARATOR = "$";
    private static File __CONFIGURATION_FILE;
    private Map<String, SynchronizableContentsCollection> _synchronizableCollections;
    private long _lastFileReading;
    private SynchronizeContentsCollectionModelExtensionPoint _syncCollectionModelEP;
    private ContentTypeExtensionPoint _contentTypeEP;
    private WorkflowHelper _workflowHelper;
    private SynchronizingContentOperatorExtensionPoint _synchronizingContentOperatorEP;
    private LanguagesManager _languagesManager;
    private ServiceManager _smanager;
    private Context _context;
    private SQLDataSourceManager _sqlDataSourceManager;
    private LDAPDataSourceManager _ldapDataSourceManager;

    public void initialize() throws Exception {
        __CONFIGURATION_FILE = new File(AmetysHomeHelper.getAmetysHome(), "config" + File.separator + "synchronizable-collections.xml");
        this._synchronizableCollections = new HashMap<String, SynchronizableContentsCollection>();
        this._lastFileReading = 0L;
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._smanager = smanager;
        this._syncCollectionModelEP = (SynchronizeContentsCollectionModelExtensionPoint)((Object)smanager.lookup(SynchronizeContentsCollectionModelExtensionPoint.ROLE));
        this._contentTypeEP = (ContentTypeExtensionPoint)smanager.lookup(ContentTypeExtensionPoint.ROLE);
        this._workflowHelper = (WorkflowHelper)smanager.lookup(WorkflowHelper.ROLE);
        this._synchronizingContentOperatorEP = (SynchronizingContentOperatorExtensionPoint)((Object)smanager.lookup(SynchronizingContentOperatorExtensionPoint.ROLE));
        this._languagesManager = (LanguagesManager)smanager.lookup(LanguagesManager.ROLE);
    }

    private SQLDataSourceManager _getSQLDataSourceManager() {
        if (this._sqlDataSourceManager == null) {
            try {
                this._sqlDataSourceManager = (SQLDataSourceManager)this._smanager.lookup(SQLDataSourceManager.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._sqlDataSourceManager;
    }

    private LDAPDataSourceManager _getLDAPDataSourceManager() {
        if (this._ldapDataSourceManager == null) {
            try {
                this._ldapDataSourceManager = (LDAPDataSourceManager)this._smanager.lookup(LDAPDataSourceManager.ROLE);
            }
            catch (ServiceException e) {
                throw new RuntimeException(e);
            }
        }
        return this._ldapDataSourceManager;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getSynchronizableContentsCollectionAsJson(String collectionId) {
        return this.getSynchronizableContentsCollectionAsJson(this.getSynchronizableContentsCollection(collectionId));
    }

    public Map<String, Object> getSynchronizableContentsCollectionAsJson(SynchronizableContentsCollection collection) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("id", collection.getId());
        result.put("label", collection.getLabel());
        String cTypeId = collection.getContentType();
        result.put("contentTypeId", cTypeId);
        ContentType cType = (ContentType)this._contentTypeEP.getExtension(cTypeId);
        result.put("contentType", cType != null ? cType.getLabel() : cTypeId);
        String modelId = collection.getSynchronizeCollectionModelId();
        result.put("modelId", modelId);
        SynchronizableContentsCollectionModel model = (SynchronizableContentsCollectionModel)this._syncCollectionModelEP.getExtension(modelId);
        result.put("model", model.getLabel());
        result.put("isValid", this._isValid(collection));
        return result;
    }

    public List<SynchronizableContentsCollection> getSynchronizableContentsCollections() {
        this.getLogger().debug("Calling #getSynchronizableContentsCollections()");
        this._readFile(false);
        ArrayList<SynchronizableContentsCollection> cols = new ArrayList<SynchronizableContentsCollection>(this._synchronizableCollections.values());
        this.getLogger().debug("#getSynchronizableContentsCollections() returns '{}'", cols);
        return cols;
    }

    public SynchronizableContentsCollection getSynchronizableContentsCollection(String collectionId) {
        this.getLogger().debug("Calling #getSynchronizableContentsCollection(String collectionId) with collectionId '{}'", (Object)collectionId);
        this._readFile(false);
        SynchronizableContentsCollection col = this._synchronizableCollections.get(collectionId);
        this.getLogger().debug("#getSynchronizableContentsCollection(String collectionId) with collectionId '{}' returns '{}'", (Object)collectionId, (Object)col);
        return col;
    }

    private void _readFile(boolean forceRead) {
        try {
            if (!__CONFIGURATION_FILE.exists()) {
                this.getLogger().debug("=> SCC file does not exist, it will be created.");
                this._createFile(__CONFIGURATION_FILE);
            } else {
                long cfgFileLastModified = __CONFIGURATION_FILE.lastModified() / 1000L * 1000L;
                boolean outdated = cfgFileLastModified >= this._lastFileReading;
                this.getLogger().debug("=> forceRead: {}", (Object)forceRead);
                this.getLogger().debug("=> The configuration was last modified in (long value): {}", (Object)cfgFileLastModified);
                this.getLogger().debug("=> The '_lastFileReading' fields is equal to (long value): {}", (Object)this._lastFileReading);
                if (forceRead || outdated) {
                    this.getLogger().debug(forceRead ? "=> SCC file will be read (force)" : "=> SCC file was (most likely) updated since the last time it was read ({} >= {}). It will be re-read...", (Object)cfgFileLastModified, (Object)this._lastFileReading);
                    this.getLogger().debug("==> '_synchronizableCollections' map before calling #_readFile(): '{}'", this._synchronizableCollections);
                    this._lastFileReading = Instant.now().truncatedTo(ChronoUnit.SECONDS).toEpochMilli();
                    this._synchronizableCollections = new LinkedHashMap<String, SynchronizableContentsCollection>();
                    Configuration cfg = new DefaultConfigurationBuilder().buildFromFile(__CONFIGURATION_FILE);
                    for (Configuration collectionConfig : cfg.getChildren("collection")) {
                        SynchronizableContentsCollection syncCollection = this._createSynchronizableCollection(collectionConfig);
                        this._synchronizableCollections.put(syncCollection.getId(), syncCollection);
                    }
                    this.getLogger().debug("==> '_synchronizableCollections' map after calling #_readFile(): '{}'", this._synchronizableCollections);
                } else {
                    this.getLogger().debug("=> SCC file will not be re-read, the internal representation is up-to-date.");
                }
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to retrieve synchronizable contents collections from the configuration file {}", (Object)__CONFIGURATION_FILE, (Object)e);
        }
    }

    private void _createFile(File file) throws IOException, TransformerConfigurationException, SAXException {
        file.createNewFile();
        try (FileOutputStream os = new FileOutputStream(file);){
            TransformerHandler th = this._getTransformerHandler(os);
            th.startDocument();
            XMLUtils.createElement((ContentHandler)th, (String)"collections");
            th.endDocument();
        }
    }

    private SynchronizableContentsCollection _createSynchronizableCollection(Configuration collectionConfig) throws ConfigurationException {
        String modelId = collectionConfig.getChild("model").getAttribute("id");
        if (this._syncCollectionModelEP.hasExtension(modelId)) {
            SynchronizableContentsCollectionModel model = (SynchronizableContentsCollectionModel)this._syncCollectionModelEP.getExtension(modelId);
            Class<SynchronizableContentsCollection> synchronizableCollectionClass = model.getSynchronizableCollectionClass();
            SynchronizableContentsCollection synchronizableCollection = null;
            try {
                synchronizableCollection = synchronizableCollectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot instanciate the class " + synchronizableCollectionClass.getCanonicalName() + ". Check that there is a public constructor with no arguments.");
            }
            Logger logger = LoggerFactory.getLogger(synchronizableCollectionClass);
            try {
                if (synchronizableCollection instanceof LogEnabled) {
                    ((LogEnabled)synchronizableCollection).setLogger(logger);
                }
                LifecycleHelper.setupComponent((Object)synchronizableCollection, (org.apache.avalon.framework.logger.Logger)new SLF4JLoggerAdapter(logger), (Context)this._context, (ServiceManager)this._smanager, (Configuration)collectionConfig);
            }
            catch (Exception e) {
                throw new ConfigurationException("The model id '" + modelId + "' is not a valid", (Throwable)e);
            }
            return synchronizableCollection;
        }
        throw new ConfigurationException("The model id '" + modelId + "' is not a valid model for collection '" + String.valueOf(collectionConfig.getChild("id")) + "'", collectionConfig);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getEditionConfiguration() throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList collectionModels = new ArrayList();
        for (String modelId : this._syncCollectionModelEP.getExtensionsIds()) {
            SynchronizableContentsCollectionModel model = (SynchronizableContentsCollectionModel)this._syncCollectionModelEP.getExtension(modelId);
            HashMap<String, Object> modelMap = new HashMap<String, Object>();
            modelMap.put("id", modelId);
            modelMap.put("label", model.getLabel());
            modelMap.put("description", model.getDescription());
            LinkedHashMap<CallSite, Map> params = new LinkedHashMap<CallSite, Map>();
            for (ModelItem param : model.getModelItems()) {
                params.put((CallSite)((Object)(modelId + SCC_PARAMETERS_SEPARATOR + param.getPath())), param.toJSON(DefinitionContext.newInstance().withEdition(true)));
            }
            modelMap.put("parameters", params);
            collectionModels.add(modelMap);
        }
        result.put("models", collectionModels);
        result.put("contentTypes", this._transformToJSONEnumerator(this._contentTypeEP.getExtensionsIds().stream().map(arg_0 -> ((ContentTypeExtensionPoint)this._contentTypeEP).getExtension(arg_0)).filter(this::_isValidContentType), ContentTypeDescriptor::getId, ContentTypeDescriptor::getLabel));
        result.put("languages", this._transformToJSONEnumerator(this._languagesManager.getAvailableLanguages().entrySet().stream(), entry -> (String)entry.getKey(), entry -> ((Language)entry.getValue()).getLabel()));
        result.put("workflows", this._transformToJSONEnumerator(Stream.of(this._workflowHelper.getWorkflowNames()), Function.identity(), id -> this._workflowHelper.getWorkflowLabel(id)));
        result.put("contentOperators", this._transformToJSONEnumerator(this._synchronizingContentOperatorEP.getExtensionsIds().stream(), Function.identity(), id -> ((SynchronizingContentOperator)this._synchronizingContentOperatorEP.getExtension((String)id)).getLabel()));
        result.put("defaultContentOperator", DefaultSynchronizingContentOperator.class.getName());
        result.put("existingSCC", this._transformToJSONEnumerator(this.getSynchronizableContentsCollections().stream(), SynchronizableContentsCollection::getId, SynchronizableContentsCollection::getLabel));
        return result;
    }

    private <T> List<Map<String, Object>> _transformToJSONEnumerator(Stream<T> values, Function<T, String> valueFunction, Function<T, I18nizableText> labelFunction) {
        return values.map(value -> Map.of("value", valueFunction.apply(value), "label", labelFunction.apply(value))).toList();
    }

    private boolean _isValidContentType(ContentType cType) {
        return !cType.isReferenceTable() && !cType.isAbstract() && !cType.isMixin();
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getCollectionParameterValues(String collectionId) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        SynchronizableContentsCollection collection = this.getSynchronizableContentsCollection(collectionId);
        if (collection == null) {
            this.getLogger().error("The collection of id '{}' does not exist.", (Object)collectionId);
            result.put("error", "unknown");
            return result;
        }
        result.put("id", collectionId);
        result.put("label", collection.getLabel());
        String modelId = collection.getSynchronizeCollectionModelId();
        result.put("modelId", modelId);
        result.put("contentType", collection.getContentType());
        result.put("contentPrefix", collection.getContentPrefix());
        result.put("restrictedField", collection.getRestrictedField());
        result.put("synchronizeExistingContentsOnly", collection.synchronizeExistingContentsOnly());
        result.put("removalSync", collection.removalSync());
        result.put("ignoreRestrictions", collection.ignoreRestrictions());
        result.put("checkCollection", collection.checkCollection());
        result.put("compatibleSCC", collection.getCompatibleSCC(false));
        result.put("validateAfterImport", collection.validateAfterImport());
        result.put("workflowName", collection.getWorkflowName());
        result.put("initialActionId", collection.getInitialActionId());
        result.put("synchronizeActionId", collection.getSynchronizeActionId());
        result.put("validateActionId", collection.getValidateActionId());
        result.put("contentOperator", collection.getSynchronizingContentOperator());
        result.put("reportMails", collection.getReportMails());
        result.put("languages", collection.getLanguages());
        Map<String, Object> values = collection.getParameterValues();
        for (String key : values.keySet()) {
            result.put(modelId + SCC_PARAMETERS_SEPARATOR + key, values.get(key));
        }
        return result;
    }

    private boolean _writeFile() {
        boolean errorOccured;
        File backup;
        block9: {
            backup = this._createBackup();
            errorOccured = false;
            try (FileOutputStream os = new FileOutputStream(__CONFIGURATION_FILE);){
                TransformerHandler th = this._getTransformerHandler(os);
                try {
                    th.startDocument();
                    XMLUtils.startElement((ContentHandler)th, (String)"collections");
                    this._toSAX(th);
                    XMLUtils.endElement((ContentHandler)th, (String)"collections");
                    th.endDocument();
                }
                catch (Exception e) {
                    this.getLogger().error("Error when saxing the collections", (Throwable)e);
                    errorOccured = true;
                }
            }
            catch (IOException | TransformerConfigurationException | TransformerFactoryConfigurationError e) {
                if (!this.getLogger().isErrorEnabled()) break block9;
                this.getLogger().error("Error when trying to modify the group directories with the configuration file {}", (Object)__CONFIGURATION_FILE, (Object)e);
            }
        }
        this._restoreBackup(backup, errorOccured);
        return errorOccured;
    }

    private File _createBackup() {
        File backup = new File(__CONFIGURATION_FILE.getPath() + ".tmp");
        try {
            Files.copy(__CONFIGURATION_FILE.toPath(), backup.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            this.getLogger().error("Error when creating backup '{}' file", (Object)__CONFIGURATION_FILE.toPath(), (Object)e);
        }
        return backup;
    }

    private void _restoreBackup(File backup, boolean errorOccured) {
        block3: {
            try {
                if (errorOccured) {
                    Files.copy(backup.toPath(), __CONFIGURATION_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this._readFile(true);
                }
                Files.deleteIfExists(backup.toPath());
            }
            catch (IOException e) {
                if (!this.getLogger().isErrorEnabled()) break block3;
                this.getLogger().error("Error when restoring backup '{}' file", (Object)__CONFIGURATION_FILE, (Object)e);
            }
        }
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public String addCollection(Map<String, Object> values) throws ProcessingException {
        this.getLogger().debug("Add new Collection with values '{}'", values);
        this._readFile(false);
        String id = this._generateUniqueId((String)values.get("label"));
        try {
            this._addCollection(id, values);
            return id;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to add new collection'" + id + "'", (Throwable)e);
        }
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> editCollection(String id, Map<String, Object> values) throws ProcessingException {
        this.getLogger().debug("Edit Collection with id '{}' and values '{}'", (Object)id, values);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        SynchronizableContentsCollection collection = this._synchronizableCollections.get(id);
        if (collection == null) {
            this.getLogger().error("The collection with id '{}' does not exist, it cannot be edited.", (Object)id);
            result.put("error", "unknown");
            return result;
        }
        this._synchronizableCollections.remove(id);
        try {
            this._addCollection(id, values);
            result.put("id", id);
            return result;
        }
        catch (Exception e) {
            throw new ProcessingException("Failed to edit collection of id '" + id + "'", (Throwable)e);
        }
    }

    private boolean _isValid(SynchronizableContentsCollection collection) {
        SynchronizableContentsCollectionModel model = (SynchronizableContentsCollectionModel)this._syncCollectionModelEP.getExtension(collection.getSynchronizeCollectionModelId());
        if (model != null) {
            for (ModelItem param : model.getModelItems()) {
                String dataSourceId;
                if (!this._validateParameter(param, collection)) {
                    return false;
                }
                if (!"datasource".equals(param.getType().getId()) || this._checkDataSource(dataSourceId = (String)collection.getParameterValues().get(param.getPath()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean _validateParameter(ModelItem modelItem, SynchronizableContentsCollection collection) {
        ElementDefinition param;
        Validator validator;
        if (modelItem instanceof ElementDefinition && (validator = (param = (ElementDefinition)modelItem).getValidator()) != null) {
            Object value = collection.getParameterValues().get(param.getPath());
            return !validator.validate(value).hasErrors();
        }
        return true;
    }

    private boolean _checkDataSource(String dataSourceId) {
        block5: {
            if (dataSourceId != null) {
                try {
                    AbstractDataSourceManager.DataSourceDefinition def = this._getSQLDataSourceManager().getDataSourceDefinition(dataSourceId);
                    if (def != null) {
                        this._getSQLDataSourceManager().checkParameters(def.getParameters());
                        break block5;
                    }
                    def = this._getLDAPDataSourceManager().getDataSourceDefinition(dataSourceId);
                    if (def != null) {
                        this._getLDAPDataSourceManager().getDataSourceDefinition(dataSourceId);
                        break block5;
                    }
                    return false;
                }
                catch (ItemCheckerTestFailureException e) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean _addCollection(String id, Map<String, Object> values) throws FileNotFoundException, IOException, TransformerConfigurationException, SAXException {
        File backup = this._createBackup();
        boolean success = false;
        try (FileOutputStream os = new FileOutputStream(__CONFIGURATION_FILE);){
            TransformerHandler th = this._getTransformerHandler(os);
            th.startDocument();
            XMLUtils.startElement((ContentHandler)th, (String)"collections");
            this._toSAX(th);
            this._saxCollection(th, id, values);
            XMLUtils.endElement((ContentHandler)th, (String)"collections");
            th.endDocument();
            success = true;
        }
        this._restoreBackup(backup, !success);
        this._readFile(false);
        return success;
    }

    private TransformerHandler _getTransformerHandler(OutputStream os) throws TransformerConfigurationException {
        TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
        StreamResult result = new StreamResult(os);
        th.setResult(result);
        Properties format = new Properties();
        format.put("method", "xml");
        format.put("indent", "yes");
        format.put("encoding", "UTF-8");
        format.put("{http://xml.apache.org/xalan}indent-amount", "4");
        th.getTransformer().setOutputProperties(format);
        return th;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> removeCollection(String id) {
        this.getLogger().debug("Remove Collection with id '{}'", (Object)id);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this._readFile(false);
        if (this._synchronizableCollections.remove(id) == null) {
            this.getLogger().error("The synchronizable collection with id '{}' does not exist, it cannot be removed.", (Object)id);
            result.put("error", "unknown");
            return result;
        }
        if (this._writeFile()) {
            return null;
        }
        result.put("id", id);
        return result;
    }

    private String _generateUniqueId(String label) {
        String value = label.toLowerCase().trim().replaceAll("[\\W_]", "-").replaceAll("-+", "-").replaceAll("^-", "");
        int i = 2;
        Object suffixedValue = value;
        while (this._synchronizableCollections.get(suffixedValue) != null) {
            suffixedValue = value + i;
            ++i;
        }
        return suffixedValue;
    }

    private void _toSAX(TransformerHandler handler) throws SAXException {
        for (SynchronizableContentsCollection collection : this._synchronizableCollections.values()) {
            this._saxCollection(handler, collection);
        }
    }

    private void _saxCollection(ContentHandler handler, String id, Map<String, Object> parameters) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", id);
        XMLUtils.startElement((ContentHandler)handler, (String)"collection", (Attributes)atts);
        String label = (String)parameters.get("label");
        if (label != null) {
            new I18nizableText(label).toSAX(handler, "label");
        }
        this._saxNonNullValue(handler, "contentType", parameters.get("contentType"));
        this._saxNonNullValue(handler, "contentPrefix", parameters.get("contentPrefix"));
        this._saxNonNullValue(handler, "restrictedField", parameters.get("restrictedField"));
        this._saxNonNullValue(handler, "synchronizeExistingContentsOnly", parameters.get("synchronizeExistingContentsOnly"));
        this._saxNonNullValue(handler, "removalSync", parameters.get("removalSync"));
        this._saxNonNullValue(handler, "ignoreRestrictions", parameters.get("ignoreRestrictions"));
        this._saxNonNullValue(handler, "checkCollection", parameters.get("checkCollection"));
        this._saxMultipleValues(handler, "compatibleSCC", parameters.get("compatibleSCC"));
        this._saxNonNullValue(handler, "workflowName", parameters.get("workflowName"));
        this._saxNonNullValue(handler, "initialActionId", parameters.get("initialActionId"));
        this._saxNonNullValue(handler, "synchronizeActionId", parameters.get("synchronizeActionId"));
        this._saxNonNullValue(handler, "validateActionId", parameters.get("validateActionId"));
        this._saxNonNullValue(handler, "validateAfterImport", parameters.get("validateAfterImport"));
        this._saxNonNullValue(handler, "reportMails", parameters.get("reportMails"));
        this._saxNonNullValue(handler, "contentOperator", parameters.get("contentOperator"));
        this._saxMultipleValues(handler, "languages", parameters.get("languages"));
        String modelId = (String)parameters.get("modelId");
        this._saxModel(handler, modelId, parameters, true);
        XMLUtils.endElement((ContentHandler)handler, (String)"collection");
    }

    private void _saxMultipleValues(ContentHandler handler, String tagName, Object values) throws SAXException {
        if (values != null) {
            XMLUtils.startElement((ContentHandler)handler, (String)tagName);
            for (String lang : (List)values) {
                XMLUtils.createElement((ContentHandler)handler, (String)"value", (String)lang);
            }
            XMLUtils.endElement((ContentHandler)handler, (String)tagName);
        }
    }

    private void _saxCollection(ContentHandler handler, SynchronizableContentsCollection collection) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", collection.getId());
        XMLUtils.startElement((ContentHandler)handler, (String)"collection", (Attributes)atts);
        collection.getLabel().toSAX(handler, "label");
        this._saxNonNullValue(handler, "contentType", collection.getContentType());
        this._saxNonNullValue(handler, "contentPrefix", collection.getContentPrefix());
        this._saxNonNullValue(handler, "restrictedField", collection.getRestrictedField());
        this._saxNonNullValue(handler, "workflowName", collection.getWorkflowName());
        this._saxNonNullValue(handler, "initialActionId", collection.getInitialActionId());
        this._saxNonNullValue(handler, "synchronizeActionId", collection.getSynchronizeActionId());
        this._saxNonNullValue(handler, "validateActionId", collection.getValidateActionId());
        this._saxNonNullValue(handler, "validateAfterImport", collection.validateAfterImport());
        this._saxNonNullValue(handler, "reportMails", collection.getReportMails());
        this._saxNonNullValue(handler, "contentOperator", collection.getSynchronizingContentOperator());
        this._saxNonNullValue(handler, "synchronizeExistingContentsOnly", collection.synchronizeExistingContentsOnly());
        this._saxNonNullValue(handler, "removalSync", collection.removalSync());
        this._saxNonNullValue(handler, "ignoreRestrictions", collection.ignoreRestrictions());
        this._saxNonNullValue(handler, "checkCollection", collection.checkCollection());
        this._saxMultipleValues(handler, "compatibleSCC", collection.getCompatibleSCC(false));
        this._saxMultipleValues(handler, "languages", collection.getLanguages());
        this._saxModel(handler, collection.getSynchronizeCollectionModelId(), collection.getParameterValues(), false);
        XMLUtils.endElement((ContentHandler)handler, (String)"collection");
    }

    private void _saxNonNullValue(ContentHandler handler, String tagName, Object value) throws SAXException {
        if (value != null) {
            XMLUtils.createElement((ContentHandler)handler, (String)tagName, (String)value.toString());
        }
    }

    private void _saxModel(ContentHandler handler, String modelId, Map<String, Object> paramValues, boolean withPrefix) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", modelId);
        XMLUtils.startElement((ContentHandler)handler, (String)"model", (Attributes)atts);
        SynchronizableContentsCollectionModel model = (SynchronizableContentsCollectionModel)this._syncCollectionModelEP.getExtension(modelId);
        Object prefix = withPrefix ? modelId + SCC_PARAMETERS_SEPARATOR : "";
        for (ModelItem parameter : model.getModelItems()) {
            String paramFieldName = (String)prefix + parameter.getPath();
            Object value = paramValues.get(paramFieldName);
            if (value == null) continue;
            atts.clear();
            atts.addCDATAAttribute("name", parameter.getPath());
            XMLUtils.createElement((ContentHandler)handler, (String)"param", (Attributes)atts, (String)((ElementDefinition)parameter).getType().toString(value));
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"model");
    }

    public void dispose() {
        this._synchronizableCollections.clear();
        this._lastFileReading = 0L;
    }
}

