/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ametys.cms.contenttype.ContentType;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.ContentDAO;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionHelper;
import org.ametys.plugins.contentio.synchronize.search.SCCSearchModelConfiguration;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.model.CompositeDefinition;
import org.ametys.plugins.repository.model.RepeaterDefinition;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.ModelItemAccessor;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public abstract class AbstractStaticSynchronizableContentsCollection
implements SynchronizableContentsCollection,
Configurable,
Serviceable {
    protected AmetysObjectResolver _resolver;
    protected SynchronizableContentsCollectionHelper _sccHelper;
    protected ContentDAO _contentDAO;
    protected ContentTypeExtensionPoint _contentTypeEP;
    protected String _id;
    protected I18nizableText _label;
    protected String _restrictedField;
    protected String _contentType;
    protected List<String> _languages;
    protected String _modelId;
    protected Map<String, Object> _modelParamValues;
    protected boolean _removalSync;
    protected boolean _ignoreRestrictions;
    protected String _workflowName;
    protected int _initialActionId;
    protected int _synchronizeActionId;
    protected int _validateActionId;
    protected String _contentPrefix;
    protected boolean _validateAfterImport;
    protected String _reportMails;
    protected String _synchronizingContentOperator;
    protected boolean _synchronizeExistingContentsOnly;
    protected boolean _checkCollection;
    protected List<String> _compatibleSCC;
    protected SCCSearchModelConfiguration _searchModelConfiguration;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._sccHelper = (SynchronizableContentsCollectionHelper)((Object)manager.lookup(SynchronizableContentsCollectionHelper.ROLE));
        this._contentDAO = (ContentDAO)manager.lookup(ContentDAO.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configureStaticParams(configuration);
        this.configureDataSource(configuration);
        this._searchModelConfiguration = new SCCSearchModelConfiguration();
        this.configureSearchModel();
    }

    protected void configureStaticParams(Configuration configuration) throws ConfigurationException {
        this._id = configuration.getAttribute("id");
        this._label = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("label"), null);
        this._contentType = configuration.getChild("contentType").getValue();
        this._removalSync = configuration.getChild("removalSync").getValueAsBoolean(false);
        this._ignoreRestrictions = configuration.getChild("ignoreRestrictions").getValueAsBoolean(true);
        this._workflowName = configuration.getChild("workflowName").getValue();
        this._initialActionId = configuration.getChild("initialActionId").getValueAsInteger();
        this._synchronizeActionId = configuration.getChild("synchronizeActionId").getValueAsInteger();
        this._validateActionId = configuration.getChild("validateActionId").getValueAsInteger();
        this._contentPrefix = configuration.getChild("contentPrefix").getValue();
        this._restrictedField = configuration.getChild("restrictedField").getValue(null);
        this._validateAfterImport = configuration.getChild("validateAfterImport").getValueAsBoolean(false);
        this._reportMails = configuration.getChild("reportMails").getValue("");
        this._synchronizingContentOperator = configuration.getChild("contentOperator").getValue();
        this._modelId = configuration.getChild("model").getAttribute("id");
        this._languages = this._parseMultipleValuesConf(configuration.getChild("languages"));
        this._modelParamValues = this._parseParameters(configuration.getChild("model"));
        this._synchronizeExistingContentsOnly = configuration.getChild("synchronizeExistingContentsOnly").getValueAsBoolean(false);
        this._checkCollection = configuration.getChild("checkCollection").getValueAsBoolean(true);
        this._compatibleSCC = this._parseMultipleValuesConf(configuration.getChild("compatibleSCC"));
    }

    protected abstract void configureDataSource(Configuration var1) throws ConfigurationException;

    protected abstract void configureSearchModel();

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public String getContentType() {
        return this._contentType;
    }

    @Override
    public List<String> getLanguages() {
        return this._languages;
    }

    @Override
    public String getRestrictedField() {
        return this._restrictedField;
    }

    @Override
    public String getSynchronizeCollectionModelId() {
        return this._modelId;
    }

    @Override
    public Map<String, Object> getParameterValues() {
        return this._modelParamValues;
    }

    @Override
    public boolean removalSync() {
        return this._removalSync;
    }

    @Override
    public boolean ignoreRestrictions() {
        return this._ignoreRestrictions;
    }

    @Override
    public boolean checkCollection() {
        return this._checkCollection;
    }

    @Override
    public List<String> getCompatibleSCC(boolean includeCurrent) {
        if (includeCurrent) {
            ArrayList<String> compatibleSCC = new ArrayList<String>(this._compatibleSCC);
            compatibleSCC.add(this.getId());
            return compatibleSCC;
        }
        return this._compatibleSCC;
    }

    @Override
    public String getWorkflowName() {
        return this._workflowName;
    }

    @Override
    public int getInitialActionId() {
        return this._initialActionId;
    }

    @Override
    public int getSynchronizeActionId() {
        return this._synchronizeActionId;
    }

    @Override
    public int getValidateActionId() {
        return this._validateActionId;
    }

    @Override
    public String getContentPrefix() {
        return this._contentPrefix;
    }

    @Override
    public boolean validateAfterImport() {
        return this._validateAfterImport;
    }

    @Override
    public String getReportMails() {
        return this._reportMails;
    }

    @Override
    public String getSynchronizingContentOperator() {
        return this._synchronizingContentOperator;
    }

    @Override
    public boolean synchronizeExistingContentsOnly() {
        return this._synchronizeExistingContentsOnly;
    }

    @Override
    public SCCSearchModelConfiguration getSearchModelConfiguration() {
        return this._searchModelConfiguration;
    }

    protected Map<String, Object> _parseParameters(Configuration configuration) throws ConfigurationException {
        Configuration[] params;
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (Configuration paramConfig : params = configuration.getChildren("param")) {
            values.put(paramConfig.getAttribute("name"), paramConfig.getValue(""));
        }
        return values;
    }

    protected List<String> _parseMultipleValuesConf(Configuration configuration) throws ConfigurationException {
        ArrayList<String> values = new ArrayList<String>();
        for (Configuration conf : configuration.getChildren("value")) {
            values.add(conf.getValue());
        }
        return values;
    }

    protected Map<String, Object> _transformRemoteValuesCardinality(Map<String, List<Object>> remoteValues, String contentTypeId) {
        ContentType contentType = (ContentType)this._contentTypeEP.getExtension(contentTypeId);
        return this._transformRemoteValuesCardinality(remoteValues, (ModelItemAccessor)contentType);
    }

    private Map<String, Object> _transformRemoteValuesCardinality(Map<String, List<Object>> remoteValues, ModelItemAccessor modelItemAccessor) {
        HashMap<String, Object> transformedContentValues = new HashMap<String, Object>();
        for (String attributeName : remoteValues.keySet()) {
            ElementDefinition definition;
            List<Object> attributeValues;
            if (!modelItemAccessor.hasModelItem(attributeName)) continue;
            List<Object> transformedAttributeValue = attributeValues = remoteValues.get(attributeName);
            ModelItem modelItem = modelItemAccessor.getModelItem(attributeName);
            if (modelItem instanceof ElementDefinition && !(definition = (ElementDefinition)modelItem).isMultiple()) {
                transformedAttributeValue = attributeValues.stream().filter(Objects::nonNull).findFirst().orElse(null);
            } else if (modelItem instanceof CompositeDefinition) {
                CompositeDefinition composite = (CompositeDefinition)modelItem;
                transformedAttributeValue = attributeValues.stream().filter(Objects::nonNull).findFirst().map(object -> (Map)object).map(values -> this._transformRemoteValuesCardinality((Map<String, List<Object>>)values, (ModelItemAccessor)composite)).orElse(null);
            } else if (modelItem instanceof RepeaterDefinition) {
                RepeaterDefinition repeater = (RepeaterDefinition)modelItem;
                transformedAttributeValue = attributeValues.stream().filter(Objects::nonNull).map(object -> (Map)object).map(values -> this._transformRemoteValuesCardinality((Map<String, List<Object>>)values, (ModelItemAccessor)repeater)).toList();
            }
            transformedContentValues.put(attributeName, transformedAttributeValue);
        }
        return transformedContentValues;
    }
}

