/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.synchronize.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollection;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionModel;
import org.ametys.plugins.contentio.synchronize.SynchronizableContentsCollectionModelParameterParser;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.ametys.runtime.model.type.ModelItemTypeExtensionPoint;
import org.ametys.runtime.parameter.Validator;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.ametys.runtime.plugin.component.ThreadSafeComponentManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class DefaultSynchronizableContentsCollectionModel
extends AbstractLogEnabled
implements SynchronizableContentsCollectionModel,
Serviceable,
Contextualizable,
PluginAware,
Configurable,
Disposable {
    private ModelItemTypeExtensionPoint _sccParameterTypeExtensionPoint;
    private ServiceManager _manager;
    private Context _context;
    private ThreadSafeComponentManager<DisableConditions> _disableConditionsManager;
    private ThreadSafeComponentManager<Validator> _validatorManager;
    private ThreadSafeComponentManager<Enumerator> _enumeratorManager;
    private String _id;
    private Class<SynchronizableContentsCollection> _syncCollectionClass;
    private I18nizableText _label;
    private I18nizableText _description;
    private Map<String, ModelItem> _parameters = new LinkedHashMap<String, ModelItem>();
    private String _pluginName;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._sccParameterTypeExtensionPoint = (ModelItemTypeExtensionPoint)manager.lookup(ModelItemTypeExtensionPoint.ROLE_CONFIG);
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._pluginName = pluginName;
        this._id = id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._label = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("label"), (String)("plugin." + this._pluginName));
        this._description = I18nizableText.parseI18nizableText((Configuration)configuration.getChild("description"), (String)("plugin." + this._pluginName));
        String className = null;
        try {
            className = configuration.getChild("class").getAttribute("name");
            this._syncCollectionClass = Class.forName(className);
        }
        catch (ClassNotFoundException | ConfigurationException e) {
            throw new ConfigurationException("SynchronizableContentsCollection model with id '" + this._id + "' has an invalid configuration for class name " + (String)(className != null ? className + " <class not found>" : "<missing tag <class>") + "'", e);
        }
        if (!SynchronizableContentsCollection.class.isAssignableFrom(this._syncCollectionClass)) {
            throw new ConfigurationException("SynchronizableContentsCollection model with id '" + this._id + "' has an invalid configuration: '" + className + "' is not an instance of SynchronizableContentsCollection");
        }
        this.configureParameters(configuration);
    }

    protected void configureParameters(Configuration configuration) throws ConfigurationException {
        Configuration[] paramsConfiguration;
        this._disableConditionsManager = new ThreadSafeComponentManager();
        this._disableConditionsManager.setLogger(this.getLogger());
        this._disableConditionsManager.contextualize(this._context);
        this._disableConditionsManager.service(this._manager);
        this._validatorManager = new ThreadSafeComponentManager();
        this._validatorManager.setLogger(this.getLogger());
        this._validatorManager.contextualize(this._context);
        this._validatorManager.service(this._manager);
        this._enumeratorManager = new ThreadSafeComponentManager();
        this._enumeratorManager.setLogger(this.getLogger());
        this._enumeratorManager.contextualize(this._context);
        this._enumeratorManager.service(this._manager);
        SynchronizableContentsCollectionModelParameterParser sccParametersParser = new SynchronizableContentsCollectionModelParameterParser(this._sccParameterTypeExtensionPoint, this._disableConditionsManager, this._enumeratorManager, this._validatorManager);
        Configuration parametersConfiguration = configuration.getChild("parameters");
        for (Configuration paramConfiguration : paramsConfiguration = parametersConfiguration.getChildren("param")) {
            ModelItem parameter = sccParametersParser.parse(this._manager, this._pluginName, "plugin." + this._pluginName, paramConfiguration, this, null);
            String parameterPath = parameter.getPath();
            if (this._parameters.containsKey(parameterPath)) {
                throw new ConfigurationException("The parameter '" + parameterPath + "' is already declared. IDs must be unique.", paramConfiguration);
            }
            this._parameters.put(parameterPath, parameter);
        }
        try {
            sccParametersParser.lookupComponents();
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to lookup parameter local components", configuration, (Throwable)e);
        }
    }

    public void dispose() {
        this._disableConditionsManager.dispose();
        this._disableConditionsManager = null;
        this._validatorManager.dispose();
        this._validatorManager = null;
        this._enumeratorManager.dispose();
        this._enumeratorManager = null;
    }

    public String getId() {
        return this._id;
    }

    @Override
    public I18nizableText getLabel() {
        return this._label;
    }

    @Override
    public I18nizableText getDescription() {
        return this._description;
    }

    public Collection<ModelItem> getModelItems() {
        return this._parameters.values();
    }

    @Override
    public String getPluginName() {
        return this._pluginName;
    }

    @Override
    public Class<SynchronizableContentsCollection> getSynchronizableCollectionClass() {
        return this._syncCollectionClass;
    }
}

