/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.plugins.contentio.archive;

import com.opensymphony.workflow.WorkflowException;
import com.opensymphony.workflow.spi.Step;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.cms.content.references.OutgoingReferencesExtractor;
import org.ametys.cms.contenttype.ContentTypeExtensionPoint;
import org.ametys.cms.repository.Content;
import org.ametys.cms.repository.DefaultContent;
import org.ametys.cms.repository.ModifiableContent;
import org.ametys.cms.repository.ModifiableContentHelper;
import org.ametys.cms.repository.WorkflowAwareContent;
import org.ametys.cms.repository.WorkflowAwareContentHelper;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.util.DateUtils;
import org.ametys.plugins.contentio.archive.Archivers;
import org.ametys.plugins.contentio.archive.DomNodeHelper;
import org.ametys.plugins.contentio.archive.ImportGlobalFailException;
import org.ametys.plugins.contentio.archive.ImportReport;
import org.ametys.plugins.contentio.archive.Merger;
import org.ametys.plugins.contentio.archive.ResourcesAdditionalDataGetter;
import org.ametys.plugins.contentio.archive.ResourcesArchiverHelper;
import org.ametys.plugins.contentio.archive.UnitaryImporter;
import org.ametys.plugins.contentio.archive.ZipEntryHelper;
import org.ametys.plugins.repository.AmetysObjectIterable;
import org.ametys.plugins.repository.AmetysObjectResolver;
import org.ametys.plugins.repository.TraversableAmetysObject;
import org.ametys.plugins.repository.collection.AmetysObjectCollection;
import org.ametys.plugins.repository.data.extractor.xml.XMLValuesExtractorAdditionalDataGetter;
import org.ametys.plugins.repository.data.holder.ModelAwareDataHolder;
import org.ametys.plugins.repository.jcr.JCRAmetysObject;
import org.ametys.plugins.repository.jcr.NodeHelper;
import org.ametys.plugins.repository.version.VersionableAmetysObject;
import org.ametys.plugins.workflow.repository.WorkflowAwareAmetysObject;
import org.ametys.plugins.workflow.support.WorkflowProvider;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ContentsArchiverHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = ContentsArchiverHelper.class.getName();
    private static final String __CONTENT_ZIP_ENTRY_FILENAME = "content.xml";
    private static final String __ACL_ZIP_ENTRY_FILENAME = "_acl.xml";
    private AmetysObjectResolver _resolver;
    private ResourcesArchiverHelper _resourcesArchiverHelper;
    private WorkflowProvider _workflowProvider;
    private ModifiableContentHelper _modifiableContentHelper;
    private OutgoingReferencesExtractor _outgoingReferencesExtractor;
    private ContentTypeExtensionPoint _contentTypeEP;

    public void service(ServiceManager manager) throws ServiceException {
        this._resolver = (AmetysObjectResolver)manager.lookup(AmetysObjectResolver.ROLE);
        this._resourcesArchiverHelper = (ResourcesArchiverHelper)((Object)manager.lookup(ResourcesArchiverHelper.ROLE));
        this._workflowProvider = (WorkflowProvider)manager.lookup(WorkflowProvider.ROLE);
        this._modifiableContentHelper = (ModifiableContentHelper)manager.lookup(ModifiableContentHelper.ROLE);
        this._outgoingReferencesExtractor = (OutgoingReferencesExtractor)manager.lookup(OutgoingReferencesExtractor.ROLE);
        this._contentTypeEP = (ContentTypeExtensionPoint)manager.lookup(ContentTypeExtensionPoint.ROLE);
    }

    public void exportContents(String prefix, Node rootNode, ZipOutputStream zos) throws RepositoryException, IOException {
        TraversableAmetysObject rootContents = (TraversableAmetysObject)this._resolver.resolve(rootNode, false);
        this.exportContents(prefix, rootContents, zos);
    }

    public void exportContents(String prefix, TraversableAmetysObject rootContents, ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry(StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0])));
        AmetysObjectIterable contents = rootContents.getChildren();
        for (Content content : contents) {
            try {
                this._exportContent(prefix, content, zos);
            }
            catch (Exception e) {
                throw new RuntimeException("An error occured while exporting content '" + content.getId() + "'.", e);
            }
        }
        try {
            Node contentNode = ((JCRAmetysObject)rootContents).getNode();
            Archivers.exportAcl(contentNode, zos, prefix + __ACL_ZIP_ENTRY_FILENAME);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to SAX ACL for root contents at '" + rootContents.getPath() + "' for archiving", e);
        }
    }

    private void _exportContent(String prefix, Content content, ZipOutputStream zos) throws IOException {
        List unexistingContentTypesAndMixins = Stream.of(content.getTypes(), content.getMixinTypes()).flatMap(Stream::of).filter(Predicate.not(arg_0 -> ((ContentTypeExtensionPoint)this._contentTypeEP).hasExtension(arg_0))).collect(Collectors.toList());
        if (!unexistingContentTypesAndMixins.isEmpty()) {
            this.getLogger().error("Content \"{}\" will not be exported as at least one of its types or mixins does not exist: {}", (Object)content, unexistingContentTypesAndMixins);
            return;
        }
        String name = content.getName();
        String path = prefix + NodeHelper.getFullHashPath((String)name) + "/";
        ZipEntry contentEntry = new ZipEntry(path + __CONTENT_ZIP_ENTRY_FILENAME);
        zos.putNextEntry(contentEntry);
        try {
            TransformerHandler contentHandler = Archivers.newTransformerHandler();
            contentHandler.setResult(new StreamResult(zos));
            contentHandler.startDocument();
            content.toSAX((ContentHandler)contentHandler, null, null, true);
            contentHandler.endDocument();
        }
        catch (TransformerConfigurationException | SAXException e) {
            throw new RuntimeException("Unable to SAX content '" + content.getPath() + "' for archiving", e);
        }
        this._resourcesArchiverHelper.exportCollection(content.getRootAttachments(), zos, path + "_attachments/");
        Archivers.exportRichTexts((ModelAwareDataHolder)content, zos, path);
        Archivers.exportBinaries((ModelAwareDataHolder)content, zos, path);
        Archivers.exportFiles((ModelAwareDataHolder)content, zos, path);
        try {
            Node contentNode = ((JCRAmetysObject)content).getNode();
            Archivers.exportAcl(contentNode, zos, path + __ACL_ZIP_ENTRY_FILENAME);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to SAX ACL for content '" + content.getPath() + "' for archiving", e);
        }
    }

    public ImportReport importContents(String commonPrefix, AmetysObjectCollection rootContents, Path zipPath, Merger merger, Collection<ContentFiller> contentFillers) throws IOException {
        List<DefaultContent> createdContents;
        Importer importer;
        try {
            importer = new Importer(commonPrefix, rootContents, zipPath, merger, contentFillers, this.getLogger());
            createdContents = importer.importRoot();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        this._saveContents(rootContents);
        this._checkoutContents(createdContents);
        return importer._report;
    }

    private void _saveContents(AmetysObjectCollection rootContents) {
        if (rootContents.needsSave()) {
            this.getLogger().warn("{} still has pending changes while we should have saved unitarily every object. Another save will be done, but it is not normal.", (Object)rootContents);
            rootContents.saveChanges();
        }
    }

    private void _checkoutContents(List<DefaultContent> createdContents) {
        for (DefaultContent createdContent : createdContents) {
            createdContent.checkpoint();
        }
    }

    private class Importer {
        final ImportReport _report = new ImportReport();
        private final String _commonPrefix;
        private final AmetysObjectCollection _root;
        private final Path _zipArchivePath;
        private final Merger _merger;
        private final Collection<ContentFiller> _contentFillers;
        private final Logger _logger;
        private final DocumentBuilder _builder;
        private final UnitaryContentImporter _unitaryImporter = new UnitaryContentImporter();

        Importer(String commonPrefix, AmetysObjectCollection root, Path zipArchivePath, Merger merger, Collection<ContentFiller> contentFillers, Logger logger) throws ParserConfigurationException {
            this._commonPrefix = commonPrefix;
            this._root = root;
            this._zipArchivePath = zipArchivePath;
            this._merger = merger;
            this._contentFillers = contentFillers;
            this._logger = logger;
            this._builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }

        List<DefaultContent> importRoot() throws IOException {
            this._fillRoot();
            try (Stream<Path> zippedFiles = this._matchingZippedFiles();){
                ArrayList<DefaultContent> createdContents = new ArrayList<DefaultContent>();
                for (Path zipEntryPath : (Path[])zippedFiles.toArray(Path[]::new)) {
                    Optional<DefaultContent> createdContent = this._importContent(zipEntryPath);
                    createdContent.ifPresent(createdContents::add);
                }
                ArrayList<DefaultContent> arrayList = createdContents;
                return arrayList;
            }
        }

        private void _fillRoot() throws IOException {
            this._createRootContentAcl();
            try {
                Archivers.unitarySave(this._root.getNode(), this._logger);
            }
            catch (Archivers.AmetysObjectNotImportedException ametysObjectNotImportedException) {
                // empty catch block
            }
        }

        private void _createRootContentAcl() throws IOException {
            Node rootNode = this._root.getNode();
            String zipEntryPath = StringUtils.strip((String)this._commonPrefix, (String)"/") + "/" + ContentsArchiverHelper.__ACL_ZIP_ENTRY_FILENAME;
            this._createAcl(rootNode, zipEntryPath);
        }

        private void _createContentAcl(Node contentNode, Path contentZipEntryPath) throws IOException {
            String zipEntryPath = contentZipEntryPath.getParent().resolve(ContentsArchiverHelper.__ACL_ZIP_ENTRY_FILENAME).toString();
            this._createAcl(contentNode, zipEntryPath);
        }

        private void _createAcl(Node node, String zipAclEntryPath) throws IOException {
            try {
                this._logger.debug("Trying to import ACL node for Content (or root of contents) '{}', from ACL XML file '{}', if it exists", (Object)node, (Object)zipAclEntryPath);
                Archivers.importAcl(node, this._zipArchivePath, this._merger, zipAclEntryPath, this._logger);
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }

        private Stream<Path> _matchingZippedFiles() throws IOException {
            return ZipEntryHelper.zipFileTree(this._zipArchivePath, Optional.of(this._commonPrefix), (p, attrs) -> !attrs.isDirectory() && ContentsArchiverHelper.__CONTENT_ZIP_ENTRY_FILENAME.equals(p.getFileName().toString()));
        }

        private Optional<DefaultContent> _importContent(Path zipEntryPath) throws ImportGlobalFailException {
            return this._unitaryImporter.unitaryImport(this._zipArchivePath, zipEntryPath, this._merger, this._logger);
        }

        private Document _getContentPropertiesXml(Path zipEntryPath) throws SAXException, IOException {
            URI zipEntryUri = zipEntryPath.toUri();
            return this._builder.parse(zipEntryUri.toString());
        }

        private DefaultContent _createContent(Path contentZipEntry, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, Exception {
            String[] contentTypes = this._retrieveContentTypes(contentZipEntry, propertiesXml, "content/contentTypes/contentType");
            String[] mixins = this._retrieveContentTypes(contentZipEntry, propertiesXml, "content/mixins/mixin");
            String uuid = Archivers.xpathEvalNonEmpty("content/@uuid", propertiesXml);
            String contentDesiredName = Archivers.xpathEvalNonEmpty("content/@name", propertiesXml);
            String type = Archivers.xpathEvalNonEmpty("content/@primaryType", propertiesXml);
            this._logger.info("Creating a Content object for '{}' file (uuid={}, type={}, desiredName={})", new Object[]{contentZipEntry, uuid, type, contentDesiredName});
            DefaultContent createdContent = this._createChild(uuid, contentDesiredName, type);
            this._setContentMandatoryProperties(createdContent, contentTypes, mixins, propertiesXml);
            this._fillContentNode(createdContent, propertiesXml, contentZipEntry);
            ImportReport importAttachmentReport = this._fillContentAttachments(createdContent, contentZipEntry);
            this._report.addFrom(importAttachmentReport);
            this._fillAdditionalContentAttributes(createdContent);
            this._setOutgoingReferences(createdContent);
            if (createdContent instanceof WorkflowAwareContent) {
                String workflowName = Archivers.xpathEvalNonEmpty("content/workflow-step/@workflowName", propertiesXml);
                this._handleWorkflow(workflowName, (WorkflowAwareContent)createdContent);
            }
            return createdContent;
        }

        private String[] _retrieveContentTypes(Path contentZipEntry, Document propertiesXml, String xPath) throws TransformerException, Archivers.AmetysObjectNotImportedException {
            String[] contentTypes = DomNodeHelper.stringValues(propertiesXml, xPath);
            List unexistingTypes = Stream.of(contentTypes).filter(Predicate.not(arg_0 -> ((ContentTypeExtensionPoint)ContentsArchiverHelper.this._contentTypeEP).hasExtension(arg_0))).collect(Collectors.toList());
            if (!unexistingTypes.isEmpty()) {
                String message = String.format("Content defined in '%s' has at least one of its types or mixins which does not exist: %s", contentZipEntry, unexistingTypes);
                throw new Archivers.AmetysObjectNotImportedException(message);
            }
            return contentTypes;
        }

        private DefaultContent _createChild(String uuid, String contentDesiredName, String type) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
            String unusedContentName = this._getUnusedContentName(contentDesiredName);
            JCRAmetysObject srcContent = (JCRAmetysObject)this._root.createChild(unusedContentName, type);
            Node srcNode = srcContent.getNode();
            Node nodeWithDesiredUuid = Archivers.replaceNodeWithDesiredUuid(srcNode, uuid);
            String parentPath = this._root.getPath();
            DefaultContent createdContent = (DefaultContent)ContentsArchiverHelper.this._resolver.resolve(parentPath, nodeWithDesiredUuid, null, false);
            return createdContent;
        }

        private String _getUnusedContentName(String desiredName) {
            Object contentName = desiredName;
            int errorCount = 0;
            while (true) {
                if (errorCount != 0) {
                    this._logger.debug("Name '{}' from Content is already used. Trying another one...", contentName);
                    contentName = desiredName + "-" + (errorCount + 1);
                }
                if (!this._root.hasChild((String)contentName)) {
                    this._logger.debug("Content will be created with unused name '{}'. The desired name was '{}'", contentName, (Object)desiredName);
                    return contentName;
                }
                ++errorCount;
            }
        }

        private void _setContentMandatoryProperties(DefaultContent content, String[] contentTypes, String[] mixins, Document propertiesXml) throws TransformerException, Archivers.AmetysObjectNotImportedException {
            content.setTypes(contentTypes);
            content.setMixinTypes(mixins);
            Date creationDate = Objects.requireNonNull(DomNodeHelper.nullableDatetimeValue(propertiesXml, "content/@createdAt"));
            ContentsArchiverHelper.this._modifiableContentHelper.setCreationDate(content, DateUtils.asZonedDateTime((Date)creationDate));
            String creator = Archivers.xpathEvalNonEmpty("content/@creator", propertiesXml);
            ContentsArchiverHelper.this._modifiableContentHelper.setCreator(content, UserIdentity.stringToUserIdentity((String)creator));
            Date lastModifiedAt = Objects.requireNonNull(DomNodeHelper.nullableDatetimeValue(propertiesXml, "content/@lastModifiedAt"));
            ContentsArchiverHelper.this._modifiableContentHelper.setLastModified(content, DateUtils.asZonedDateTime((Date)lastModifiedAt));
            String lastContributor = Archivers.xpathEvalNonEmpty("content/@lastContributor", propertiesXml);
            ContentsArchiverHelper.this._modifiableContentHelper.setLastContributor(content, UserIdentity.stringToUserIdentity((String)lastContributor));
        }

        private void _fillContentNode(DefaultContent content, Document propertiesXml, Path contentZipEntry) throws TransformerException, Exception {
            Date lastValidatedAt;
            String language = DomNodeHelper.nullableStringValue(propertiesXml, "content/@language");
            if (language != null) {
                content.setLanguage(language);
            }
            if ((lastValidatedAt = DomNodeHelper.nullableDatetimeValue(propertiesXml, "content/@lastValidatedAt")) != null) {
                ContentsArchiverHelper.this._modifiableContentHelper.setLastValidationDate(content, DateUtils.asZonedDateTime((Date)lastValidatedAt));
            }
            if (content instanceof ModifiableContent) {
                Path contentPath = contentZipEntry.getParent();
                this._fillContent((ModifiableContent)content, propertiesXml, contentPath);
            }
        }

        private void _fillContent(ModifiableContent content, Document propertiesXml, Path contentZipEntry) throws Exception {
            ResourcesAdditionalDataGetter additionalDataGetter = new ResourcesAdditionalDataGetter(this._zipArchivePath, contentZipEntry);
            content.fillContent((org.w3c.dom.Node)propertiesXml, (XMLValuesExtractorAdditionalDataGetter)additionalDataGetter);
        }

        private ImportReport _fillContentAttachments(DefaultContent createdContent, Path contentZipEntry) throws IOException, RepositoryException {
            Node contentNode = createdContent.getNode();
            if (contentNode.hasNode("ametys-internal:attachments")) {
                contentNode.getNode("ametys-internal:attachments").remove();
            }
            Path contentAttachmentsZipEntryFolder = contentZipEntry.resolveSibling("_attachments/");
            String commonPrefix = StringUtils.appendIfMissing((String)contentAttachmentsZipEntryFolder.toString(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            return ContentsArchiverHelper.this._resourcesArchiverHelper.importCollection(commonPrefix, contentNode, this._zipArchivePath, this._merger);
        }

        private void _fillAdditionalContentAttributes(DefaultContent content) {
            for (ContentFiller contentFiller : this._contentFillers) {
                contentFiller.fillContent(content);
            }
        }

        private void _setOutgoingReferences(DefaultContent content) {
            if (content instanceof ModifiableContent) {
                Map outgoingReferencesByPath = ContentsArchiverHelper.this._outgoingReferencesExtractor.getOutgoingReferences((Content)content);
                ((ModifiableContent)content).setOutgoingReferences(outgoingReferencesByPath);
            }
        }

        private void _handleWorkflow(String workflowName, WorkflowAwareContent createdContent) throws WorkflowException {
            VersionableAmetysObject vao;
            if (createdContent instanceof VersionableAmetysObject && ArrayUtils.contains((Object[])(vao = (VersionableAmetysObject)createdContent).getAllLabels(), (Object)"Live")) {
                vao.removeLabel("Live");
            }
            WorkflowProvider.AmetysObjectWorkflow workflow = ContentsArchiverHelper.this._workflowProvider.getAmetysObjectWorkflow((WorkflowAwareAmetysObject)createdContent);
            int initialAction = 0;
            HashMap inputs = new HashMap(Map.of());
            long workflowId = workflow.initialize(workflowName, initialAction, inputs);
            WorkflowAwareContentHelper.setWorkflowId((JCRAmetysObject)createdContent, (long)workflowId);
            Step currentStep = (Step)workflow.getCurrentSteps(workflowId).iterator().next();
            createdContent.setCurrentStepId((long)currentStep.getStepId());
        }

        private final class UnitaryContentImporter
        implements UnitaryImporter<DefaultContent> {
            private UnitaryContentImporter() {
            }

            @Override
            public String objectNameForLogs() {
                return "Content";
            }

            @Override
            public Document getPropertiesXml(Path zipEntryPath) throws Exception {
                return Importer.this._getContentPropertiesXml(zipEntryPath);
            }

            @Override
            public String retrieveId(Document propertiesXml) throws Exception {
                return Archivers.xpathEvalNonEmpty("content/@id", propertiesXml);
            }

            @Override
            public DefaultContent create(Path zipEntryPath, String id, Document propertiesXml) throws Archivers.AmetysObjectNotImportedException, Exception {
                DefaultContent createdContent = Importer.this._createContent(zipEntryPath, propertiesXml);
                Node contentNode = createdContent.getNode();
                Importer.this._createContentAcl(contentNode, zipEntryPath);
                Archivers.unitarySave(contentNode, Importer.this._logger);
                return createdContent;
            }

            @Override
            public ImportReport getReport() {
                return Importer.this._report;
            }
        }
    }

    @FunctionalInterface
    public static interface ContentFiller {
        public void fillContent(DefaultContent var1);
    }
}

