/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.contentio.csv;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;

import org.ametys.cms.contenttype.ContentType;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.authentication.AccessDeniedException;

/**
 * Helper handling CSV import of reference table entries
 */
public class ImportReferenceTablesCSVFileHelper extends ImportCSVFileHelper
{
    private CurrentUserProvider _currentUser;

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException
    {
        super.service(serviceManager);
        _currentUser = (CurrentUserProvider) serviceManager.lookup(CurrentUserProvider.ROLE);
    }
    
    // Override to change the rights to check for the {@link Callable}
    @Override
    @Callable (rights = "CMS_Rights_ReferenceTables_Import", context = "/cms")
    public Map<String, Object> importContents(Map<String, Object> config, Map<String, Object> formValues, List<Map<String, Object>> mappingValues) throws IOException
    {
        String contentTypeId = (String) config.get("contentType");
        ContentType contentType = _contentTypeEP.getExtension(contentTypeId);
        if (contentType.isReferenceTable())
        {
            return super.importContents(config, formValues, mappingValues);
        }
        else
        {
            UserIdentity user = _currentUser.getUser();
            throw new AccessDeniedException("User" + UserIdentity.userIdentityToString(user) + " tried to import reference table entries but this is not allowed for content type '" + contentTypeId + "'");
        }
    }
}
